% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_create_anomaly_subscription}
\alias{costexplorer_create_anomaly_subscription}
\title{Adds a subscription to a cost anomaly detection monitor}
\usage{
costexplorer_create_anomaly_subscription(AnomalySubscription)
}
\arguments{
\item{AnomalySubscription}{[required] The cost anomaly subscription object that you want to create.}
}
\value{
A list with the following syntax:\preformatted{list(
  SubscriptionArn = "string"
)
}
}
\description{
Adds a subscription to a cost anomaly detection monitor. You can use
each subscription to define subscribers with email or SNS notifications.
Email subscribers can set a dollar threshold and a time frequency for
receiving notifications.
}
\section{Request syntax}{
\preformatted{svc$create_anomaly_subscription(
  AnomalySubscription = list(
    SubscriptionArn = "string",
    AccountId = "string",
    MonitorArnList = list(
      "string"
    ),
    Subscribers = list(
      list(
        Address = "string",
        Type = "EMAIL"|"SNS",
        Status = "CONFIRMED"|"DECLINED"
      )
    ),
    Threshold = 123.0,
    Frequency = "DAILY"|"IMMEDIATE"|"WEEKLY",
    SubscriptionName = "string"
  )
)
}
}

\keyword{internal}
