# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Cost and Usage Report Service
#'
#' @description
#' You can use the Amazon Web Services Cost and Usage Report API to
#' programmatically create, query, and delete Amazon Web Services Cost and
#' Usage Report definitions.
#' 
#' Amazon Web Services Cost and Usage Report track the monthly Amazon Web
#' Services costs and usage associated with your Amazon Web Services
#' account. The report contains line items for each unique combination of
#' Amazon Web Services product, usage type, and operation that your Amazon
#' Web Services account uses. You can configure the Amazon Web Services
#' Cost and Usage Report to show only the data that you want, using the
#' Amazon Web Services Cost and Usage Report API.
#' 
#' Service Endpoint
#' 
#' The Amazon Web Services Cost and Usage Report API provides the following
#' endpoint:
#' 
#' -   cur.us-east-1.amazonaws.com
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- costandusagereportservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- costandusagereportservice()
#' # The following example deletes the AWS Cost and Usage report named
#' # ExampleReport.
#' svc$delete_report_definition(
#'   ReportName = "ExampleReport"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=costandusagereportservice_delete_report_definition]{delete_report_definition} \tab Deletes the specified report\cr
#'  \link[=costandusagereportservice_describe_report_definitions]{describe_report_definitions} \tab Lists the Amazon Web Services Cost and Usage Report available to this account\cr
#'  \link[=costandusagereportservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags associated with the specified report definition\cr
#'  \link[=costandusagereportservice_modify_report_definition]{modify_report_definition} \tab Allows you to programmatically update your report preferences\cr
#'  \link[=costandusagereportservice_put_report_definition]{put_report_definition} \tab Creates a new report using the description that you provide\cr
#'  \link[=costandusagereportservice_tag_resource]{tag_resource} \tab Associates a set of tags with a report definition\cr
#'  \link[=costandusagereportservice_untag_resource]{untag_resource} \tab Disassociates a set of tags from a report definition
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname costandusagereportservice
#' @export
costandusagereportservice <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .costandusagereportservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.costandusagereportservice <- list()

.costandusagereportservice$operations <- list()

.costandusagereportservice$metadata <- list(
  service_name = "cur",
  endpoints = list("*" = list(endpoint = "cur.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cur.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "cur.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "cur.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cur.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "cur.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Cost and Usage Report Service",
  api_version = "2017-01-06",
  signing_name = "cur",
  json_version = "1.1",
  target_prefix = "AWSOrigamiServiceGatewayService"
)

.costandusagereportservice$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.costandusagereportservice$metadata, handlers, config)
}
