% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_put_integration}
\alias{customerprofiles_put_integration}
\title{Adds an integration between the service and a third-party service, which
includes Amazon AppFlow and Amazon Connect}
\usage{
customerprofiles_put_integration(
  DomainName,
  Uri = NULL,
  ObjectTypeName = NULL,
  Tags = NULL,
  FlowDefinition = NULL,
  ObjectTypeNames = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{Uri}{The URI of the S3 bucket or any other type of data source.}

\item{ObjectTypeName}{The name of the profile object type.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}

\item{FlowDefinition}{The configuration that controls how Customer Profiles retrieves data
from the source.}

\item{ObjectTypeNames}{A map in which each key is an event type from an external application
such as Segment or Shopify, and each value is an \code{ObjectTypeName}
(template) used to ingest the event. It supports the following event
types: \code{SegmentIdentify}, \code{ShopifyCreateCustomers},
\code{ShopifyUpdateCustomers}, \code{ShopifyCreateDraftOrders},
\code{ShopifyUpdateDraftOrders}, \code{ShopifyCreateOrders}, and
\code{ShopifyUpdatedOrders}.}
}
\description{
Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_put_integration/} for full documentation.
}
\keyword{internal}
