# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include connectcampaignservice_service.R
NULL

#' Creates a campaign for the specified Amazon Connect account
#'
#' @description
#' Creates a campaign for the specified Amazon Connect account. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_create_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_create_campaign/) for full documentation.
#'
#' @param name &#91;required&#93; 
#' @param connectInstanceId &#91;required&#93; 
#' @param dialerConfig &#91;required&#93; 
#' @param outboundCallConfig &#91;required&#93; 
#' @param tags 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_create_campaign
connectcampaignservice_create_campaign <- function(name, connectInstanceId, dialerConfig, outboundCallConfig, tags = NULL) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "PUT",
    http_path = "/campaigns",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$create_campaign_input(name = name, connectInstanceId = connectInstanceId, dialerConfig = dialerConfig, outboundCallConfig = outboundCallConfig, tags = tags)
  output <- .connectcampaignservice$create_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$create_campaign <- connectcampaignservice_create_campaign

#' Deletes a campaign from the specified Amazon Connect account
#'
#' @description
#' Deletes a campaign from the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_delete_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_delete_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_delete_campaign
connectcampaignservice_delete_campaign <- function(id) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "DELETE",
    http_path = "/campaigns/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$delete_campaign_input(id = id)
  output <- .connectcampaignservice$delete_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$delete_campaign <- connectcampaignservice_delete_campaign

#' Deletes a connect instance config from the specified AWS account
#'
#' @description
#' Deletes a connect instance config from the specified AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_delete_connect_instance_config/](https://www.paws-r-sdk.com/docs/connectcampaignservice_delete_connect_instance_config/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_delete_connect_instance_config
connectcampaignservice_delete_connect_instance_config <- function(connectInstanceId) {
  op <- new_operation(
    name = "DeleteConnectInstanceConfig",
    http_method = "DELETE",
    http_path = "/connect-instance/{connectInstanceId}/config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$delete_connect_instance_config_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservice$delete_connect_instance_config_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$delete_connect_instance_config <- connectcampaignservice_delete_connect_instance_config

#' Delete the Connect Campaigns onboarding job for the specified Amazon
#' Connect instance
#'
#' @description
#' Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_delete_instance_onboarding_job/](https://www.paws-r-sdk.com/docs/connectcampaignservice_delete_instance_onboarding_job/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_delete_instance_onboarding_job
connectcampaignservice_delete_instance_onboarding_job <- function(connectInstanceId) {
  op <- new_operation(
    name = "DeleteInstanceOnboardingJob",
    http_method = "DELETE",
    http_path = "/connect-instance/{connectInstanceId}/onboarding",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$delete_instance_onboarding_job_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservice$delete_instance_onboarding_job_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$delete_instance_onboarding_job <- connectcampaignservice_delete_instance_onboarding_job

#' Describes the specific campaign
#'
#' @description
#' Describes the specific campaign.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_describe_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_describe_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_describe_campaign
connectcampaignservice_describe_campaign <- function(id) {
  op <- new_operation(
    name = "DescribeCampaign",
    http_method = "GET",
    http_path = "/campaigns/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$describe_campaign_input(id = id)
  output <- .connectcampaignservice$describe_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$describe_campaign <- connectcampaignservice_describe_campaign

#' Get state of a campaign for the specified Amazon Connect account
#'
#' @description
#' Get state of a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_get_campaign_state/](https://www.paws-r-sdk.com/docs/connectcampaignservice_get_campaign_state/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_get_campaign_state
connectcampaignservice_get_campaign_state <- function(id) {
  op <- new_operation(
    name = "GetCampaignState",
    http_method = "GET",
    http_path = "/campaigns/{id}/state",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$get_campaign_state_input(id = id)
  output <- .connectcampaignservice$get_campaign_state_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$get_campaign_state <- connectcampaignservice_get_campaign_state

#' Get state of campaigns for the specified Amazon Connect account
#'
#' @description
#' Get state of campaigns for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_get_campaign_state_batch/](https://www.paws-r-sdk.com/docs/connectcampaignservice_get_campaign_state_batch/) for full documentation.
#'
#' @param campaignIds &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_get_campaign_state_batch
connectcampaignservice_get_campaign_state_batch <- function(campaignIds) {
  op <- new_operation(
    name = "GetCampaignStateBatch",
    http_method = "POST",
    http_path = "/campaigns-state",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$get_campaign_state_batch_input(campaignIds = campaignIds)
  output <- .connectcampaignservice$get_campaign_state_batch_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$get_campaign_state_batch <- connectcampaignservice_get_campaign_state_batch

#' Get the specific Connect instance config
#'
#' @description
#' Get the specific Connect instance config.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_get_connect_instance_config/](https://www.paws-r-sdk.com/docs/connectcampaignservice_get_connect_instance_config/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_get_connect_instance_config
connectcampaignservice_get_connect_instance_config <- function(connectInstanceId) {
  op <- new_operation(
    name = "GetConnectInstanceConfig",
    http_method = "GET",
    http_path = "/connect-instance/{connectInstanceId}/config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$get_connect_instance_config_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservice$get_connect_instance_config_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$get_connect_instance_config <- connectcampaignservice_get_connect_instance_config

#' Get the specific instance onboarding job status
#'
#' @description
#' Get the specific instance onboarding job status.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_get_instance_onboarding_job_status/](https://www.paws-r-sdk.com/docs/connectcampaignservice_get_instance_onboarding_job_status/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_get_instance_onboarding_job_status
connectcampaignservice_get_instance_onboarding_job_status <- function(connectInstanceId) {
  op <- new_operation(
    name = "GetInstanceOnboardingJobStatus",
    http_method = "GET",
    http_path = "/connect-instance/{connectInstanceId}/onboarding",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$get_instance_onboarding_job_status_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservice$get_instance_onboarding_job_status_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$get_instance_onboarding_job_status <- connectcampaignservice_get_instance_onboarding_job_status

#' Provides summary information about the campaigns under the specified
#' Amazon Connect account
#'
#' @description
#' Provides summary information about the campaigns under the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_list_campaigns/](https://www.paws-r-sdk.com/docs/connectcampaignservice_list_campaigns/) for full documentation.
#'
#' @param maxResults 
#' @param nextToken 
#' @param filters 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_list_campaigns
connectcampaignservice_list_campaigns <- function(maxResults = NULL, nextToken = NULL, filters = NULL) {
  op <- new_operation(
    name = "ListCampaigns",
    http_method = "POST",
    http_path = "/campaigns-summary",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "campaignSummaryList"),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$list_campaigns_input(maxResults = maxResults, nextToken = nextToken, filters = filters)
  output <- .connectcampaignservice$list_campaigns_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$list_campaigns <- connectcampaignservice_list_campaigns

#' List tags for a resource
#'
#' @description
#' List tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/connectcampaignservice_list_tags_for_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_list_tags_for_resource
connectcampaignservice_list_tags_for_resource <- function(arn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$list_tags_for_resource_input(arn = arn)
  output <- .connectcampaignservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$list_tags_for_resource <- connectcampaignservice_list_tags_for_resource

#' Pauses a campaign for the specified Amazon Connect account
#'
#' @description
#' Pauses a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_pause_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_pause_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_pause_campaign
connectcampaignservice_pause_campaign <- function(id) {
  op <- new_operation(
    name = "PauseCampaign",
    http_method = "POST",
    http_path = "/campaigns/{id}/pause",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$pause_campaign_input(id = id)
  output <- .connectcampaignservice$pause_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$pause_campaign <- connectcampaignservice_pause_campaign

#' Creates dials requests for the specified campaign Amazon Connect account
#'
#' @description
#' Creates dials requests for the specified campaign Amazon Connect account. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_put_dial_request_batch/](https://www.paws-r-sdk.com/docs/connectcampaignservice_put_dial_request_batch/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param dialRequests &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_put_dial_request_batch
connectcampaignservice_put_dial_request_batch <- function(id, dialRequests) {
  op <- new_operation(
    name = "PutDialRequestBatch",
    http_method = "PUT",
    http_path = "/campaigns/{id}/dial-requests",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$put_dial_request_batch_input(id = id, dialRequests = dialRequests)
  output <- .connectcampaignservice$put_dial_request_batch_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$put_dial_request_batch <- connectcampaignservice_put_dial_request_batch

#' Stops a campaign for the specified Amazon Connect account
#'
#' @description
#' Stops a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_resume_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_resume_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_resume_campaign
connectcampaignservice_resume_campaign <- function(id) {
  op <- new_operation(
    name = "ResumeCampaign",
    http_method = "POST",
    http_path = "/campaigns/{id}/resume",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$resume_campaign_input(id = id)
  output <- .connectcampaignservice$resume_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$resume_campaign <- connectcampaignservice_resume_campaign

#' Starts a campaign for the specified Amazon Connect account
#'
#' @description
#' Starts a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_start_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_start_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_start_campaign
connectcampaignservice_start_campaign <- function(id) {
  op <- new_operation(
    name = "StartCampaign",
    http_method = "POST",
    http_path = "/campaigns/{id}/start",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$start_campaign_input(id = id)
  output <- .connectcampaignservice$start_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$start_campaign <- connectcampaignservice_start_campaign

#' Onboard the specific Amazon Connect instance to Connect Campaigns
#'
#' @description
#' Onboard the specific Amazon Connect instance to Connect Campaigns.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_start_instance_onboarding_job/](https://www.paws-r-sdk.com/docs/connectcampaignservice_start_instance_onboarding_job/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#' @param encryptionConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_start_instance_onboarding_job
connectcampaignservice_start_instance_onboarding_job <- function(connectInstanceId, encryptionConfig) {
  op <- new_operation(
    name = "StartInstanceOnboardingJob",
    http_method = "PUT",
    http_path = "/connect-instance/{connectInstanceId}/onboarding",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$start_instance_onboarding_job_input(connectInstanceId = connectInstanceId, encryptionConfig = encryptionConfig)
  output <- .connectcampaignservice$start_instance_onboarding_job_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$start_instance_onboarding_job <- connectcampaignservice_start_instance_onboarding_job

#' Stops a campaign for the specified Amazon Connect account
#'
#' @description
#' Stops a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_stop_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservice_stop_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_stop_campaign
connectcampaignservice_stop_campaign <- function(id) {
  op <- new_operation(
    name = "StopCampaign",
    http_method = "POST",
    http_path = "/campaigns/{id}/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$stop_campaign_input(id = id)
  output <- .connectcampaignservice$stop_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$stop_campaign <- connectcampaignservice_stop_campaign

#' Tag a resource
#'
#' @description
#' Tag a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_tag_resource/](https://www.paws-r-sdk.com/docs/connectcampaignservice_tag_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; 
#' @param tags &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_tag_resource
connectcampaignservice_tag_resource <- function(arn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$tag_resource_input(arn = arn, tags = tags)
  output <- .connectcampaignservice$tag_resource_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$tag_resource <- connectcampaignservice_tag_resource

#' Untag a resource
#'
#' @description
#' Untag a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_untag_resource/](https://www.paws-r-sdk.com/docs/connectcampaignservice_untag_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; 
#' @param tagKeys &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_untag_resource
connectcampaignservice_untag_resource <- function(arn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$untag_resource_input(arn = arn, tagKeys = tagKeys)
  output <- .connectcampaignservice$untag_resource_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$untag_resource <- connectcampaignservice_untag_resource

#' Updates the dialer config of a campaign
#'
#' @description
#' Updates the dialer config of a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_update_campaign_dialer_config/](https://www.paws-r-sdk.com/docs/connectcampaignservice_update_campaign_dialer_config/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param dialerConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_update_campaign_dialer_config
connectcampaignservice_update_campaign_dialer_config <- function(id, dialerConfig) {
  op <- new_operation(
    name = "UpdateCampaignDialerConfig",
    http_method = "POST",
    http_path = "/campaigns/{id}/dialer-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$update_campaign_dialer_config_input(id = id, dialerConfig = dialerConfig)
  output <- .connectcampaignservice$update_campaign_dialer_config_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$update_campaign_dialer_config <- connectcampaignservice_update_campaign_dialer_config

#' Updates the name of a campaign
#'
#' @description
#' Updates the name of a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_update_campaign_name/](https://www.paws-r-sdk.com/docs/connectcampaignservice_update_campaign_name/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param name &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_update_campaign_name
connectcampaignservice_update_campaign_name <- function(id, name) {
  op <- new_operation(
    name = "UpdateCampaignName",
    http_method = "POST",
    http_path = "/campaigns/{id}/name",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$update_campaign_name_input(id = id, name = name)
  output <- .connectcampaignservice$update_campaign_name_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$update_campaign_name <- connectcampaignservice_update_campaign_name

#' Updates the outbound call config of a campaign
#'
#' @description
#' Updates the outbound call config of a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservice_update_campaign_outbound_call_config/](https://www.paws-r-sdk.com/docs/connectcampaignservice_update_campaign_outbound_call_config/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param connectContactFlowId 
#' @param connectSourcePhoneNumber 
#' @param answerMachineDetectionConfig 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservice_update_campaign_outbound_call_config
connectcampaignservice_update_campaign_outbound_call_config <- function(id, connectContactFlowId = NULL, connectSourcePhoneNumber = NULL, answerMachineDetectionConfig = NULL) {
  op <- new_operation(
    name = "UpdateCampaignOutboundCallConfig",
    http_method = "POST",
    http_path = "/campaigns/{id}/outbound-call-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservice$update_campaign_outbound_call_config_input(id = id, connectContactFlowId = connectContactFlowId, connectSourcePhoneNumber = connectSourcePhoneNumber, answerMachineDetectionConfig = answerMachineDetectionConfig)
  output <- .connectcampaignservice$update_campaign_outbound_call_config_output()
  config <- get_config()
  svc <- .connectcampaignservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservice$operations$update_campaign_outbound_call_config <- connectcampaignservice_update_campaign_outbound_call_config
