% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_execute_transaction}
\alias{dynamodb_execute_transaction}
\title{This operation allows you to perform transactional reads or writes on
data stored in DynamoDB, using PartiQL}
\usage{
dynamodb_execute_transaction(TransactStatements, ClientRequestToken)
}
\arguments{
\item{TransactStatements}{[required] The list of PartiQL statements representing the transaction to run.}

\item{ClientRequestToken}{Set this value to get remaining results, if \code{NextToken} was returned in
the statement response.}
}
\description{
This operation allows you to perform transactional reads or writes on
data stored in DynamoDB, using PartiQL.
}
\section{Request syntax}{
\preformatted{svc$execute_transaction(
  TransactStatements = list(
    list(
      Statement = "string",
      Parameters = list(
        list(
          S = "string",
          N = "string",
          B = raw,
          SS = list(
            "string"
          ),
          NS = list(
            "string"
          ),
          BS = list(
            raw
          ),
          M = list(
            list()
          ),
          L = list(
            list()
          ),
          NULL = TRUE|FALSE,
          BOOL = TRUE|FALSE
        )
      )
    )
  ),
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
