# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include keyspaces_service.R
NULL

#' The CreateKeyspace operation adds a new keyspace to your account
#'
#' @description
#' The [`create_keyspace`][keyspaces_create_keyspace] operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.
#'
#' See [https://paws-r.github.io/docs/keyspaces/create_keyspace.html](https://paws-r.github.io/docs/keyspaces/create_keyspace.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace to be created.
#' @param tags A list of key-value pair tags to be attached to the keyspace.
#' 
#' For more information, see [Adding tags and labels to Amazon Keyspaces
#' resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
#' in the *Amazon Keyspaces Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname keyspaces_create_keyspace
keyspaces_create_keyspace <- function(keyspaceName, tags = NULL) {
  op <- new_operation(
    name = "CreateKeyspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$create_keyspace_input(keyspaceName = keyspaceName, tags = tags)
  output <- .keyspaces$create_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$create_keyspace <- keyspaces_create_keyspace

#' The CreateTable operation adds a new table to the specified keyspace
#'
#' @description
#' The [`create_table`][keyspaces_create_table] operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.
#'
#' See [https://paws-r.github.io/docs/keyspaces/create_table.html](https://paws-r.github.io/docs/keyspaces/create_table.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace that the table is going to be created in.
#' @param tableName &#91;required&#93; The name of the table.
#' @param schemaDefinition &#91;required&#93; The `schemaDefinition` consists of the following parameters.
#' 
#' For each column to be created:
#' 
#' • `name` - The name of the column.
#' 
#' • `type` - An Amazon Keyspaces data type. For more information, see
#' [Data
#' types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
#' in the *Amazon Keyspaces Developer Guide*.
#' 
#' The primary key of the table consists of the following columns:
#' 
#' • `partitionKeys` - The partition key can be a single column, or it can
#' be a compound value composed of two or more columns. The partition key
#' portion of the primary key is required and determines how Amazon
#' Keyspaces stores your data.
#' 
#' • `name` - The name of each partition key column.
#' 
#' • `clusteringKeys` - The optional clustering column portion of your
#' primary key determines how the data is clustered and sorted within each
#' partition.
#' 
#' • `name` - The name of the clustering column.
#' 
#' • `orderBy` - Sets the ascendant (`ASC`) or descendant (`DESC`) order
#' modifier.
#' 
#' To define a column as static use `staticColumns` - Static columns store
#' values that are shared by all rows in the same partition:
#' 
#' • `name` - The name of the column.
#' 
#' • `type` - An Amazon Keyspaces data type.
#' @param comment This parameter allows to enter a description of the table.
#' @param capacitySpecification Specifies the read/write throughput capacity mode for the table. The
#' options are:
#' 
#' • `throughputMode:PAY_PER_REQUEST` and
#' 
#' • `throughputMode:PROVISIONED` - Provisioned capacity mode requires
#' `readCapacityUnits` and `writeCapacityUnits` as input.
#' 
#' The default is `throughput_mode:PAY_PER_REQUEST`.
#' 
#' For more information, see [Read/write capacity
#' modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param encryptionSpecification Specifies how the encryption key for encryption at rest is managed for
#' the table. You can choose one of the following KMS key (KMS key):
#' 
#' • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
#' 
#' • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account
#' and is created, owned, and managed by you. This option requires the
#' `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format
#' as input.
#' 
#' The default is `type:AWS_OWNED_KMS_KEY`.
#' 
#' For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param pointInTimeRecovery Specifies if `pointInTimeRecovery` is enabled or disabled for the table.
#' The options are:
#' 
#' • `ENABLED`
#' 
#' • `DISABLED`
#' 
#' If it's not specified, the default is `DISABLED`.
#' 
#' For more information, see [Point-in-time
#' recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param ttl Enables Time to Live custom settings for the table. The options are:
#' 
#' • `status:enabled`
#' 
#' • `status:disabled`
#' 
#' The default is `status:disabled`. After `ttl` is enabled, you can't
#' disable it for the table.
#' 
#' For more information, see [Expiring data by using Amazon Keyspaces Time
#' to Live
#' (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param defaultTimeToLive The default Time to Live setting in seconds for the table.
#' 
#' For more information, see [Setting the default TTL value for a
#' table](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param tags A list of key-value pair tags to be attached to the resource.
#' 
#' For more information, see [Adding tags and labels to Amazon Keyspaces
#' resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
#' in the *Amazon Keyspaces Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname keyspaces_create_table
keyspaces_create_table <- function(keyspaceName, tableName, schemaDefinition, comment = NULL, capacitySpecification = NULL, encryptionSpecification = NULL, pointInTimeRecovery = NULL, ttl = NULL, defaultTimeToLive = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$create_table_input(keyspaceName = keyspaceName, tableName = tableName, schemaDefinition = schemaDefinition, comment = comment, capacitySpecification = capacitySpecification, encryptionSpecification = encryptionSpecification, pointInTimeRecovery = pointInTimeRecovery, ttl = ttl, defaultTimeToLive = defaultTimeToLive, tags = tags)
  output <- .keyspaces$create_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$create_table <- keyspaces_create_table

#' The DeleteKeyspace operation deletes a keyspace and all of its tables
#'
#' @description
#' The [`delete_keyspace`][keyspaces_delete_keyspace] operation deletes a keyspace and all of its tables.
#'
#' See [https://paws-r.github.io/docs/keyspaces/delete_keyspace.html](https://paws-r.github.io/docs/keyspaces/delete_keyspace.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace to be deleted.
#'
#' @keywords internal
#'
#' @rdname keyspaces_delete_keyspace
keyspaces_delete_keyspace <- function(keyspaceName) {
  op <- new_operation(
    name = "DeleteKeyspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$delete_keyspace_input(keyspaceName = keyspaceName)
  output <- .keyspaces$delete_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$delete_keyspace <- keyspaces_delete_keyspace

#' The DeleteTable operation deletes a table and all of its data
#'
#' @description
#' The [`delete_table`][keyspaces_delete_table] operation deletes a table and all of its data. After a [`delete_table`][keyspaces_delete_table] request is received, the specified table is in the `DELETING` state until Amazon Keyspaces completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is either in the `CREATING` or `UPDATING` states, then Amazon Keyspaces returns a `ResourceInUseException`. If the specified table does not exist, Amazon Keyspaces returns a `ResourceNotFoundException`. If the table is already in the `DELETING` state, no error is returned.
#'
#' See [https://paws-r.github.io/docs/keyspaces/delete_table.html](https://paws-r.github.io/docs/keyspaces/delete_table.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace of the to be deleted table.
#' @param tableName &#91;required&#93; The name of the table to be deleted.
#'
#' @keywords internal
#'
#' @rdname keyspaces_delete_table
keyspaces_delete_table <- function(keyspaceName, tableName) {
  op <- new_operation(
    name = "DeleteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$delete_table_input(keyspaceName = keyspaceName, tableName = tableName)
  output <- .keyspaces$delete_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$delete_table <- keyspaces_delete_table

#' Returns the name and the Amazon Resource Name (ARN) of the specified
#' table
#'
#' @description
#' Returns the name and the Amazon Resource Name (ARN) of the specified table.
#'
#' See [https://paws-r.github.io/docs/keyspaces/get_keyspace.html](https://paws-r.github.io/docs/keyspaces/get_keyspace.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#'
#' @keywords internal
#'
#' @rdname keyspaces_get_keyspace
keyspaces_get_keyspace <- function(keyspaceName) {
  op <- new_operation(
    name = "GetKeyspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$get_keyspace_input(keyspaceName = keyspaceName)
  output <- .keyspaces$get_keyspace_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$get_keyspace <- keyspaces_get_keyspace

#' Returns information about the table, including the table's name and
#' current status, the keyspace name, configuration settings, and metadata
#'
#' @description
#' Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.
#'
#' See [https://paws-r.github.io/docs/keyspaces/get_table.html](https://paws-r.github.io/docs/keyspaces/get_table.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace that the table is stored in.
#' @param tableName &#91;required&#93; The name of the table.
#'
#' @keywords internal
#'
#' @rdname keyspaces_get_table
keyspaces_get_table <- function(keyspaceName, tableName) {
  op <- new_operation(
    name = "GetTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$get_table_input(keyspaceName = keyspaceName, tableName = tableName)
  output <- .keyspaces$get_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$get_table <- keyspaces_get_table

#' Returns a list of keyspaces
#'
#' @description
#' Returns a list of keyspaces.
#'
#' See [https://paws-r.github.io/docs/keyspaces/list_keyspaces.html](https://paws-r.github.io/docs/keyspaces/list_keyspaces.html) for full documentation.
#'
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as argument of a subsequent API invocation.
#' @param maxResults The total number of keyspaces to return in the output. If the total
#' number of keyspaces available is more than the value specified, a
#' `NextToken` is provided in the output. To resume pagination, provide the
#' `NextToken` value as an argument of a subsequent API invocation.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_keyspaces
keyspaces_list_keyspaces <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListKeyspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$list_keyspaces_input(nextToken = nextToken, maxResults = maxResults)
  output <- .keyspaces$list_keyspaces_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_keyspaces <- keyspaces_list_keyspaces

#' Returns a list of tables for a specified keyspace
#'
#' @description
#' Returns a list of tables for a specified keyspace.
#'
#' See [https://paws-r.github.io/docs/keyspaces/list_tables.html](https://paws-r.github.io/docs/keyspaces/list_tables.html) for full documentation.
#'
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#' @param maxResults The total number of tables to return in the output. If the total number
#' of tables available is more than the value specified, a `NextToken` is
#' provided in the output. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#' @param keyspaceName &#91;required&#93; The name of the keyspace.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_tables
keyspaces_list_tables <- function(nextToken = NULL, maxResults = NULL, keyspaceName) {
  op <- new_operation(
    name = "ListTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$list_tables_input(nextToken = nextToken, maxResults = maxResults, keyspaceName = keyspaceName)
  output <- .keyspaces$list_tables_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_tables <- keyspaces_list_tables

#' Returns a list of all tags associated with the specified Amazon
#' Keyspaces resource
#'
#' @description
#' Returns a list of all tags associated with the specified Amazon Keyspaces resource.
#'
#' See [https://paws-r.github.io/docs/keyspaces/list_tags_for_resource.html](https://paws-r.github.io/docs/keyspaces/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Keyspaces resource.
#' @param nextToken The pagination token. To resume pagination, provide the `NextToken`
#' value as argument of a subsequent API invocation.
#' @param maxResults The total number of tags to return in the output. If the total number of
#' tags available is more than the value specified, a `NextToken` is
#' provided in the output. To resume pagination, provide the `NextToken`
#' value as an argument of a subsequent API invocation.
#'
#' @keywords internal
#'
#' @rdname keyspaces_list_tags_for_resource
keyspaces_list_tags_for_resource <- function(resourceArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$list_tags_for_resource_input(resourceArn = resourceArn, nextToken = nextToken, maxResults = maxResults)
  output <- .keyspaces$list_tags_for_resource_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$list_tags_for_resource <- keyspaces_list_tags_for_resource

#' Restores the specified table to the specified point in time within the
#' earliest_restorable_timestamp and the current time
#'
#' @description
#' Restores the specified table to the specified point in time within the `earliest_restorable_timestamp` and the current time. For more information about restore points, see [Time window for PITR continuous backups](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window) in the *Amazon Keyspaces Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/keyspaces/restore_table.html](https://paws-r.github.io/docs/keyspaces/restore_table.html) for full documentation.
#'
#' @param sourceKeyspaceName &#91;required&#93; The keyspace name of the source table.
#' @param sourceTableName &#91;required&#93; The name of the source table.
#' @param targetKeyspaceName &#91;required&#93; The name of the target keyspace.
#' @param targetTableName &#91;required&#93; The name of the target table.
#' @param restoreTimestamp The restore timestamp in ISO 8601 format.
#' @param capacitySpecificationOverride Specifies the read/write throughput capacity mode for the target table.
#' The options are:
#' 
#' • `throughputMode:PAY_PER_REQUEST`
#' 
#' • `throughputMode:PROVISIONED` - Provisioned capacity mode requires
#' `readCapacityUnits` and `writeCapacityUnits` as input.
#' 
#' The default is `throughput_mode:PAY_PER_REQUEST`.
#' 
#' For more information, see [Read/write capacity
#' modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param encryptionSpecificationOverride Specifies the encryption settings for the target table. You can choose
#' one of the following KMS key (KMS key):
#' 
#' • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
#' 
#' • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account
#' and is created, owned, and managed by you. This option requires the
#' `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format
#' as input.
#' 
#' The default is `type:AWS_OWNED_KMS_KEY`.
#' 
#' For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param pointInTimeRecoveryOverride Specifies the `pointInTimeRecovery` settings for the target table. The
#' options are:
#' 
#' • `ENABLED`
#' 
#' • `DISABLED`
#' 
#' If it's not specified, the default is `DISABLED`.
#' 
#' For more information, see [Point-in-time
#' recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param tagsOverride A list of key-value pair tags to be attached to the restored table.
#' 
#' For more information, see [Adding tags and labels to Amazon Keyspaces
#' resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html)
#' in the *Amazon Keyspaces Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname keyspaces_restore_table
keyspaces_restore_table <- function(sourceKeyspaceName, sourceTableName, targetKeyspaceName, targetTableName, restoreTimestamp = NULL, capacitySpecificationOverride = NULL, encryptionSpecificationOverride = NULL, pointInTimeRecoveryOverride = NULL, tagsOverride = NULL) {
  op <- new_operation(
    name = "RestoreTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$restore_table_input(sourceKeyspaceName = sourceKeyspaceName, sourceTableName = sourceTableName, targetKeyspaceName = targetKeyspaceName, targetTableName = targetTableName, restoreTimestamp = restoreTimestamp, capacitySpecificationOverride = capacitySpecificationOverride, encryptionSpecificationOverride = encryptionSpecificationOverride, pointInTimeRecoveryOverride = pointInTimeRecoveryOverride, tagsOverride = tagsOverride)
  output <- .keyspaces$restore_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$restore_table <- keyspaces_restore_table

#' Associates a set of tags with a Amazon Keyspaces resource
#'
#' @description
#' Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/keyspaces/tag_resource.html](https://paws-r.github.io/docs/keyspaces/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Keyspaces resource to which
#' to add tags.
#' @param tags &#91;required&#93; The tags to be assigned to the Amazon Keyspaces resource.
#'
#' @keywords internal
#'
#' @rdname keyspaces_tag_resource
keyspaces_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .keyspaces$tag_resource_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$tag_resource <- keyspaces_tag_resource

#' Removes the association of tags from a Amazon Keyspaces resource
#'
#' @description
#' Removes the association of tags from a Amazon Keyspaces resource.
#'
#' See [https://paws-r.github.io/docs/keyspaces/untag_resource.html](https://paws-r.github.io/docs/keyspaces/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Keyspaces resource that the tags will be removed from. This
#' value is an Amazon Resource Name (ARN).
#' @param tags &#91;required&#93; A list of existing tags to be removed from the Amazon Keyspaces
#' resource.
#'
#' @keywords internal
#'
#' @rdname keyspaces_untag_resource
keyspaces_untag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$untag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .keyspaces$untag_resource_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$untag_resource <- keyspaces_untag_resource

#' Adds new columns to the table or updates one of the table's settings,
#' for example capacity mode, encryption, point-in-time recovery, or ttl
#' settings
#'
#' @description
#' Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.
#'
#' See [https://paws-r.github.io/docs/keyspaces/update_table.html](https://paws-r.github.io/docs/keyspaces/update_table.html) for full documentation.
#'
#' @param keyspaceName &#91;required&#93; The name of the keyspace the specified table is stored in.
#' @param tableName &#91;required&#93; The name of the table.
#' @param addColumns For each column to be added to the specified table:
#' 
#' • `name` - The name of the column.
#' 
#' • `type` - An Amazon Keyspaces data type. For more information, see
#' [Data
#' types](https://docs.aws.amazon.com/keyspaces/latest/devguide/cql.elements.html#cql.data-types)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param capacitySpecification Modifies the read/write throughput capacity mode for the table. The
#' options are:
#' 
#' • `throughputMode:PAY_PER_REQUEST` and
#' 
#' • `throughputMode:PROVISIONED` - Provisioned capacity mode requires
#' `readCapacityUnits` and `writeCapacityUnits` as input.
#' 
#' The default is `throughput_mode:PAY_PER_REQUEST`.
#' 
#' For more information, see [Read/write capacity
#' modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param encryptionSpecification Modifies the encryption settings of the table. You can choose one of the
#' following KMS key (KMS key):
#' 
#' • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
#' 
#' • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account
#' and is created, owned, and managed by you. This option requires the
#' `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format
#' as input.
#' 
#' The default is `AWS_OWNED_KMS_KEY`.
#' 
#' For more information, see [Encryption at
#' rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param pointInTimeRecovery Modifies the `pointInTimeRecovery` settings of the table. The options
#' are:
#' 
#' • `ENABLED`
#' 
#' • `DISABLED`
#' 
#' If it's not specified, the default is `DISABLED`.
#' 
#' For more information, see [Point-in-time
#' recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param ttl Modifies Time to Live custom settings for the table. The options are:
#' 
#' • `status:enabled`
#' 
#' • `status:disabled`
#' 
#' The default is `status:disabled`. After `ttl` is enabled, you can't
#' disable it for the table.
#' 
#' For more information, see [Expiring data by using Amazon Keyspaces Time
#' to Live
#' (TTL)](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL.html)
#' in the *Amazon Keyspaces Developer Guide*.
#' @param defaultTimeToLive The default Time to Live setting in seconds for the table.
#' 
#' For more information, see [Setting the default TTL value for a
#' table](https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl)
#' in the *Amazon Keyspaces Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname keyspaces_update_table
keyspaces_update_table <- function(keyspaceName, tableName, addColumns = NULL, capacitySpecification = NULL, encryptionSpecification = NULL, pointInTimeRecovery = NULL, ttl = NULL, defaultTimeToLive = NULL) {
  op <- new_operation(
    name = "UpdateTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .keyspaces$update_table_input(keyspaceName = keyspaceName, tableName = tableName, addColumns = addColumns, capacitySpecification = capacitySpecification, encryptionSpecification = encryptionSpecification, pointInTimeRecovery = pointInTimeRecovery, ttl = ttl, defaultTimeToLive = defaultTimeToLive)
  output <- .keyspaces$update_table_output()
  config <- get_config()
  svc <- .keyspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.keyspaces$operations$update_table <- keyspaces_update_table
