% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_create_cache_parameter_group}
\alias{elasticache_create_cache_parameter_group}
\title{Creates a new Amazon ElastiCache cache parameter group}
\usage{
elasticache_create_cache_parameter_group(
  CacheParameterGroupName,
  CacheParameterGroupFamily,
  Description,
  Tags = NULL
)
}
\arguments{
\item{CacheParameterGroupName}{[required] A user-specified name for the cache parameter group.}

\item{CacheParameterGroupFamily}{[required] The name of the cache parameter group family that the cache parameter
group can be used with.

Valid values are: \code{memcached1.4} | \code{memcached1.5} | \code{memcached1.6} |
\code{redis2.6} | \code{redis2.8} | \code{redis3.2} | \code{redis4.0} | \code{redis5.0} |
\code{redis6.x}}

\item{Description}{[required] A user-specified description for the cache parameter group.}

\item{Tags}{A list of tags to be added to this resource. A tag is a key-value pair.
A tag key must be accompanied by a tag value, although null is accepted.}
}
\description{
Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.

See \url{https://paws-r.github.io/docs/elasticache/create_cache_parameter_group.html} for full documentation.
}
\keyword{internal}
