% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_delete_lf_tag}
\alias{lakeformation_delete_lf_tag}
\title{Deletes the specified LF-tag key name}
\usage{
lakeformation_delete_lf_tag(CatalogId = NULL, TagKey)
}
\arguments{
\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{TagKey}{[required] The key-name for the LF-tag to delete.}
}
\description{
Deletes the specified LF-tag key name. If the attribute key does not exist or the LF-tag does not exist, then the operation will not do anything. If the attribute key exists, then the operation checks if any resources are tagged with this attribute key, if yes, the API throws a 400 Exception with the message "Delete not allowed" as the LF-tag key is still attached with resources. You can consider untagging resources with this LF-tag key.

See \url{https://paws-r.github.io/docs/lakeformation/delete_lf_tag.html} for full documentation.
}
\keyword{internal}
