% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_update_lf_tag}
\alias{lakeformation_update_lf_tag}
\title{Updates the list of possible values for the specified LF-tag key}
\usage{
lakeformation_update_lf_tag(
  CatalogId = NULL,
  TagKey,
  TagValuesToDelete = NULL,
  TagValuesToAdd = NULL
)
}
\arguments{
\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{TagKey}{[required] The key-name for the LF-tag for which to add or delete values.}

\item{TagValuesToDelete}{A list of LF-tag values to delete from the LF-tag.}

\item{TagValuesToAdd}{A list of LF-tag values to add from the LF-tag.}
}
\description{
Updates the list of possible values for the specified LF-tag key. If the LF-tag does not exist, the operation throws an EntityNotFoundException. The values in the delete key values will be deleted from list of possible values. If any value in the delete key values is attached to a resource, then API errors out with a 400 Exception - "Update not allowed". Untag the attribute before deleting the LF-tag key's value.

See \url{https://paws-r.github.io/docs/lakeformation/update_lf_tag.html} for full documentation.
}
\keyword{internal}
