% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_update_table}
\alias{dynamodb_update_table}
\title{Modifies the provisioned throughput settings, global secondary indexes,
or DynamoDB Streams settings for a given table}
\usage{
dynamodb_update_table(
  AttributeDefinitions = NULL,
  TableName,
  BillingMode = NULL,
  ProvisionedThroughput = NULL,
  GlobalSecondaryIndexUpdates = NULL,
  StreamSpecification = NULL,
  SSESpecification = NULL,
  ReplicaUpdates = NULL,
  TableClass = NULL,
  DeletionProtectionEnabled = NULL,
  OnDemandThroughput = NULL
)
}
\arguments{
\item{AttributeDefinitions}{An array of attributes that describe the key schema for the table and
indexes. If you are adding a new global secondary index to the table,
\code{AttributeDefinitions} must include the key element(s) of the new index.}

\item{TableName}{[required] The name of the table to be updated. You can also provide the Amazon
Resource Name (ARN) of the table in this parameter.}

\item{BillingMode}{Controls how you are charged for read and write throughput and how you
manage capacity. When switching from pay-per-request to provisioned
capacity, initial provisioned capacity values must be set. The initial
provisioned capacity values are estimated based on the consumed read and
write capacity of your table and global secondary indexes over the past
30 minutes.
\itemize{
\item \code{PROVISIONED} - We recommend using \code{PROVISIONED} for predictable
workloads. \code{PROVISIONED} sets the billing mode to \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/provisioned-capacity-mode.html}{Provisioned capacity mode}.
\item \code{PAY_PER_REQUEST} - We recommend using \code{PAY_PER_REQUEST} for
unpredictable workloads. \code{PAY_PER_REQUEST} sets the billing mode to
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/on-demand-capacity-mode.html}{On-demand capacity mode}.
}}

\item{ProvisionedThroughput}{The new provisioned throughput settings for the specified table or
index.}

\item{GlobalSecondaryIndexUpdates}{An array of one or more global secondary indexes for the table. For each
index in the array, you can request one action:
\itemize{
\item \code{Create} - add a new global secondary index to the table.
\item \code{Update} - modify the provisioned throughput settings of an existing
global secondary index.
\item \code{Delete} - remove a global secondary index from the table.
}

You can create or delete only one global secondary index per
\code{\link[=dynamodb_update_table]{update_table}} operation.

For more information, see \href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html}{Managing Global Secondary Indexes}
in the \emph{Amazon DynamoDB Developer Guide}.}

\item{StreamSpecification}{Represents the DynamoDB Streams configuration for the table.

You receive a \code{ValidationException} if you try to enable a stream on a
table that already has a stream, or if you try to disable a stream on a
table that doesn't have a stream.}

\item{SSESpecification}{The new server-side encryption settings for the specified table.}

\item{ReplicaUpdates}{A list of replica update actions (create, delete, or update) for the
table.

For global tables, this property only applies to global tables using
Version 2019.11.21 (Current version).}

\item{TableClass}{The table class of the table to be updated. Valid values are \code{STANDARD}
and \code{STANDARD_INFREQUENT_ACCESS}.}

\item{DeletionProtectionEnabled}{Indicates whether deletion protection is to be enabled (true) or
disabled (false) on the table.}

\item{OnDemandThroughput}{Updates the maximum number of read and write units for the specified
table in on-demand capacity mode. If you use this parameter, you must
specify \code{MaxReadRequestUnits}, \code{MaxWriteRequestUnits}, or both.}
}
\description{
Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_update_table/} for full documentation.
}
\keyword{internal}
