% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_comment_reactions}
\alias{codecommit_get_comment_reactions}
\title{Returns information about reactions to a specified comment ID}
\usage{
codecommit_get_comment_reactions(commentId, reactionUserArn, nextToken,
  maxResults)
}
\arguments{
\item{commentId}{[required] The ID of the comment for which you want to get reactions information.}

\item{reactionUserArn}{Optional. The Amazon Resource Name (ARN) of the user or identity for
which you want to get reaction information.}

\item{nextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}

\item{maxResults}{A non-zero, non-negative integer used to limit the number of returned
results. The default is the same as the allowed maximum, 1,000.}
}
\value{
A list with the following syntax:\preformatted{list(
  reactionsForComment = list(
    list(
      reaction = list(
        emoji = "string",
        shortCode = "string",
        unicode = "string"
      ),
      reactionUsers = list(
        "string"
      ),
      reactionsFromDeletedUsersCount = 123
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns information about reactions to a specified comment ID. Reactions
from users who have been deleted will not be included in the count.
}
\section{Request syntax}{
\preformatted{svc$get_comment_reactions(
  commentId = "string",
  reactionUserArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
