% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_batch_get_deployment_targets}
\alias{codedeploy_batch_get_deployment_targets}
\title{Returns an array of one or more targets associated with a deployment}
\usage{
codedeploy_batch_get_deployment_targets(deploymentId, targetIds)
}
\arguments{
\item{deploymentId}{The unique ID of a deployment.}

\item{targetIds}{The unique IDs of the deployment targets. The compute platform of the
deployment determines the type of the targets and their formats. The
maximum number of deployment target IDs you can specify is 25.
\itemize{
\item For deployments that use the EC2/On-premises compute platform, the
target IDs are EC2 or on-premises instances IDs, and their target
type is \code{instanceTarget}.
\item For deployments that use the AWS Lambda compute platform, the target
IDs are the names of Lambda functions, and their target type is
\code{instanceTarget}.
\item For deployments that use the Amazon ECS compute platform, the target
IDs are pairs of Amazon ECS clusters and services specified using
the format \verb{<clustername>:<servicename>}. Their target type is
\code{ecsTarget}.
\item For deployments that are deployed with AWS CloudFormation, the
target IDs are CloudFormation stack IDs. Their target type is
\code{cloudFormationTarget}.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  deploymentTargets = list(
    list(
      deploymentTargetType = "InstanceTarget"|"LambdaTarget"|"ECSTarget"|"CloudFormationTarget",
      instanceTarget = list(
        deploymentId = "string",
        targetId = "string",
        targetArn = "string",
        status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
        lastUpdatedAt = as.POSIXct(
          "2015-01-01"
        ),
        lifecycleEvents = list(
          list(
            lifecycleEventName = "string",
            diagnostics = list(
              errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
              scriptName = "string",
              message = "string",
              logTail = "string"
            ),
            startTime = as.POSIXct(
              "2015-01-01"
            ),
            endTime = as.POSIXct(
              "2015-01-01"
            ),
            status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
          )
        ),
        instanceLabel = "Blue"|"Green"
      ),
      lambdaTarget = list(
        deploymentId = "string",
        targetId = "string",
        targetArn = "string",
        status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
        lastUpdatedAt = as.POSIXct(
          "2015-01-01"
        ),
        lifecycleEvents = list(
          list(
            lifecycleEventName = "string",
            diagnostics = list(
              errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
              scriptName = "string",
              message = "string",
              logTail = "string"
            ),
            startTime = as.POSIXct(
              "2015-01-01"
            ),
            endTime = as.POSIXct(
              "2015-01-01"
            ),
            status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
          )
        ),
        lambdaFunctionInfo = list(
          functionName = "string",
          functionAlias = "string",
          currentVersion = "string",
          targetVersion = "string",
          targetVersionWeight = 123.0
        )
      ),
      ecsTarget = list(
        deploymentId = "string",
        targetId = "string",
        targetArn = "string",
        lastUpdatedAt = as.POSIXct(
          "2015-01-01"
        ),
        lifecycleEvents = list(
          list(
            lifecycleEventName = "string",
            diagnostics = list(
              errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
              scriptName = "string",
              message = "string",
              logTail = "string"
            ),
            startTime = as.POSIXct(
              "2015-01-01"
            ),
            endTime = as.POSIXct(
              "2015-01-01"
            ),
            status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
          )
        ),
        status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
        taskSetsInfo = list(
          list(
            identifer = "string",
            desiredCount = 123,
            pendingCount = 123,
            runningCount = 123,
            status = "string",
            trafficWeight = 123.0,
            targetGroup = list(
              name = "string"
            ),
            taskSetLabel = "Blue"|"Green"
          )
        )
      ),
      cloudFormationTarget = list(
        deploymentId = "string",
        targetId = "string",
        lastUpdatedAt = as.POSIXct(
          "2015-01-01"
        ),
        lifecycleEvents = list(
          list(
            lifecycleEventName = "string",
            diagnostics = list(
              errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
              scriptName = "string",
              message = "string",
              logTail = "string"
            ),
            startTime = as.POSIXct(
              "2015-01-01"
            ),
            endTime = as.POSIXct(
              "2015-01-01"
            ),
            status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
          )
        ),
        status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
        resourceType = "string",
        targetVersionWeight = 123.0
      )
    )
  )
)
}
}
\description{
Returns an array of one or more targets associated with a deployment.
This method works with all compute types and should be used instead of
the deprecated
\code{\link[=codedeploy_batch_get_deployment_instances]{batch_get_deployment_instances}}.
The maximum number of targets that can be returned is 25.

The type of targets returned depends on the deployment's compute
platform or deployment method:
\itemize{
\item \strong{EC2/On-premises}: Information about EC2 instance targets.
\item \strong{AWS Lambda}: Information about Lambda functions targets.
\item \strong{Amazon ECS}: Information about Amazon ECS service targets.
\item \strong{CloudFormation}: Information about targets of blue/green
deployments initiated by a CloudFormation stack update.
}
}
\section{Request syntax}{
\preformatted{svc$batch_get_deployment_targets(
  deploymentId = "string",
  targetIds = list(
    "string"
  )
)
}
}

\keyword{internal}
