% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_update_deployment_group}
\alias{codedeploy_update_deployment_group}
\title{Changes information about a deployment group}
\usage{
codedeploy_update_deployment_group(applicationName,
  currentDeploymentGroupName, newDeploymentGroupName,
  deploymentConfigName, ec2TagFilters, onPremisesInstanceTagFilters,
  autoScalingGroups, serviceRoleArn, triggerConfigurations,
  alarmConfiguration, autoRollbackConfiguration, deploymentStyle,
  blueGreenDeploymentConfiguration, loadBalancerInfo, ec2TagSet,
  ecsServices, onPremisesTagSet)
}
\arguments{
\item{applicationName}{[required] The application name that corresponds to the deployment group to update.}

\item{currentDeploymentGroupName}{[required] The current name of the deployment group.}

\item{newDeploymentGroupName}{The new name of the deployment group, if you want to change it.}

\item{deploymentConfigName}{The replacement deployment configuration name to use, if you want to
change it.}

\item{ec2TagFilters}{The replacement set of Amazon EC2 tags on which to filter, if you want
to change them. To keep the existing tags, enter their names. To remove
tags, do not enter any tag names.}

\item{onPremisesInstanceTagFilters}{The replacement set of on-premises instance tags on which to filter, if
you want to change them. To keep the existing tags, enter their names.
To remove tags, do not enter any tag names.}

\item{autoScalingGroups}{The replacement list of Auto Scaling groups to be included in the
deployment group, if you want to change them. To keep the Auto Scaling
groups, enter their names. To remove Auto Scaling groups, do not enter
any Auto Scaling group names.}

\item{serviceRoleArn}{A replacement ARN for the service role, if you want to change it.}

\item{triggerConfigurations}{Information about triggers to change when the deployment group is
updated. For examples, see \href{https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-edit-trigger.html}{Edit a Trigger in a CodeDeploy Deployment Group}
in the \emph{AWS CodeDeploy User Guide}.}

\item{alarmConfiguration}{Information to add or change about Amazon CloudWatch alarms when the
deployment group is updated.}

\item{autoRollbackConfiguration}{Information for an automatic rollback configuration that is added or
changed when a deployment group is updated.}

\item{deploymentStyle}{Information about the type of deployment, either in-place or blue/green,
you want to run and whether to route deployment traffic behind a load
balancer.}

\item{blueGreenDeploymentConfiguration}{Information about blue/green deployment options for a deployment group.}

\item{loadBalancerInfo}{Information about the load balancer used in a deployment.}

\item{ec2TagSet}{Information about groups of tags applied to on-premises instances. The
deployment group includes only EC2 instances identified by all the tag
groups.}

\item{ecsServices}{The target Amazon ECS services in the deployment group. This applies
only to deployment groups that use the Amazon ECS compute platform. A
target Amazon ECS service is specified as an Amazon ECS cluster and
service name pair using the format \verb{<clustername>:<servicename>}.}

\item{onPremisesTagSet}{Information about an on-premises instance tag set. The deployment group
includes only on-premises instances identified by all the tag groups.}
}
\value{
A list with the following syntax:\preformatted{list(
  hooksNotCleanedUp = list(
    list(
      name = "string",
      hook = "string"
    )
  )
)
}
}
\description{
Changes information about a deployment group.
}
\section{Request syntax}{
\preformatted{svc$update_deployment_group(
  applicationName = "string",
  currentDeploymentGroupName = "string",
  newDeploymentGroupName = "string",
  deploymentConfigName = "string",
  ec2TagFilters = list(
    list(
      Key = "string",
      Value = "string",
      Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
    )
  ),
  onPremisesInstanceTagFilters = list(
    list(
      Key = "string",
      Value = "string",
      Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
    )
  ),
  autoScalingGroups = list(
    "string"
  ),
  serviceRoleArn = "string",
  triggerConfigurations = list(
    list(
      triggerName = "string",
      triggerTargetArn = "string",
      triggerEvents = list(
        "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
      )
    )
  ),
  alarmConfiguration = list(
    enabled = TRUE|FALSE,
    ignorePollAlarmFailure = TRUE|FALSE,
    alarms = list(
      list(
        name = "string"
      )
    )
  ),
  autoRollbackConfiguration = list(
    enabled = TRUE|FALSE,
    events = list(
      "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
    )
  ),
  deploymentStyle = list(
    deploymentType = "IN_PLACE"|"BLUE_GREEN",
    deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
  ),
  blueGreenDeploymentConfiguration = list(
    terminateBlueInstancesOnDeploymentSuccess = list(
      action = "TERMINATE"|"KEEP_ALIVE",
      terminationWaitTimeInMinutes = 123
    ),
    deploymentReadyOption = list(
      actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
      waitTimeInMinutes = 123
    ),
    greenFleetProvisioningOption = list(
      action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
    )
  ),
  loadBalancerInfo = list(
    elbInfoList = list(
      list(
        name = "string"
      )
    ),
    targetGroupInfoList = list(
      list(
        name = "string"
      )
    ),
    targetGroupPairInfoList = list(
      list(
        targetGroups = list(
          list(
            name = "string"
          )
        ),
        prodTrafficRoute = list(
          listenerArns = list(
            "string"
          )
        ),
        testTrafficRoute = list(
          listenerArns = list(
            "string"
          )
        )
      )
    )
  ),
  ec2TagSet = list(
    ec2TagSetList = list(
      list(
        list(
          Key = "string",
          Value = "string",
          Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
        )
      )
    )
  ),
  ecsServices = list(
    list(
      serviceName = "string",
      clusterName = "string"
    )
  ),
  onPremisesTagSet = list(
    onPremisesTagSetList = list(
      list(
        list(
          Key = "string",
          Value = "string",
          Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
        )
      )
    )
  )
)
}
}

\keyword{internal}
