# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' CodeArtifact
#'
#' @description
#' CodeArtifact is a fully managed artifact repository compatible with
#' language-native package managers and build tools such as npm, Apache
#' Maven, pip, and dotnet. You can use CodeArtifact to share packages with
#' development teams and pull packages. Packages can be pulled from both
#' public and CodeArtifact repositories. You can also create an upstream
#' relationship between a CodeArtifact repository and another repository,
#' which effectively merges their contents from the point of view of a
#' package manager client.
#' 
#' **CodeArtifact Components**
#' 
#' Use the information in this guide to help you work with the following
#' CodeArtifact components:
#' 
#' -   **Repository**: A CodeArtifact repository contains a set of [package
#'     versions](https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html#welcome-concepts-package-version),
#'     each of which maps to a set of assets, or files. Repositories are
#'     polyglot, so a single repository can contain packages of any
#'     supported type. Each repository exposes endpoints for fetching and
#'     publishing packages using tools like the **`npm`** CLI, the Maven
#'     CLI ( **`mvn`** ), Python CLIs ( **`pip`** and `twine`), and NuGet
#'     CLIs (`nuget` and `dotnet`).
#' 
#' -   **Domain**: Repositories are aggregated into a higher-level entity
#'     known as a *domain*. All package assets and metadata are stored in
#'     the domain, but are consumed through repositories. A given package
#'     asset, such as a Maven JAR file, is stored once per domain, no
#'     matter how many repositories it's present in. All of the assets and
#'     metadata in a domain are encrypted with the same customer master key
#'     (CMK) stored in Key Management Service (KMS).
#' 
#'     Each repository is a member of a single domain and can't be moved to
#'     a different domain.
#' 
#'     The domain allows organizational policy to be applied across
#'     multiple repositories, such as which accounts can access
#'     repositories in the domain, and which public repositories can be
#'     used as sources of packages.
#' 
#'     Although an organization can have multiple domains, we recommend a
#'     single production domain that contains all published artifacts so
#'     that teams can find and share packages across their organization.
#' 
#' -   **Package**: A *package* is a bundle of software and the metadata
#'     required to resolve dependencies and install the software.
#'     CodeArtifact supports
#'     [npm](https://docs.aws.amazon.com/codeartifact/latest/ug/using-npm.html),
#'     [PyPI](https://docs.aws.amazon.com/codeartifact/latest/ug/using-python.html),
#'     [Maven](https://docs.aws.amazon.com/codeartifact/latest/ug/using-maven.html),
#'     and
#'     [NuGet](https://docs.aws.amazon.com/codeartifact/latest/ug/using-nuget.html)
#'     package formats.
#' 
#'     In CodeArtifact, a package consists of:
#' 
#'     -   A *name* (for example, `webpack` is the name of a popular npm
#'         package)
#' 
#'     -   An optional namespace (for example, `@@types` in `@@types/node`)
#' 
#'     -   A set of versions (for example, `1.0.0`, `1.0.1`, `1.0.2`, etc.)
#' 
#'     -   Package-level metadata (for example, npm tags)
#' 
#' -   **Package version**: A version of a package, such as
#'     `@@types/node 12.6.9`. The version number format and semantics vary
#'     for different package formats. For example, npm package versions
#'     must conform to the [Semantic Versioning
#'     specification](https://semver.org/). In CodeArtifact, a package
#'     version consists of the version identifier, metadata at the package
#'     version level, and a set of assets.
#' 
#' -   **Upstream repository**: One repository is *upstream* of another
#'     when the package versions in it can be accessed from the repository
#'     endpoint of the downstream repository, effectively merging the
#'     contents of the two repositories from the point of view of a client.
#'     CodeArtifact allows creating an upstream relationship between two
#'     repositories.
#' 
#' -   **Asset**: An individual file stored in CodeArtifact associated with
#'     a package version, such as an npm `.tgz` file or Maven POM and JAR
#'     files.
#' 
#' CodeArtifact supports these operations:
#' 
#' -   [`associate_external_connection`][codeartifact_associate_external_connection]:
#'     Adds an existing external connection to a repository.
#' 
#' -   [`copy_package_versions`][codeartifact_copy_package_versions]:
#'     Copies package versions from one repository to another repository in
#'     the same domain.
#' 
#' -   [`create_domain`][codeartifact_create_domain]: Creates a domain
#' 
#' -   [`create_repository`][codeartifact_create_repository]: Creates a
#'     CodeArtifact repository in a domain.
#' 
#' -   [`delete_domain`][codeartifact_delete_domain]: Deletes a domain. You
#'     cannot delete a domain that contains repositories.
#' 
#' -   [`delete_domain_permissions_policy`][codeartifact_delete_domain_permissions_policy]:
#'     Deletes the resource policy that is set on a domain.
#' 
#' -   [`delete_package`][codeartifact_delete_package]: Deletes a package
#'     and all associated package versions.
#' 
#' -   [`delete_package_versions`][codeartifact_delete_package_versions]:
#'     Deletes versions of a package. After a package has been deleted, it
#'     can be republished, but its assets and metadata cannot be restored
#'     because they have been permanently removed from storage.
#' 
#' -   [`delete_repository`][codeartifact_delete_repository]: Deletes a
#'     repository.
#' 
#' -   [`delete_repository_permissions_policy`][codeartifact_delete_repository_permissions_policy]:
#'     Deletes the resource policy that is set on a repository.
#' 
#' -   [`describe_domain`][codeartifact_describe_domain]: Returns a
#'     `DomainDescription` object that contains information about the
#'     requested domain.
#' 
#' -   [`describe_package`][codeartifact_describe_package]: Returns a
#'     [PackageDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html)
#'     object that contains details about a package.
#' 
#' -   [`describe_package_version`][codeartifact_describe_package_version]:
#'     Returns a
#'     [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html)
#'     object that contains details about a package version.
#' 
#' -   [`describe_repository`][codeartifact_describe_repository]: Returns a
#'     `RepositoryDescription` object that contains detailed information
#'     about the requested repository.
#' 
#' -   [`dispose_package_versions`][codeartifact_dispose_package_versions]:
#'     Disposes versions of a package. A package version with the status
#'     `Disposed` cannot be restored because they have been permanently
#'     removed from storage.
#' 
#' -   [`disassociate_external_connection`][codeartifact_disassociate_external_connection]:
#'     Removes an existing external connection from a repository.
#' 
#' -   [`get_authorization_token`][codeartifact_get_authorization_token]:
#'     Generates a temporary authorization token for accessing repositories
#'     in the domain. The token expires the authorization period has
#'     passed. The default authorization period is 12 hours and can be
#'     customized to any length with a maximum of 12 hours.
#' 
#' -   [`get_domain_permissions_policy`][codeartifact_get_domain_permissions_policy]:
#'     Returns the policy of a resource that is attached to the specified
#'     domain.
#' 
#' -   [`get_package_version_asset`][codeartifact_get_package_version_asset]:
#'     Returns the contents of an asset that is in a package version.
#' 
#' -   [`get_package_version_readme`][codeartifact_get_package_version_readme]:
#'     Gets the readme file or descriptive text for a package version.
#' 
#' -   [`get_repository_endpoint`][codeartifact_get_repository_endpoint]:
#'     Returns the endpoint of a repository for a specific package format.
#'     A repository has one endpoint for each package format:
#' 
#'     -   `maven`
#' 
#'     -   `npm`
#' 
#'     -   `nuget`
#' 
#'     -   `pypi`
#' 
#' -   [`get_repository_permissions_policy`][codeartifact_get_repository_permissions_policy]:
#'     Returns the resource policy that is set on a repository.
#' 
#' -   [`list_domains`][codeartifact_list_domains]: Returns a list of
#'     `DomainSummary` objects. Each returned `DomainSummary` object
#'     contains information about a domain.
#' 
#' -   [`list_packages`][codeartifact_list_packages]: Lists the packages in
#'     a repository.
#' 
#' -   [`list_package_version_assets`][codeartifact_list_package_version_assets]:
#'     Lists the assets for a given package version.
#' 
#' -   [`list_package_version_dependencies`][codeartifact_list_package_version_dependencies]:
#'     Returns a list of the direct dependencies for a package version.
#' 
#' -   [`list_package_versions`][codeartifact_list_package_versions]:
#'     Returns a list of package versions for a specified package in a
#'     repository.
#' 
#' -   [`list_repositories`][codeartifact_list_repositories]: Returns a
#'     list of repositories owned by the Amazon Web Services account that
#'     called this method.
#' 
#' -   [`list_repositories_in_domain`][codeartifact_list_repositories_in_domain]:
#'     Returns a list of the repositories in a domain.
#' 
#' -   [`publish_package_version`][codeartifact_publish_package_version]:
#'     Creates a new package version containing one or more assets.
#' 
#' -   [`put_domain_permissions_policy`][codeartifact_put_domain_permissions_policy]:
#'     Attaches a resource policy to a domain.
#' 
#' -   [`put_package_origin_configuration`][codeartifact_put_package_origin_configuration]:
#'     Sets the package origin configuration for a package, which determine
#'     how new versions of the package can be added to a specific
#'     repository.
#' 
#' -   [`put_repository_permissions_policy`][codeartifact_put_repository_permissions_policy]:
#'     Sets the resource policy on a repository that specifies permissions
#'     to access it.
#' 
#' -   [`update_package_versions_status`][codeartifact_update_package_versions_status]:
#'     Updates the status of one or more versions of a package.
#' 
#' -   [`update_repository`][codeartifact_update_repository]: Updates the
#'     properties of a repository.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- codeartifact(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- codeartifact()
#' svc$associate_external_connection(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=codeartifact_associate_external_connection]{associate_external_connection} \tab Adds an existing external connection to a repository\cr
#'  \link[=codeartifact_copy_package_versions]{copy_package_versions} \tab Copies package versions from one repository to another repository in the same domain\cr
#'  \link[=codeartifact_create_domain]{create_domain} \tab Creates a domain\cr
#'  \link[=codeartifact_create_repository]{create_repository} \tab Creates a repository\cr
#'  \link[=codeartifact_delete_domain]{delete_domain} \tab Deletes a domain\cr
#'  \link[=codeartifact_delete_domain_permissions_policy]{delete_domain_permissions_policy} \tab Deletes the resource policy set on a domain\cr
#'  \link[=codeartifact_delete_package]{delete_package} \tab Deletes a package and all associated package versions\cr
#'  \link[=codeartifact_delete_package_versions]{delete_package_versions} \tab Deletes one or more versions of a package\cr
#'  \link[=codeartifact_delete_repository]{delete_repository} \tab Deletes a repository\cr
#'  \link[=codeartifact_delete_repository_permissions_policy]{delete_repository_permissions_policy} \tab Deletes the resource policy that is set on a repository\cr
#'  \link[=codeartifact_describe_domain]{describe_domain} \tab Returns a DomainDescription object that contains information about the requested domain\cr
#'  \link[=codeartifact_describe_package]{describe_package} \tab Returns a PackageDescription object that contains information about the requested package\cr
#'  \link[=codeartifact_describe_package_version]{describe_package_version} \tab Returns a PackageVersionDescription object that contains information about the requested package version\cr
#'  \link[=codeartifact_describe_repository]{describe_repository} \tab Returns a RepositoryDescription object that contains detailed information about the requested repository\cr
#'  \link[=codeartifact_disassociate_external_connection]{disassociate_external_connection} \tab Removes an existing external connection from a repository\cr
#'  \link[=codeartifact_dispose_package_versions]{dispose_package_versions} \tab Deletes the assets in package versions and sets the package versions' status to Disposed\cr
#'  \link[=codeartifact_get_authorization_token]{get_authorization_token} \tab Generates a temporary authorization token for accessing repositories in the domain\cr
#'  \link[=codeartifact_get_domain_permissions_policy]{get_domain_permissions_policy} \tab Returns the resource policy attached to the specified domain\cr
#'  \link[=codeartifact_get_package_version_asset]{get_package_version_asset} \tab Returns an asset (or file) that is in a package\cr
#'  \link[=codeartifact_get_package_version_readme]{get_package_version_readme} \tab Gets the readme file or descriptive text for a package version\cr
#'  \link[=codeartifact_get_repository_endpoint]{get_repository_endpoint} \tab Returns the endpoint of a repository for a specific package format\cr
#'  \link[=codeartifact_get_repository_permissions_policy]{get_repository_permissions_policy} \tab Returns the resource policy that is set on a repository\cr
#'  \link[=codeartifact_list_domains]{list_domains} \tab Returns a list of DomainSummary objects for all domains owned by the Amazon Web Services account that makes this call\cr
#'  \link[=codeartifact_list_packages]{list_packages} \tab Returns a list of PackageSummary objects for packages in a repository that match the request parameters\cr
#'  \link[=codeartifact_list_package_version_assets]{list_package_version_assets} \tab Returns a list of AssetSummary objects for assets in a package version\cr
#'  \link[=codeartifact_list_package_version_dependencies]{list_package_version_dependencies} \tab Returns the direct dependencies for a package version\cr
#'  \link[=codeartifact_list_package_versions]{list_package_versions} \tab Returns a list of PackageVersionSummary objects for package versions in a repository that match the request parameters\cr
#'  \link[=codeartifact_list_repositories]{list_repositories} \tab Returns a list of RepositorySummary objects\cr
#'  \link[=codeartifact_list_repositories_in_domain]{list_repositories_in_domain} \tab Returns a list of RepositorySummary objects\cr
#'  \link[=codeartifact_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact\cr
#'  \link[=codeartifact_publish_package_version]{publish_package_version} \tab Creates a new package version containing one or more assets (or files)\cr
#'  \link[=codeartifact_put_domain_permissions_policy]{put_domain_permissions_policy} \tab Sets a resource policy on a domain that specifies permissions to access it\cr
#'  \link[=codeartifact_put_package_origin_configuration]{put_package_origin_configuration} \tab Sets the package origin configuration for a package\cr
#'  \link[=codeartifact_put_repository_permissions_policy]{put_repository_permissions_policy} \tab Sets the resource policy on a repository that specifies permissions to access it\cr
#'  \link[=codeartifact_tag_resource]{tag_resource} \tab Adds or updates tags for a resource in CodeArtifact\cr
#'  \link[=codeartifact_untag_resource]{untag_resource} \tab Removes tags from a resource in CodeArtifact\cr
#'  \link[=codeartifact_update_package_versions_status]{update_package_versions_status} \tab Updates the status of one or more versions of a package\cr
#'  \link[=codeartifact_update_repository]{update_repository} \tab Update the properties of a repository
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname codeartifact
#' @export
codeartifact <- function(config = list()) {
  svc <- .codeartifact$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.codeartifact <- list()

.codeartifact$operations <- list()

.codeartifact$metadata <- list(
  service_name = "codeartifact",
  endpoints = list("*" = list(endpoint = "codeartifact.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "codeartifact.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "codeartifact.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "codeartifact.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "codeartifact",
  api_version = "2018-09-22",
  signing_name = "codeartifact",
  json_version = "1.1",
  target_prefix = ""
)

.codeartifact$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.codeartifact$metadata, handlers, config)
}
