# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codeguruprofiler_service.R
NULL

#' Add up to 2 anomaly notifications channels for a profiling group
#'
#' @description
#' Add up to 2 anomaly notifications channels for a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_add_notification_channels/](https://www.paws-r-sdk.com/docs/codeguruprofiler_add_notification_channels/) for full documentation.
#'
#' @param channels &#91;required&#93; One or 2 channels to report to when anomalies are detected.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group that we are setting up notifications
#' for.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_add_notification_channels
codeguruprofiler_add_notification_channels <- function(channels, profilingGroupName) {
  op <- new_operation(
    name = "AddNotificationChannels",
    http_method = "POST",
    http_path = "/profilingGroups/{profilingGroupName}/notificationConfiguration",
    paginator = list()
  )
  input <- .codeguruprofiler$add_notification_channels_input(channels = channels, profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$add_notification_channels_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$add_notification_channels <- codeguruprofiler_add_notification_channels

#' Returns the time series of values for a requested list of frame metrics
#' from a time period
#'
#' @description
#' Returns the time series of values for a requested list of frame metrics from a time period.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_batch_get_frame_metric_data/](https://www.paws-r-sdk.com/docs/codeguruprofiler_batch_get_frame_metric_data/) for full documentation.
#'
#' @param endTime The end time of the time period for the returned time series values.
#' This is specified using the ISO 8601 format. For example,
#' 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020
#' 1:15:02 PM UTC.
#' @param frameMetrics The details of the metrics that are used to request a time series of
#' values. The metric includes the name of the frame, the aggregation type
#' to calculate the metric value for the frame, and the thread states to
#' use to get the count for the metric value of the frame.
#' @param period The duration of the frame metrics used to return the time series values.
#' Specify using the ISO 8601 format. The maximum period duration is one
#' day (`PT24H` or `P1D`).
#' @param profilingGroupName &#91;required&#93; The name of the profiling group associated with the the frame metrics
#' used to return the time series values.
#' @param startTime The start time of the time period for the frame metrics used to return
#' the time series values. This is specified using the ISO 8601 format. For
#' example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1,
#' 2020 1:15:02 PM UTC.
#' @param targetResolution The requested resolution of time steps for the returned time series of
#' values. If the requested target resolution is not available due to data
#' not being retained we provide a best effort result by falling back to
#' the most granular available resolution after the target resolution.
#' There are 3 valid values.
#' 
#' -   `P1D` — 1 day
#' 
#' -   `PT1H` — 1 hour
#' 
#' -   `PT5M` — 5 minutes
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_batch_get_frame_metric_data
codeguruprofiler_batch_get_frame_metric_data <- function(endTime = NULL, frameMetrics = NULL, period = NULL, profilingGroupName, startTime = NULL, targetResolution = NULL) {
  op <- new_operation(
    name = "BatchGetFrameMetricData",
    http_method = "POST",
    http_path = "/profilingGroups/{profilingGroupName}/frames/-/metrics",
    paginator = list()
  )
  input <- .codeguruprofiler$batch_get_frame_metric_data_input(endTime = endTime, frameMetrics = frameMetrics, period = period, profilingGroupName = profilingGroupName, startTime = startTime, targetResolution = targetResolution)
  output <- .codeguruprofiler$batch_get_frame_metric_data_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$batch_get_frame_metric_data <- codeguruprofiler_batch_get_frame_metric_data

#' Used by profiler agents to report their current state and to receive
#' remote configuration updates
#'
#' @description
#' Used by profiler agents to report their current state and to receive remote configuration updates. For example, [`configure_agent`][codeguruprofiler_configure_agent] can be used to tell an agent whether to profile or not and for how long to return profiling data.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_configure_agent/](https://www.paws-r-sdk.com/docs/codeguruprofiler_configure_agent/) for full documentation.
#'
#' @param fleetInstanceId A universally unique identifier (UUID) for a profiling instance. For
#' example, if the profiling instance is an Amazon EC2 instance, it is the
#' instance ID. If it is an AWS Fargate container, it is the container's
#' task ID.
#' @param metadata Metadata captured about the compute platform the agent is running on. It
#' includes information about sampling and reporting. The valid fields are:
#' 
#' -   `COMPUTE_PLATFORM` - The compute platform on which the agent is
#'     running
#' 
#' -   `AGENT_ID` - The ID for an agent instance.
#' 
#' -   `AWS_REQUEST_ID` - The AWS request ID of a Lambda invocation.
#' 
#' -   `EXECUTION_ENVIRONMENT` - The execution environment a Lambda
#'     function is running on.
#' 
#' -   `LAMBDA_FUNCTION_ARN` - The Amazon Resource Name (ARN) that is used
#'     to invoke a Lambda function.
#' 
#' -   `LAMBDA_MEMORY_LIMIT_IN_MB` - The memory allocated to a Lambda
#'     function.
#' 
#' -   `LAMBDA_REMAINING_TIME_IN_MILLISECONDS` - The time in milliseconds
#'     before execution of a Lambda function times out.
#' 
#' -   `LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS` - The time in
#'     milliseconds between two invocations of a Lambda function.
#' 
#' -   `LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS` - The time in
#'     milliseconds for the previous Lambda invocation.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group for which the configured agent is
#' collecting profiling data.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_configure_agent
codeguruprofiler_configure_agent <- function(fleetInstanceId = NULL, metadata = NULL, profilingGroupName) {
  op <- new_operation(
    name = "ConfigureAgent",
    http_method = "POST",
    http_path = "/profilingGroups/{profilingGroupName}/configureAgent",
    paginator = list()
  )
  input <- .codeguruprofiler$configure_agent_input(fleetInstanceId = fleetInstanceId, metadata = metadata, profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$configure_agent_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$configure_agent <- codeguruprofiler_configure_agent

#' Creates a profiling group
#'
#' @description
#' Creates a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_create_profiling_group/](https://www.paws-r-sdk.com/docs/codeguruprofiler_create_profiling_group/) for full documentation.
#'
#' @param agentOrchestrationConfig Specifies whether profiling is enabled or disabled for the created
#' profiling group.
#' @param clientToken &#91;required&#93; Amazon CodeGuru Profiler uses this universally unique identifier (UUID)
#' to prevent the accidental creation of duplicate profiling groups if
#' there are failures and retries.
#' @param computePlatform The compute platform of the profiling group. Use `AWSLambda` if your
#' application runs on AWS Lambda. Use `Default` if your application runs
#' on a compute platform that is not AWS Lambda, such an Amazon EC2
#' instance, an on-premises server, or a different platform. If not
#' specified, `Default` is used.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to create.
#' @param tags A list of tags to add to the created profiling group.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_create_profiling_group
codeguruprofiler_create_profiling_group <- function(agentOrchestrationConfig = NULL, clientToken, computePlatform = NULL, profilingGroupName, tags = NULL) {
  op <- new_operation(
    name = "CreateProfilingGroup",
    http_method = "POST",
    http_path = "/profilingGroups",
    paginator = list()
  )
  input <- .codeguruprofiler$create_profiling_group_input(agentOrchestrationConfig = agentOrchestrationConfig, clientToken = clientToken, computePlatform = computePlatform, profilingGroupName = profilingGroupName, tags = tags)
  output <- .codeguruprofiler$create_profiling_group_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$create_profiling_group <- codeguruprofiler_create_profiling_group

#' Deletes a profiling group
#'
#' @description
#' Deletes a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_delete_profiling_group/](https://www.paws-r-sdk.com/docs/codeguruprofiler_delete_profiling_group/) for full documentation.
#'
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to delete.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_delete_profiling_group
codeguruprofiler_delete_profiling_group <- function(profilingGroupName) {
  op <- new_operation(
    name = "DeleteProfilingGroup",
    http_method = "DELETE",
    http_path = "/profilingGroups/{profilingGroupName}",
    paginator = list()
  )
  input <- .codeguruprofiler$delete_profiling_group_input(profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$delete_profiling_group_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$delete_profiling_group <- codeguruprofiler_delete_profiling_group

#' Returns a ProfilingGroupDescription object that contains information
#' about the requested profiling group
#'
#' @description
#' Returns a [`ProfilingGroupDescription`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) object that contains information about the requested profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_describe_profiling_group/](https://www.paws-r-sdk.com/docs/codeguruprofiler_describe_profiling_group/) for full documentation.
#'
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to get information about.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_describe_profiling_group
codeguruprofiler_describe_profiling_group <- function(profilingGroupName) {
  op <- new_operation(
    name = "DescribeProfilingGroup",
    http_method = "GET",
    http_path = "/profilingGroups/{profilingGroupName}",
    paginator = list()
  )
  input <- .codeguruprofiler$describe_profiling_group_input(profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$describe_profiling_group_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$describe_profiling_group <- codeguruprofiler_describe_profiling_group

#' Returns a list of FindingsReportSummary objects that contain analysis
#' results for all profiling groups in your AWS account
#'
#' @description
#' Returns a list of [`FindingsReportSummary`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html) objects that contain analysis results for all profiling groups in your AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_get_findings_report_account_summary/](https://www.paws-r-sdk.com/docs/codeguruprofiler_get_findings_report_account_summary/) for full documentation.
#'
#' @param dailyReportsOnly A `Boolean` value indicating whether to only return reports from daily
#' profiles. If set to `True`, only analysis data from daily profiles is
#' returned. If set to `False`, analysis data is returned from smaller time
#' windows (for example, one hour).
#' @param maxResults The maximum number of results returned by
#' [`get_findings_report_account_summary`][codeguruprofiler_get_findings_report_account_summary]
#' in paginated output. When this parameter is used,
#' [`get_findings_report_account_summary`][codeguruprofiler_get_findings_report_account_summary]
#' only returns `maxResults` results in a single page along with a
#' `nextToken` response element. The remaining results of the initial
#' request can be seen by sending another
#' [`get_findings_report_account_summary`][codeguruprofiler_get_findings_report_account_summary]
#' request with the returned `nextToken` value.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`get_findings_report_account_summary`][codeguruprofiler_get_findings_report_account_summary]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_get_findings_report_account_summary
codeguruprofiler_get_findings_report_account_summary <- function(dailyReportsOnly = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetFindingsReportAccountSummary",
    http_method = "GET",
    http_path = "/internal/findingsReports",
    paginator = list()
  )
  input <- .codeguruprofiler$get_findings_report_account_summary_input(dailyReportsOnly = dailyReportsOnly, maxResults = maxResults, nextToken = nextToken)
  output <- .codeguruprofiler$get_findings_report_account_summary_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$get_findings_report_account_summary <- codeguruprofiler_get_findings_report_account_summary

#' Get the current configuration for anomaly notifications for a profiling
#' group
#'
#' @description
#' Get the current configuration for anomaly notifications for a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_get_notification_configuration/](https://www.paws-r-sdk.com/docs/codeguruprofiler_get_notification_configuration/) for full documentation.
#'
#' @param profilingGroupName &#91;required&#93; The name of the profiling group we want to get the notification
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_get_notification_configuration
codeguruprofiler_get_notification_configuration <- function(profilingGroupName) {
  op <- new_operation(
    name = "GetNotificationConfiguration",
    http_method = "GET",
    http_path = "/profilingGroups/{profilingGroupName}/notificationConfiguration",
    paginator = list()
  )
  input <- .codeguruprofiler$get_notification_configuration_input(profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$get_notification_configuration_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$get_notification_configuration <- codeguruprofiler_get_notification_configuration

#' Returns the JSON-formatted resource-based policy on a profiling group
#'
#' @description
#' Returns the JSON-formatted resource-based policy on a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_get_policy/](https://www.paws-r-sdk.com/docs/codeguruprofiler_get_policy/) for full documentation.
#'
#' @param profilingGroupName &#91;required&#93; The name of the profiling group.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_get_policy
codeguruprofiler_get_policy <- function(profilingGroupName) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "GET",
    http_path = "/profilingGroups/{profilingGroupName}/policy",
    paginator = list()
  )
  input <- .codeguruprofiler$get_policy_input(profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$get_policy_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$get_policy <- codeguruprofiler_get_policy

#' Gets the aggregated profile of a profiling group for a specified time
#' range
#'
#' @description
#' Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_get_profile/](https://www.paws-r-sdk.com/docs/codeguruprofiler_get_profile/) for full documentation.
#'
#' @param accept The format of the returned profiling data. The format maps to the
#' `Accept` and `Content-Type` headers of the HTTP request. You can specify
#' one of the following: or the default .
#' 
#'      <ul> <li> <p> <code>application/json</code> — standard JSON format </p> </li> <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li> </ul> 
#' @param endTime The end time of the requested profile. Specify using the ISO 8601
#' format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
#' past June 1, 2020 1:15:02 PM UTC.
#' 
#' If you specify `endTime`, then you must also specify `period` or
#' `startTime`, but not both.
#' @param maxDepth The maximum depth of the stacks in the code that is represented in the
#' aggregated profile. For example, if CodeGuru Profiler finds a method
#' `A`, which calls method `B`, which calls method `C`, which calls method
#' `D`, then the depth is 4. If the `maxDepth` is set to 2, then the
#' aggregated profile contains representations of methods `A` and `B`.
#' @param period Used with `startTime` or `endTime` to specify the time range for the
#' returned aggregated profile. Specify using the ISO 8601 format. For
#' example, `P1DT1H1M1S`.
#' 
#'      <p> To get the latest aggregated profile, specify only <code>period</code>. </p> 
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to get.
#' @param startTime The start time of the profile to get. Specify using the ISO 8601 format.
#' For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June
#' 1, 2020 1:15:02 PM UTC.
#' 
#'      <p> If you specify <code>startTime</code>, then you must also specify <code>period</code> or <code>endTime</code>, but not both. </p> 
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_get_profile
codeguruprofiler_get_profile <- function(accept = NULL, endTime = NULL, maxDepth = NULL, period = NULL, profilingGroupName, startTime = NULL) {
  op <- new_operation(
    name = "GetProfile",
    http_method = "GET",
    http_path = "/profilingGroups/{profilingGroupName}/profile",
    paginator = list()
  )
  input <- .codeguruprofiler$get_profile_input(accept = accept, endTime = endTime, maxDepth = maxDepth, period = period, profilingGroupName = profilingGroupName, startTime = startTime)
  output <- .codeguruprofiler$get_profile_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$get_profile <- codeguruprofiler_get_profile

#' Returns a list of Recommendation objects that contain recommendations
#' for a profiling group for a given time period
#'
#' @description
#' Returns a list of [`Recommendation`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html) objects that contain recommendations for a profiling group for a given time period. A list of [`Anomaly`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html) objects that contains details about anomalies detected in the profiling group for the same time period is also returned.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_get_recommendations/](https://www.paws-r-sdk.com/docs/codeguruprofiler_get_recommendations/) for full documentation.
#'
#' @param endTime &#91;required&#93; The start time of the profile to get analysis data about. You must
#' specify `startTime` and `endTime`. This is specified using the ISO 8601
#' format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
#' past June 1, 2020 1:15:02 PM UTC.
#' @param locale The language used to provide analysis. Specify using a string that is
#' one of the following `BCP 47` language codes.
#' 
#' -   `de-DE` - German, Germany
#' 
#' -   `en-GB` - English, United Kingdom
#' 
#' -   `en-US` - English, United States
#' 
#' -   `es-ES` - Spanish, Spain
#' 
#' -   `fr-FR` - French, France
#' 
#' -   `it-IT` - Italian, Italy
#' 
#' -   `ja-JP` - Japanese, Japan
#' 
#' -   `ko-KR` - Korean, Republic of Korea
#' 
#' -   `pt-BR` - Portugese, Brazil
#' 
#' -   `zh-CN` - Chinese, China
#' 
#' -   `zh-TW` - Chinese, Taiwan
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to get analysis data about.
#' @param startTime &#91;required&#93; The end time of the profile to get analysis data about. You must specify
#' `startTime` and `endTime`. This is specified using the ISO 8601 format.
#' For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June
#' 1, 2020 1:15:02 PM UTC.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_get_recommendations
codeguruprofiler_get_recommendations <- function(endTime, locale = NULL, profilingGroupName, startTime) {
  op <- new_operation(
    name = "GetRecommendations",
    http_method = "GET",
    http_path = "/internal/profilingGroups/{profilingGroupName}/recommendations",
    paginator = list()
  )
  input <- .codeguruprofiler$get_recommendations_input(endTime = endTime, locale = locale, profilingGroupName = profilingGroupName, startTime = startTime)
  output <- .codeguruprofiler$get_recommendations_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$get_recommendations <- codeguruprofiler_get_recommendations

#' List the available reports for a given profiling group and time range
#'
#' @description
#' List the available reports for a given profiling group and time range.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_list_findings_reports/](https://www.paws-r-sdk.com/docs/codeguruprofiler_list_findings_reports/) for full documentation.
#'
#' @param dailyReportsOnly A `Boolean` value indicating whether to only return reports from daily
#' profiles. If set to `True`, only analysis data from daily profiles is
#' returned. If set to `False`, analysis data is returned from smaller time
#' windows (for example, one hour).
#' @param endTime &#91;required&#93; The end time of the profile to get analysis data about. You must specify
#' `startTime` and `endTime`. This is specified using the ISO 8601 format.
#' For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June
#' 1, 2020 1:15:02 PM UTC.
#' @param maxResults The maximum number of report results returned by
#' [`list_findings_reports`][codeguruprofiler_list_findings_reports] in
#' paginated output. When this parameter is used,
#' [`list_findings_reports`][codeguruprofiler_list_findings_reports] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`list_findings_reports`][codeguruprofiler_list_findings_reports]
#' request with the returned `nextToken` value.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `ListFindingsReportsRequest` request where `maxResults` was used and the
#' results exceeded the value of that parameter. Pagination continues from
#' the end of the previous results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group from which to search for analysis data.
#' @param startTime &#91;required&#93; The start time of the profile to get analysis data about. You must
#' specify `startTime` and `endTime`. This is specified using the ISO 8601
#' format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond
#' past June 1, 2020 1:15:02 PM UTC.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_list_findings_reports
codeguruprofiler_list_findings_reports <- function(dailyReportsOnly = NULL, endTime, maxResults = NULL, nextToken = NULL, profilingGroupName, startTime) {
  op <- new_operation(
    name = "ListFindingsReports",
    http_method = "GET",
    http_path = "/internal/profilingGroups/{profilingGroupName}/findingsReports",
    paginator = list()
  )
  input <- .codeguruprofiler$list_findings_reports_input(dailyReportsOnly = dailyReportsOnly, endTime = endTime, maxResults = maxResults, nextToken = nextToken, profilingGroupName = profilingGroupName, startTime = startTime)
  output <- .codeguruprofiler$list_findings_reports_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$list_findings_reports <- codeguruprofiler_list_findings_reports

#' Lists the start times of the available aggregated profiles of a
#' profiling group for an aggregation period within the specified time
#' range
#'
#' @description
#' Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_list_profile_times/](https://www.paws-r-sdk.com/docs/codeguruprofiler_list_profile_times/) for full documentation.
#'
#' @param endTime &#91;required&#93; The end time of the time range from which to list the profiles.
#' @param maxResults The maximum number of profile time results returned by
#' [`list_profile_times`][codeguruprofiler_list_profile_times] in paginated
#' output. When this parameter is used,
#' [`list_profile_times`][codeguruprofiler_list_profile_times] only returns
#' `maxResults` results in a single page with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another
#' [`list_profile_times`][codeguruprofiler_list_profile_times] request with
#' the returned `nextToken` value.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_profile_times`][codeguruprofiler_list_profile_times] request
#' where `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param orderBy The order (ascending or descending by start time of the profile) to use
#' when listing profiles. Defaults to `TIMESTAMP_DESCENDING`.
#' @param period &#91;required&#93; The aggregation period. This specifies the period during which an
#' aggregation profile collects posted agent profiles for a profiling
#' group. There are 3 valid values.
#' 
#' -   `P1D` — 1 day
#' 
#' -   `PT1H` — 1 hour
#' 
#' -   `PT5M` — 5 minutes
#' @param profilingGroupName &#91;required&#93; The name of the profiling group.
#' @param startTime &#91;required&#93; The start time of the time range from which to list the profiles.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_list_profile_times
codeguruprofiler_list_profile_times <- function(endTime, maxResults = NULL, nextToken = NULL, orderBy = NULL, period, profilingGroupName, startTime) {
  op <- new_operation(
    name = "ListProfileTimes",
    http_method = "GET",
    http_path = "/profilingGroups/{profilingGroupName}/profileTimes",
    paginator = list()
  )
  input <- .codeguruprofiler$list_profile_times_input(endTime = endTime, maxResults = maxResults, nextToken = nextToken, orderBy = orderBy, period = period, profilingGroupName = profilingGroupName, startTime = startTime)
  output <- .codeguruprofiler$list_profile_times_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$list_profile_times <- codeguruprofiler_list_profile_times

#' Returns a list of profiling groups
#'
#' @description
#' Returns a list of profiling groups. The profiling groups are returned as [`ProfilingGroupDescription`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html) objects.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_list_profiling_groups/](https://www.paws-r-sdk.com/docs/codeguruprofiler_list_profiling_groups/) for full documentation.
#'
#' @param includeDescription A `Boolean` value indicating whether to include a description. If
#' `true`, then a list of
#' [`ProfilingGroupDescription`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html)
#' objects that contain detailed information about profiling groups is
#' returned. If `false`, then a list of profiling group names is returned.
#' @param maxResults The maximum number of profiling groups results returned by
#' [`list_profiling_groups`][codeguruprofiler_list_profiling_groups] in
#' paginated output. When this parameter is used,
#' [`list_profiling_groups`][codeguruprofiler_list_profiling_groups] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`list_profiling_groups`][codeguruprofiler_list_profiling_groups]
#' request with the returned `nextToken` value.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_profiling_groups`][codeguruprofiler_list_profiling_groups]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_list_profiling_groups
codeguruprofiler_list_profiling_groups <- function(includeDescription = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListProfilingGroups",
    http_method = "GET",
    http_path = "/profilingGroups",
    paginator = list()
  )
  input <- .codeguruprofiler$list_profiling_groups_input(includeDescription = includeDescription, maxResults = maxResults, nextToken = nextToken)
  output <- .codeguruprofiler$list_profiling_groups_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$list_profiling_groups <- codeguruprofiler_list_profiling_groups

#' Returns a list of the tags that are assigned to a specified resource
#'
#' @description
#' Returns a list of the tags that are assigned to a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codeguruprofiler_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that contains the tags to
#' return.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_list_tags_for_resource
codeguruprofiler_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .codeguruprofiler$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .codeguruprofiler$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$list_tags_for_resource <- codeguruprofiler_list_tags_for_resource

#' Submits profiling data to an aggregated profile of a profiling group
#'
#' @description
#' Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use [`get_profile`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_post_agent_profile/](https://www.paws-r-sdk.com/docs/codeguruprofiler_post_agent_profile/) for full documentation.
#'
#' @param agentProfile &#91;required&#93; The submitted profiling data.
#' @param contentType &#91;required&#93; The format of the submitted profiling data. The format maps to the
#' `Accept` and `Content-Type` headers of the HTTP request. You can specify
#' one of the following: or the default .
#' 
#'      <ul> <li> <p> <code>application/json</code> — standard JSON format </p> </li> <li> <p> <code>application/x-amzn-ion</code> — the Amazon Ion data format. For more information, see <a href="http://amzn.github.io/ion-docs/">Amazon Ion</a>. </p> </li> </ul> 
#' @param profileToken Amazon CodeGuru Profiler uses this universally unique identifier (UUID)
#' to prevent the accidental submission of duplicate profiling data if
#' there are failures and retries.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group with the aggregated profile that
#' receives the submitted profiling data.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_post_agent_profile
codeguruprofiler_post_agent_profile <- function(agentProfile, contentType, profileToken = NULL, profilingGroupName) {
  op <- new_operation(
    name = "PostAgentProfile",
    http_method = "POST",
    http_path = "/profilingGroups/{profilingGroupName}/agentProfile",
    paginator = list()
  )
  input <- .codeguruprofiler$post_agent_profile_input(agentProfile = agentProfile, contentType = contentType, profileToken = profileToken, profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$post_agent_profile_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$post_agent_profile <- codeguruprofiler_post_agent_profile

#' Adds permissions to a profiling group's resource-based policy that are
#' provided using an action group
#'
#' @description
#' Adds permissions to a profiling group's resource-based policy that are provided using an action group. If a profiling group doesn't have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the `principals` parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_put_permission/](https://www.paws-r-sdk.com/docs/codeguruprofiler_put_permission/) for full documentation.
#'
#' @param actionGroup &#91;required&#93; Specifies an action group that contains permissions to add to a
#' profiling group resource. One action group is supported,
#' `agentPermissions`, which grants permission to perform actions required
#' by the profiling agent,
#' [`configure_agent`][codeguruprofiler_configure_agent] and
#' [`post_agent_profile`][codeguruprofiler_post_agent_profile] permissions.
#' @param principals &#91;required&#93; A list ARNs for the roles and users you want to grant access to the
#' profiling group. Wildcards are not are supported in the ARNs.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to grant access to.
#' @param revisionId A universally unique identifier (UUID) for the revision of the policy
#' you are adding to the profiling group. Do not specify this when you add
#' permissions to a profiling group for the first time. If a policy already
#' exists on the profiling group, you must specify the `revisionId`.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_put_permission
codeguruprofiler_put_permission <- function(actionGroup, principals, profilingGroupName, revisionId = NULL) {
  op <- new_operation(
    name = "PutPermission",
    http_method = "PUT",
    http_path = "/profilingGroups/{profilingGroupName}/policy/{actionGroup}",
    paginator = list()
  )
  input <- .codeguruprofiler$put_permission_input(actionGroup = actionGroup, principals = principals, profilingGroupName = profilingGroupName, revisionId = revisionId)
  output <- .codeguruprofiler$put_permission_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$put_permission <- codeguruprofiler_put_permission

#' Remove one anomaly notifications channel for a profiling group
#'
#' @description
#' Remove one anomaly notifications channel for a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_remove_notification_channel/](https://www.paws-r-sdk.com/docs/codeguruprofiler_remove_notification_channel/) for full documentation.
#'
#' @param channelId &#91;required&#93; The id of the channel that we want to stop receiving notifications.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group we want to change notification
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_remove_notification_channel
codeguruprofiler_remove_notification_channel <- function(channelId, profilingGroupName) {
  op <- new_operation(
    name = "RemoveNotificationChannel",
    http_method = "DELETE",
    http_path = "/profilingGroups/{profilingGroupName}/notificationConfiguration/{channelId}",
    paginator = list()
  )
  input <- .codeguruprofiler$remove_notification_channel_input(channelId = channelId, profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$remove_notification_channel_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$remove_notification_channel <- codeguruprofiler_remove_notification_channel

#' Removes permissions from a profiling group's resource-based policy that
#' are provided using an action group
#'
#' @description
#' Removes permissions from a profiling group's resource-based policy that are provided using an action group. The one supported action group that can be removed is `agentPermission` which grants [`configure_agent`][codeguruprofiler_configure_agent] and `PostAgent` permissions. For more information, see [Resource-based policies in CodeGuru Profiler](https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html) in the *Amazon CodeGuru Profiler User Guide*, [`configure_agent`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html) , and [`post_agent_profile`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html) .
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_remove_permission/](https://www.paws-r-sdk.com/docs/codeguruprofiler_remove_permission/) for full documentation.
#'
#' @param actionGroup &#91;required&#93; Specifies an action group that contains the permissions to remove from a
#' profiling group's resource-based policy. One action group is supported,
#' `agentPermissions`, which grants
#' [`configure_agent`][codeguruprofiler_configure_agent] and
#' [`post_agent_profile`][codeguruprofiler_post_agent_profile] permissions.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group.
#' @param revisionId &#91;required&#93; A universally unique identifier (UUID) for the revision of the
#' resource-based policy from which you want to remove permissions.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_remove_permission
codeguruprofiler_remove_permission <- function(actionGroup, profilingGroupName, revisionId) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "DELETE",
    http_path = "/profilingGroups/{profilingGroupName}/policy/{actionGroup}",
    paginator = list()
  )
  input <- .codeguruprofiler$remove_permission_input(actionGroup = actionGroup, profilingGroupName = profilingGroupName, revisionId = revisionId)
  output <- .codeguruprofiler$remove_permission_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$remove_permission <- codeguruprofiler_remove_permission

#' Sends feedback to CodeGuru Profiler about whether the anomaly detected
#' by the analysis is useful or not
#'
#' @description
#' Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_submit_feedback/](https://www.paws-r-sdk.com/docs/codeguruprofiler_submit_feedback/) for full documentation.
#'
#' @param anomalyInstanceId &#91;required&#93; The universally unique identifier (UUID) of the
#' [`AnomalyInstance`](https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html)
#' object that is included in the analysis data.
#' @param comment Optional feedback about this anomaly.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group that is associated with the analysis
#' data.
#' @param type &#91;required&#93; The feedback tpye. Thee are two valid values, `Positive` and `Negative`.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_submit_feedback
codeguruprofiler_submit_feedback <- function(anomalyInstanceId, comment = NULL, profilingGroupName, type) {
  op <- new_operation(
    name = "SubmitFeedback",
    http_method = "POST",
    http_path = "/internal/profilingGroups/{profilingGroupName}/anomalies/{anomalyInstanceId}/feedback",
    paginator = list()
  )
  input <- .codeguruprofiler$submit_feedback_input(anomalyInstanceId = anomalyInstanceId, comment = comment, profilingGroupName = profilingGroupName, type = type)
  output <- .codeguruprofiler$submit_feedback_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$submit_feedback <- codeguruprofiler_submit_feedback

#' Use to assign one or more tags to a resource
#'
#' @description
#' Use to assign one or more tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_tag_resource/](https://www.paws-r-sdk.com/docs/codeguruprofiler_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that the tags are added
#' to.
#' @param tags &#91;required&#93; The list of tags that are added to the specified resource.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_tag_resource
codeguruprofiler_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .codeguruprofiler$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .codeguruprofiler$tag_resource_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$tag_resource <- codeguruprofiler_tag_resource

#' Use to remove one or more tags from a resource
#'
#' @description
#' Use to remove one or more tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_untag_resource/](https://www.paws-r-sdk.com/docs/codeguruprofiler_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that contains the tags to
#' remove.
#' @param tagKeys &#91;required&#93; A list of tag keys. Existing tags of resources with keys in this list
#' are removed from the specified resource.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_untag_resource
codeguruprofiler_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .codeguruprofiler$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .codeguruprofiler$untag_resource_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$untag_resource <- codeguruprofiler_untag_resource

#' Updates a profiling group
#'
#' @description
#' Updates a profiling group.
#'
#' See [https://www.paws-r-sdk.com/docs/codeguruprofiler_update_profiling_group/](https://www.paws-r-sdk.com/docs/codeguruprofiler_update_profiling_group/) for full documentation.
#'
#' @param agentOrchestrationConfig &#91;required&#93; Specifies whether profiling is enabled or disabled for a profiling
#' group.
#' @param profilingGroupName &#91;required&#93; The name of the profiling group to update.
#'
#' @keywords internal
#'
#' @rdname codeguruprofiler_update_profiling_group
codeguruprofiler_update_profiling_group <- function(agentOrchestrationConfig, profilingGroupName) {
  op <- new_operation(
    name = "UpdateProfilingGroup",
    http_method = "PUT",
    http_path = "/profilingGroups/{profilingGroupName}",
    paginator = list()
  )
  input <- .codeguruprofiler$update_profiling_group_input(agentOrchestrationConfig = agentOrchestrationConfig, profilingGroupName = profilingGroupName)
  output <- .codeguruprofiler$update_profiling_group_output()
  config <- get_config()
  svc <- .codeguruprofiler$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codeguruprofiler$operations$update_profiling_group <- codeguruprofiler_update_profiling_group
