% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_service.R
\name{codeartifact}
\alias{codeartifact}
\title{CodeArtifact}
\usage{
codeartifact(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
CodeArtifact is a fully managed artifact repository compatible with
language-native package managers and build tools such as npm, Apache
Maven, pip, and dotnet. You can use CodeArtifact to share packages with
development teams and pull packages. Packages can be pulled from both
public and CodeArtifact repositories. You can also create an upstream
relationship between a CodeArtifact repository and another repository,
which effectively merges their contents from the point of view of a
package manager client.

\strong{CodeArtifact concepts}
\itemize{
\item \strong{Repository}: A CodeArtifact repository contains a set of \href{https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html#welcome-concepts-package-version}{package versions},
each of which maps to a set of assets, or files. Repositories are
polyglot, so a single repository can contain packages of any
supported type. Each repository exposes endpoints for fetching and
publishing packages using tools such as the \strong{\code{npm}} CLI or the
Maven CLI ( \strong{\code{mvn}} ). For a list of supported package managers,
see the \href{https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html}{CodeArtifact User Guide}.
\item \strong{Domain}: Repositories are aggregated into a higher-level entity
known as a \emph{domain}. All package assets and metadata are stored in
the domain, but are consumed through repositories. A given package
asset, such as a Maven JAR file, is stored once per domain, no
matter how many repositories it's present in. All of the assets and
metadata in a domain are encrypted with the same customer master key
(CMK) stored in Key Management Service (KMS).

Each repository is a member of a single domain and can't be moved to
a different domain.

The domain allows organizational policy to be applied across
multiple repositories, such as which accounts can access
repositories in the domain, and which public repositories can be
used as sources of packages.

Although an organization can have multiple domains, we recommend a
single production domain that contains all published artifacts so
that teams can find and share packages across their organization.
\item \strong{Package}: A \emph{package} is a bundle of software and the metadata
required to resolve dependencies and install the software.
CodeArtifact supports npm, PyPI, Maven, NuGet, Swift, Ruby, Cargo,
and generic package formats. For more information about the
supported package formats and how to use CodeArtifact with them, see
the \href{https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html}{CodeArtifact User Guide}.

In CodeArtifact, a package consists of:
\itemize{
\item A \emph{name} (for example, \code{webpack} is the name of a popular npm
package)
\item An optional namespace (for example, \verb{@types} in \verb{@types/node})
\item A set of versions (for example, \verb{1.0.0}, \verb{1.0.1}, \verb{1.0.2}, etc.)
\item Package-level metadata (for example, npm tags)
}
\item \strong{Package group}: A group of packages that match a specified
definition. Package groups can be used to apply configuration to
multiple packages that match a defined pattern using package format,
package namespace, and package name. You can use package groups to
more conveniently configure package origin controls for multiple
packages. Package origin controls are used to block or allow
ingestion or publishing of new package versions, which protects
users from malicious actions known as dependency substitution
attacks.
\item \strong{Package version}: A version of a package, such as
\verb{@types/node 12.6.9}. The version number format and semantics vary
for different package formats. For example, npm package versions
must conform to the \href{https://semver.org/}{Semantic Versioning specification}. In CodeArtifact, a package
version consists of the version identifier, metadata at the package
version level, and a set of assets.
\item \strong{Upstream repository}: One repository is \emph{upstream} of another
when the package versions in it can be accessed from the repository
endpoint of the downstream repository, effectively merging the
contents of the two repositories from the point of view of a client.
CodeArtifact allows creating an upstream relationship between two
repositories.
\item \strong{Asset}: An individual file stored in CodeArtifact associated with
a package version, such as an npm \code{.tgz} file or Maven POM and JAR
files.
}

\strong{CodeArtifact supported API operations}
\itemize{
\item \code{\link[=codeartifact_associate_external_connection]{associate_external_connection}}:
Adds an existing external connection to a repository.
\item \code{\link[=codeartifact_copy_package_versions]{copy_package_versions}}:
Copies package versions from one repository to another repository in
the same domain.
\item \code{\link[=codeartifact_create_domain]{create_domain}}: Creates a domain.
\item \code{\link[=codeartifact_create_package_group]{create_package_group}}: Creates
a package group.
\item \code{\link[=codeartifact_create_repository]{create_repository}}: Creates a
CodeArtifact repository in a domain.
\item \code{\link[=codeartifact_delete_domain]{delete_domain}}: Deletes a domain. You
cannot delete a domain that contains repositories.
\item \code{\link[=codeartifact_delete_domain_permissions_policy]{delete_domain_permissions_policy}}:
Deletes the resource policy that is set on a domain.
\item \code{\link[=codeartifact_delete_package]{delete_package}}: Deletes a package
and all associated package versions.
\item \code{\link[=codeartifact_delete_package_group]{delete_package_group}}: Deletes
a package group. Does not delete packages or package versions that
are associated with a package group.
\item \code{\link[=codeartifact_delete_package_versions]{delete_package_versions}}:
Deletes versions of a package. After a package has been deleted, it
can be republished, but its assets and metadata cannot be restored
because they have been permanently removed from storage.
\item \code{\link[=codeartifact_delete_repository]{delete_repository}}: Deletes a
repository.
\item \code{\link[=codeartifact_delete_repository_permissions_policy]{delete_repository_permissions_policy}}:
Deletes the resource policy that is set on a repository.
\item \code{\link[=codeartifact_describe_domain]{describe_domain}}: Returns a
\code{DomainDescription} object that contains information about the
requested domain.
\item \code{\link[=codeartifact_describe_package]{describe_package}}: Returns a
\href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html}{PackageDescription}
object that contains details about a package.
\item \code{\link[=codeartifact_describe_package_group]{describe_package_group}}:
Returns a
\href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/}{PackageGroup}
object that contains details about a package group.
\item \code{\link[=codeartifact_describe_package_version]{describe_package_version}}:
Returns a
\href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html}{PackageVersionDescription}
object that contains details about a package version.
\item \code{\link[=codeartifact_describe_repository]{describe_repository}}: Returns a
\code{RepositoryDescription} object that contains detailed information
about the requested repository.
\item \code{\link[=codeartifact_dispose_package_versions]{dispose_package_versions}}:
Disposes versions of a package. A package version with the status
\code{Disposed} cannot be restored because they have been permanently
removed from storage.
\item \code{\link[=codeartifact_disassociate_external_connection]{disassociate_external_connection}}:
Removes an existing external connection from a repository.
\item \code{\link[=codeartifact_get_associated_package_group]{get_associated_package_group}}:
Returns the most closely associated package group to the specified
package.
\item \code{\link[=codeartifact_get_authorization_token]{get_authorization_token}}:
Generates a temporary authorization token for accessing repositories
in the domain. The token expires the authorization period has
passed. The default authorization period is 12 hours and can be
customized to any length with a maximum of 12 hours.
\item \code{\link[=codeartifact_get_domain_permissions_policy]{get_domain_permissions_policy}}:
Returns the policy of a resource that is attached to the specified
domain.
\item \code{\link[=codeartifact_get_package_version_asset]{get_package_version_asset}}:
Returns the contents of an asset that is in a package version.
\item \code{\link[=codeartifact_get_package_version_readme]{get_package_version_readme}}:
Gets the readme file or descriptive text for a package version.
\item \code{\link[=codeartifact_get_repository_endpoint]{get_repository_endpoint}}:
Returns the endpoint of a repository for a specific package format.
A repository has one endpoint for each package format:
\itemize{
\item \code{cargo}
\item \code{generic}
\item \code{maven}
\item \code{npm}
\item \code{nuget}
\item \code{pypi}
\item \code{ruby}
\item \code{swift}
}
\item \code{\link[=codeartifact_get_repository_permissions_policy]{get_repository_permissions_policy}}:
Returns the resource policy that is set on a repository.
\item \code{\link[=codeartifact_list_allowed_repositories_for_group]{list_allowed_repositories_for_group}}:
Lists the allowed repositories for a package group that has origin
configuration set to \code{ALLOW_SPECIFIC_REPOSITORIES}.
\item \code{\link[=codeartifact_list_associated_packages]{list_associated_packages}}:
Returns a list of packages associated with the requested package
group.
\item \code{\link[=codeartifact_list_domains]{list_domains}}: Returns a list of
\code{DomainSummary} objects. Each returned \code{DomainSummary} object
contains information about a domain.
\item \code{\link[=codeartifact_list_packages]{list_packages}}: Lists the packages in
a repository.
\item \code{\link[=codeartifact_list_package_groups]{list_package_groups}}: Returns a
list of package groups in the requested domain.
\item \code{\link[=codeartifact_list_package_version_assets]{list_package_version_assets}}:
Lists the assets for a given package version.
\item \code{\link[=codeartifact_list_package_version_dependencies]{list_package_version_dependencies}}:
Returns a list of the direct dependencies for a package version.
\item \code{\link[=codeartifact_list_package_versions]{list_package_versions}}:
Returns a list of package versions for a specified package in a
repository.
\item \code{\link[=codeartifact_list_repositories]{list_repositories}}: Returns a
list of repositories owned by the Amazon Web Services account that
called this method.
\item \code{\link[=codeartifact_list_repositories_in_domain]{list_repositories_in_domain}}:
Returns a list of the repositories in a domain.
\item \code{\link[=codeartifact_list_sub_package_groups]{list_sub_package_groups}}:
Returns a list of direct children of the specified package group.
\item \code{\link[=codeartifact_publish_package_version]{publish_package_version}}:
Creates a new package version containing one or more assets.
\item \code{\link[=codeartifact_put_domain_permissions_policy]{put_domain_permissions_policy}}:
Attaches a resource policy to a domain.
\item \code{\link[=codeartifact_put_package_origin_configuration]{put_package_origin_configuration}}:
Sets the package origin configuration for a package, which determine
how new versions of the package can be added to a specific
repository.
\item \code{\link[=codeartifact_put_repository_permissions_policy]{put_repository_permissions_policy}}:
Sets the resource policy on a repository that specifies permissions
to access it.
\item \code{\link[=codeartifact_update_package_group]{update_package_group}}: Updates
a package group. This API cannot be used to update a package group's
origin configuration or pattern.
\item \code{\link[=codeartifact_update_package_group_origin_configuration]{update_package_group_origin_configuration}}:
Updates the package origin configuration for a package group.
\item \code{\link[=codeartifact_update_package_versions_status]{update_package_versions_status}}:
Updates the status of one or more versions of a package.
\item \code{\link[=codeartifact_update_repository]{update_repository}}: Updates the
properties of a repository.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codeartifact(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=codeartifact_associate_external_connection]{associate_external_connection} \tab Adds an existing external connection to a repository\cr
\link[=codeartifact_copy_package_versions]{copy_package_versions} \tab Copies package versions from one repository to another repository in the same domain\cr
\link[=codeartifact_create_domain]{create_domain} \tab Creates a domain\cr
\link[=codeartifact_create_package_group]{create_package_group} \tab Creates a package group\cr
\link[=codeartifact_create_repository]{create_repository} \tab Creates a repository\cr
\link[=codeartifact_delete_domain]{delete_domain} \tab Deletes a domain\cr
\link[=codeartifact_delete_domain_permissions_policy]{delete_domain_permissions_policy} \tab Deletes the resource policy set on a domain\cr
\link[=codeartifact_delete_package]{delete_package} \tab Deletes a package and all associated package versions\cr
\link[=codeartifact_delete_package_group]{delete_package_group} \tab Deletes a package group\cr
\link[=codeartifact_delete_package_versions]{delete_package_versions} \tab Deletes one or more versions of a package\cr
\link[=codeartifact_delete_repository]{delete_repository} \tab Deletes a repository\cr
\link[=codeartifact_delete_repository_permissions_policy]{delete_repository_permissions_policy} \tab Deletes the resource policy that is set on a repository\cr
\link[=codeartifact_describe_domain]{describe_domain} \tab Returns a DomainDescription object that contains information about the requested domain\cr
\link[=codeartifact_describe_package]{describe_package} \tab Returns a PackageDescription object that contains information about the requested package\cr
\link[=codeartifact_describe_package_group]{describe_package_group} \tab Returns a PackageGroupDescription object that contains information about the requested package group\cr
\link[=codeartifact_describe_package_version]{describe_package_version} \tab Returns a PackageVersionDescription object that contains information about the requested package version\cr
\link[=codeartifact_describe_repository]{describe_repository} \tab Returns a RepositoryDescription object that contains detailed information about the requested repository\cr
\link[=codeartifact_disassociate_external_connection]{disassociate_external_connection} \tab Removes an existing external connection from a repository\cr
\link[=codeartifact_dispose_package_versions]{dispose_package_versions} \tab Deletes the assets in package versions and sets the package versions' status to Disposed\cr
\link[=codeartifact_get_associated_package_group]{get_associated_package_group} \tab Returns the most closely associated package group to the specified package\cr
\link[=codeartifact_get_authorization_token]{get_authorization_token} \tab Generates a temporary authorization token for accessing repositories in the domain\cr
\link[=codeartifact_get_domain_permissions_policy]{get_domain_permissions_policy} \tab Returns the resource policy attached to the specified domain\cr
\link[=codeartifact_get_package_version_asset]{get_package_version_asset} \tab Returns an asset (or file) that is in a package\cr
\link[=codeartifact_get_package_version_readme]{get_package_version_readme} \tab Gets the readme file or descriptive text for a package version\cr
\link[=codeartifact_get_repository_endpoint]{get_repository_endpoint} \tab Returns the endpoint of a repository for a specific package format\cr
\link[=codeartifact_get_repository_permissions_policy]{get_repository_permissions_policy} \tab Returns the resource policy that is set on a repository\cr
\link[=codeartifact_list_allowed_repositories_for_group]{list_allowed_repositories_for_group} \tab Lists the repositories in the added repositories list of the specified restriction type for a package group\cr
\link[=codeartifact_list_associated_packages]{list_associated_packages} \tab Returns a list of packages associated with the requested package group\cr
\link[=codeartifact_list_domains]{list_domains} \tab Returns a list of DomainSummary objects for all domains owned by the Amazon Web Services account that makes this call\cr
\link[=codeartifact_list_package_groups]{list_package_groups} \tab Returns a list of package groups in the requested domain\cr
\link[=codeartifact_list_packages]{list_packages} \tab Returns a list of PackageSummary objects for packages in a repository that match the request parameters\cr
\link[=codeartifact_list_package_version_assets]{list_package_version_assets} \tab Returns a list of AssetSummary objects for assets in a package version\cr
\link[=codeartifact_list_package_version_dependencies]{list_package_version_dependencies} \tab Returns the direct dependencies for a package version\cr
\link[=codeartifact_list_package_versions]{list_package_versions} \tab Returns a list of PackageVersionSummary objects for package versions in a repository that match the request parameters\cr
\link[=codeartifact_list_repositories]{list_repositories} \tab Returns a list of RepositorySummary objects\cr
\link[=codeartifact_list_repositories_in_domain]{list_repositories_in_domain} \tab Returns a list of RepositorySummary objects\cr
\link[=codeartifact_list_sub_package_groups]{list_sub_package_groups} \tab Returns a list of direct children of the specified package group\cr
\link[=codeartifact_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact\cr
\link[=codeartifact_publish_package_version]{publish_package_version} \tab Creates a new package version containing one or more assets (or files)\cr
\link[=codeartifact_put_domain_permissions_policy]{put_domain_permissions_policy} \tab Sets a resource policy on a domain that specifies permissions to access it\cr
\link[=codeartifact_put_package_origin_configuration]{put_package_origin_configuration} \tab Sets the package origin configuration for a package\cr
\link[=codeartifact_put_repository_permissions_policy]{put_repository_permissions_policy} \tab Sets the resource policy on a repository that specifies permissions to access it\cr
\link[=codeartifact_tag_resource]{tag_resource} \tab Adds or updates tags for a resource in CodeArtifact\cr
\link[=codeartifact_untag_resource]{untag_resource} \tab Removes tags from a resource in CodeArtifact\cr
\link[=codeartifact_update_package_group]{update_package_group} \tab Updates a package group\cr
\link[=codeartifact_update_package_group_origin_configuration]{update_package_group_origin_configuration} \tab Updates the package origin configuration for a package group\cr
\link[=codeartifact_update_package_versions_status]{update_package_versions_status} \tab Updates the status of one or more versions of a package\cr
\link[=codeartifact_update_repository]{update_repository} \tab Update the properties of a repository
}
}

\examples{
\dontrun{
svc <- codeartifact()
svc$associate_external_connection(
  Foo = 123
)
}

}
