% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_streaming_url}
\alias{appstream_create_streaming_url}
\title{Creates a temporary URL to start an AppStream 2}
\usage{
appstream_create_streaming_url(StackName, FleetName, UserId,
  ApplicationId, Validity, SessionContext)
}
\arguments{
\item{StackName}{[required] The name of the stack.}

\item{FleetName}{[required] The name of the fleet.}

\item{UserId}{[required] The identifier of the user.}

\item{ApplicationId}{The name of the application to launch after the session starts. This is
the name that you specified as \strong{Name} in the Image Assistant.}

\item{Validity}{The time that the streaming URL will be valid, in seconds. Specify a
value between 1 and 604800 seconds. The default is 60 seconds.}

\item{SessionContext}{The session context. For more information, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters}{Session Context}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  StreamingURL = "string",
  Expires = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Creates a temporary URL to start an AppStream 2.0 streaming session for
the specified user. A streaming URL enables application streaming to be
tested without user setup.
}
\section{Request syntax}{
\preformatted{svc$create_streaming_url(
  StackName = "string",
  FleetName = "string",
  UserId = "string",
  ApplicationId = "string",
  Validity = 123,
  SessionContext = "string"
)
}
}

\keyword{internal}
