% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_untag_resource}
\alias{appstream_untag_resource}
\title{Disassociates one or more specified tags from the specified AppStream 2}
\usage{
appstream_untag_resource(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource.}

\item{TagKeys}{[required] The tag keys for the tags to disassociate.}
}
\value{
An empty list.
}
\description{
Disassociates one or more specified tags from the specified AppStream
2.0 resource.

To list the current tags for your resources, use
\code{\link[=appstream_list_tags_for_resource]{list_tags_for_resource}}.

For more information about tags, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html}{Tagging Your Resources}
in the \emph{Amazon AppStream 2.0 Administration Guide}.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
