% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_stop_text_translation_job}
\alias{translate_stop_text_translation_job}
\title{Stops an asynchronous batch translation job that is in progress}
\usage{
translate_stop_text_translation_job(JobId)
}
\arguments{
\item{JobId}{[required] The job ID of the job to be stopped.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobId = "string",
  JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"COMPLETED_WITH_ERROR"|"FAILED"|"STOP_REQUESTED"|"STOPPED"
)
}
}
\description{
Stops an asynchronous batch translation job that is in progress.

If the job's state is \code{IN_PROGRESS}, the job will be marked for
termination and put into the \code{STOP_REQUESTED} state. If the job
completes before it can be stopped, it is put into the \code{COMPLETED}
state. Otherwise, the job is put into the \code{STOPPED} state.

Asynchronous batch translation jobs are started with the
\code{\link[=translate_start_text_translation_job]{start_text_translation_job}}
operation. You can use the
\code{\link[=translate_describe_text_translation_job]{describe_text_translation_job}}
or \code{\link[=translate_list_text_translation_jobs]{list_text_translation_jobs}}
operations to get a batch translation job's \code{JobId}.
}
\section{Request syntax}{
\preformatted{svc$stop_text_translation_job(
  JobId = "string"
)
}
}

\keyword{internal}
