% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_detect_entities}
\alias{comprehend_detect_entities}
\title{Inspects text for named entities, and returns information about them}
\usage{
comprehend_detect_entities(Text, LanguageCode)
}
\arguments{
\item{Text}{[required] A UTF-8 text string. Each string must contain fewer that 5,000 bytes of
UTF-8 encoded characters.}

\item{LanguageCode}{[required] The language of the input documents. You can specify any of the primary
languages supported by Amazon Comprehend: German ("de"), English
("en"), Spanish ("es"), French ("fr"), Italian ("it"), or
Portuguese ("pt"). All documents must be in the same language.}
}
\description{
Inspects text for named entities, and returns information about them.
For more information, about named entities, see how-entities.
}
\section{Request syntax}{
\preformatted{svc$detect_entities(
  Text = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"
)
}
}

\keyword{internal}
