% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_list_faces}
\alias{rekognition_list_faces}
\title{Returns metadata for faces in the specified collection}
\usage{
rekognition_list_faces(CollectionId, NextToken, MaxResults)
}
\arguments{
\item{CollectionId}{[required] ID of the collection from which to list the faces.}

\item{NextToken}{If the previous response was incomplete (because there is more data to
retrieve), Amazon Rekognition returns a pagination token in the
response. You can use this pagination token to retrieve the next set of
faces.}

\item{MaxResults}{Maximum number of faces to return.}
}
\description{
Returns metadata for faces in the specified collection. This metadata
includes information such as the bounding box coordinates, the
confidence (that the bounding box contains a face), and face ID. For an
example, see Listing Faces in a Collection in the Amazon Rekognition
Developer Guide.
}
\details{
This operation requires permissions to perform the
\code{rekognition:ListFaces} action.
}
\section{Request syntax}{
\preformatted{svc$list_faces(
  CollectionId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# This operation lists the faces in a Rekognition collection.
svc$list_faces(
  CollectionId = "myphotos",
  MaxResults = 20L
)
}

}
\keyword{internal}
