# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lookoutmetrics_service.R
NULL

#' Activates an anomaly detector
#'
#' @description
#' Activates an anomaly detector.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/activate_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/activate_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The ARN of the anomaly detector.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_activate_anomaly_detector
lookoutmetrics_activate_anomaly_detector <- function(AnomalyDetectorArn) {
  op <- new_operation(
    name = "ActivateAnomalyDetector",
    http_method = "POST",
    http_path = "/ActivateAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$activate_anomaly_detector_input(AnomalyDetectorArn = AnomalyDetectorArn)
  output <- .lookoutmetrics$activate_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$activate_anomaly_detector <- lookoutmetrics_activate_anomaly_detector

#' Runs a backtest for anomaly detection for the specified resource
#'
#' @description
#' Runs a backtest for anomaly detection for the specified resource.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/back_test_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/back_test_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_back_test_anomaly_detector
lookoutmetrics_back_test_anomaly_detector <- function(AnomalyDetectorArn) {
  op <- new_operation(
    name = "BackTestAnomalyDetector",
    http_method = "POST",
    http_path = "/BackTestAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$back_test_anomaly_detector_input(AnomalyDetectorArn = AnomalyDetectorArn)
  output <- .lookoutmetrics$back_test_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$back_test_anomaly_detector <- lookoutmetrics_back_test_anomaly_detector

#' Creates an alert for an anomaly detector
#'
#' @description
#' Creates an alert for an anomaly detector.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/create_alert.html](https://paws-r.github.io/docs/lookoutmetrics/create_alert.html) for full documentation.
#'
#' @param AlertName &#91;required&#93; The name of the alert.
#' @param AlertSensitivityThreshold An integer from 0 to 100 specifying the alert sensitivity threshold.
#' @param AlertDescription A description of the alert.
#' @param AnomalyDetectorArn &#91;required&#93; The ARN of the detector to which the alert is attached.
#' @param Action &#91;required&#93; Action that will be triggered when there is an alert.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
#' to apply to the alert.
#' @param AlertFilters The configuration of the alert filters, containing MetricList and
#' DimensionFilterList.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_create_alert
lookoutmetrics_create_alert <- function(AlertName, AlertSensitivityThreshold = NULL, AlertDescription = NULL, AnomalyDetectorArn, Action, Tags = NULL, AlertFilters = NULL) {
  op <- new_operation(
    name = "CreateAlert",
    http_method = "POST",
    http_path = "/CreateAlert",
    paginator = list()
  )
  input <- .lookoutmetrics$create_alert_input(AlertName = AlertName, AlertSensitivityThreshold = AlertSensitivityThreshold, AlertDescription = AlertDescription, AnomalyDetectorArn = AnomalyDetectorArn, Action = Action, Tags = Tags, AlertFilters = AlertFilters)
  output <- .lookoutmetrics$create_alert_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$create_alert <- lookoutmetrics_create_alert

#' Creates an anomaly detector
#'
#' @description
#' Creates an anomaly detector.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/create_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/create_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorName &#91;required&#93; The name of the detector.
#' @param AnomalyDetectorDescription A description of the detector.
#' @param AnomalyDetectorConfig &#91;required&#93; Contains information about the configuration of the anomaly detector.
#' @param KmsKeyArn The ARN of the KMS key to use to encrypt your data.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
#' to apply to the anomaly detector.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_create_anomaly_detector
lookoutmetrics_create_anomaly_detector <- function(AnomalyDetectorName, AnomalyDetectorDescription = NULL, AnomalyDetectorConfig, KmsKeyArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAnomalyDetector",
    http_method = "POST",
    http_path = "/CreateAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$create_anomaly_detector_input(AnomalyDetectorName = AnomalyDetectorName, AnomalyDetectorDescription = AnomalyDetectorDescription, AnomalyDetectorConfig = AnomalyDetectorConfig, KmsKeyArn = KmsKeyArn, Tags = Tags)
  output <- .lookoutmetrics$create_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$create_anomaly_detector <- lookoutmetrics_create_anomaly_detector

#' Creates a dataset
#'
#' @description
#' Creates a dataset.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/create_metric_set.html](https://paws-r.github.io/docs/lookoutmetrics/create_metric_set.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The ARN of the anomaly detector that will use the dataset.
#' @param MetricSetName &#91;required&#93; The name of the dataset.
#' @param MetricSetDescription A description of the dataset you are creating.
#' @param MetricList &#91;required&#93; A list of metrics that the dataset will contain.
#' @param Offset After an interval ends, the amount of seconds that the detector waits
#' before importing data. Offset is only supported for S3 and Redshift
#' datasources.
#' @param TimestampColumn Contains information about the column used for tracking time in your
#' source data.
#' @param DimensionList A list of the fields you want to treat as dimensions.
#' @param MetricSetFrequency The frequency with which the source data will be analyzed for anomalies.
#' @param MetricSource &#91;required&#93; Contains information about how the source data should be interpreted.
#' @param Timezone The time zone in which your source data was recorded.
#' @param Tags A list of
#' [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html)
#' to apply to the dataset.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_create_metric_set
lookoutmetrics_create_metric_set <- function(AnomalyDetectorArn, MetricSetName, MetricSetDescription = NULL, MetricList, Offset = NULL, TimestampColumn = NULL, DimensionList = NULL, MetricSetFrequency = NULL, MetricSource, Timezone = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMetricSet",
    http_method = "POST",
    http_path = "/CreateMetricSet",
    paginator = list()
  )
  input <- .lookoutmetrics$create_metric_set_input(AnomalyDetectorArn = AnomalyDetectorArn, MetricSetName = MetricSetName, MetricSetDescription = MetricSetDescription, MetricList = MetricList, Offset = Offset, TimestampColumn = TimestampColumn, DimensionList = DimensionList, MetricSetFrequency = MetricSetFrequency, MetricSource = MetricSource, Timezone = Timezone, Tags = Tags)
  output <- .lookoutmetrics$create_metric_set_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$create_metric_set <- lookoutmetrics_create_metric_set

#' Deactivates an anomaly detector
#'
#' @description
#' Deactivates an anomaly detector.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/deactivate_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/deactivate_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_deactivate_anomaly_detector
lookoutmetrics_deactivate_anomaly_detector <- function(AnomalyDetectorArn) {
  op <- new_operation(
    name = "DeactivateAnomalyDetector",
    http_method = "POST",
    http_path = "/DeactivateAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$deactivate_anomaly_detector_input(AnomalyDetectorArn = AnomalyDetectorArn)
  output <- .lookoutmetrics$deactivate_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$deactivate_anomaly_detector <- lookoutmetrics_deactivate_anomaly_detector

#' Deletes an alert
#'
#' @description
#' Deletes an alert.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/delete_alert.html](https://paws-r.github.io/docs/lookoutmetrics/delete_alert.html) for full documentation.
#'
#' @param AlertArn &#91;required&#93; The ARN of the alert to delete.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_delete_alert
lookoutmetrics_delete_alert <- function(AlertArn) {
  op <- new_operation(
    name = "DeleteAlert",
    http_method = "POST",
    http_path = "/DeleteAlert",
    paginator = list()
  )
  input <- .lookoutmetrics$delete_alert_input(AlertArn = AlertArn)
  output <- .lookoutmetrics$delete_alert_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$delete_alert <- lookoutmetrics_delete_alert

#' Deletes a detector
#'
#' @description
#' Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any configured datasets and alerts.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/delete_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/delete_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The ARN of the detector to delete.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_delete_anomaly_detector
lookoutmetrics_delete_anomaly_detector <- function(AnomalyDetectorArn) {
  op <- new_operation(
    name = "DeleteAnomalyDetector",
    http_method = "POST",
    http_path = "/DeleteAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$delete_anomaly_detector_input(AnomalyDetectorArn = AnomalyDetectorArn)
  output <- .lookoutmetrics$delete_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$delete_anomaly_detector <- lookoutmetrics_delete_anomaly_detector

#' Describes an alert
#'
#' @description
#' Describes an alert.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/describe_alert.html](https://paws-r.github.io/docs/lookoutmetrics/describe_alert.html) for full documentation.
#'
#' @param AlertArn &#91;required&#93; The ARN of the alert to describe.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_describe_alert
lookoutmetrics_describe_alert <- function(AlertArn) {
  op <- new_operation(
    name = "DescribeAlert",
    http_method = "POST",
    http_path = "/DescribeAlert",
    paginator = list()
  )
  input <- .lookoutmetrics$describe_alert_input(AlertArn = AlertArn)
  output <- .lookoutmetrics$describe_alert_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$describe_alert <- lookoutmetrics_describe_alert

#' Returns information about the status of the specified anomaly detection
#' jobs
#'
#' @description
#' Returns information about the status of the specified anomaly detection jobs.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/describe_anomaly_detection_executions.html](https://paws-r.github.io/docs/lookoutmetrics/describe_anomaly_detection_executions.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#' @param Timestamp The timestamp of the anomaly detection job.
#' @param MaxResults The number of items to return in the response.
#' @param NextToken Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_describe_anomaly_detection_executions
lookoutmetrics_describe_anomaly_detection_executions <- function(AnomalyDetectorArn, Timestamp = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAnomalyDetectionExecutions",
    http_method = "POST",
    http_path = "/DescribeAnomalyDetectionExecutions",
    paginator = list()
  )
  input <- .lookoutmetrics$describe_anomaly_detection_executions_input(AnomalyDetectorArn = AnomalyDetectorArn, Timestamp = Timestamp, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$describe_anomaly_detection_executions_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$describe_anomaly_detection_executions <- lookoutmetrics_describe_anomaly_detection_executions

#' Describes a detector
#'
#' @description
#' Describes a detector.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/describe_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/describe_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The ARN of the detector to describe.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_describe_anomaly_detector
lookoutmetrics_describe_anomaly_detector <- function(AnomalyDetectorArn) {
  op <- new_operation(
    name = "DescribeAnomalyDetector",
    http_method = "POST",
    http_path = "/DescribeAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$describe_anomaly_detector_input(AnomalyDetectorArn = AnomalyDetectorArn)
  output <- .lookoutmetrics$describe_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$describe_anomaly_detector <- lookoutmetrics_describe_anomaly_detector

#' Describes a dataset
#'
#' @description
#' Describes a dataset.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/describe_metric_set.html](https://paws-r.github.io/docs/lookoutmetrics/describe_metric_set.html) for full documentation.
#'
#' @param MetricSetArn &#91;required&#93; The ARN of the dataset.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_describe_metric_set
lookoutmetrics_describe_metric_set <- function(MetricSetArn) {
  op <- new_operation(
    name = "DescribeMetricSet",
    http_method = "POST",
    http_path = "/DescribeMetricSet",
    paginator = list()
  )
  input <- .lookoutmetrics$describe_metric_set_input(MetricSetArn = MetricSetArn)
  output <- .lookoutmetrics$describe_metric_set_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$describe_metric_set <- lookoutmetrics_describe_metric_set

#' Detects an Amazon S3 dataset's file format, interval, and offset
#'
#' @description
#' Detects an Amazon S3 dataset's file format, interval, and offset.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/detect_metric_set_config.html](https://paws-r.github.io/docs/lookoutmetrics/detect_metric_set_config.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; An anomaly detector ARN.
#' @param AutoDetectionMetricSource &#91;required&#93; A data source.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_detect_metric_set_config
lookoutmetrics_detect_metric_set_config <- function(AnomalyDetectorArn, AutoDetectionMetricSource) {
  op <- new_operation(
    name = "DetectMetricSetConfig",
    http_method = "POST",
    http_path = "/DetectMetricSetConfig",
    paginator = list()
  )
  input <- .lookoutmetrics$detect_metric_set_config_input(AnomalyDetectorArn = AnomalyDetectorArn, AutoDetectionMetricSource = AutoDetectionMetricSource)
  output <- .lookoutmetrics$detect_metric_set_config_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$detect_metric_set_config <- lookoutmetrics_detect_metric_set_config

#' Returns details about a group of anomalous metrics
#'
#' @description
#' Returns details about a group of anomalous metrics.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/get_anomaly_group.html](https://paws-r.github.io/docs/lookoutmetrics/get_anomaly_group.html) for full documentation.
#'
#' @param AnomalyGroupId &#91;required&#93; The ID of the anomaly group.
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_get_anomaly_group
lookoutmetrics_get_anomaly_group <- function(AnomalyGroupId, AnomalyDetectorArn) {
  op <- new_operation(
    name = "GetAnomalyGroup",
    http_method = "POST",
    http_path = "/GetAnomalyGroup",
    paginator = list()
  )
  input <- .lookoutmetrics$get_anomaly_group_input(AnomalyGroupId = AnomalyGroupId, AnomalyDetectorArn = AnomalyDetectorArn)
  output <- .lookoutmetrics$get_anomaly_group_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$get_anomaly_group <- lookoutmetrics_get_anomaly_group

#' Get feedback for an anomaly group
#'
#' @description
#' Get feedback for an anomaly group.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/get_feedback.html](https://paws-r.github.io/docs/lookoutmetrics/get_feedback.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#' @param AnomalyGroupTimeSeriesFeedback &#91;required&#93; The anomalous metric and group ID.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_get_feedback
lookoutmetrics_get_feedback <- function(AnomalyDetectorArn, AnomalyGroupTimeSeriesFeedback, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetFeedback",
    http_method = "POST",
    http_path = "/GetFeedback",
    paginator = list()
  )
  input <- .lookoutmetrics$get_feedback_input(AnomalyDetectorArn = AnomalyDetectorArn, AnomalyGroupTimeSeriesFeedback = AnomalyGroupTimeSeriesFeedback, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$get_feedback_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$get_feedback <- lookoutmetrics_get_feedback

#' Returns a selection of sample records from an Amazon S3 datasource
#'
#' @description
#' Returns a selection of sample records from an Amazon S3 datasource.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/get_sample_data.html](https://paws-r.github.io/docs/lookoutmetrics/get_sample_data.html) for full documentation.
#'
#' @param S3SourceConfig A datasource bucket in Amazon S3.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_get_sample_data
lookoutmetrics_get_sample_data <- function(S3SourceConfig = NULL) {
  op <- new_operation(
    name = "GetSampleData",
    http_method = "POST",
    http_path = "/GetSampleData",
    paginator = list()
  )
  input <- .lookoutmetrics$get_sample_data_input(S3SourceConfig = S3SourceConfig)
  output <- .lookoutmetrics$get_sample_data_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$get_sample_data <- lookoutmetrics_get_sample_data

#' Lists the alerts attached to a detector
#'
#' @description
#' Lists the alerts attached to a detector.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_alerts.html](https://paws-r.github.io/docs/lookoutmetrics/list_alerts.html) for full documentation.
#'
#' @param AnomalyDetectorArn The ARN of the alert's detector.
#' @param NextToken If the result of the previous request is truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#' @param MaxResults The maximum number of results that will be displayed by the request.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_alerts
lookoutmetrics_list_alerts <- function(AnomalyDetectorArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAlerts",
    http_method = "POST",
    http_path = "/ListAlerts",
    paginator = list()
  )
  input <- .lookoutmetrics$list_alerts_input(AnomalyDetectorArn = AnomalyDetectorArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .lookoutmetrics$list_alerts_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_alerts <- lookoutmetrics_list_alerts

#' Lists the detectors in the current AWS Region
#'
#' @description
#' Lists the detectors in the current AWS Region.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_detectors.html](https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_detectors.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to return.
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_anomaly_detectors
lookoutmetrics_list_anomaly_detectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAnomalyDetectors",
    http_method = "POST",
    http_path = "/ListAnomalyDetectors",
    paginator = list()
  )
  input <- .lookoutmetrics$list_anomaly_detectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$list_anomaly_detectors_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_anomaly_detectors <- lookoutmetrics_list_anomaly_detectors

#' Returns a list of measures that are potential causes or effects of an
#' anomaly group
#'
#' @description
#' Returns a list of measures that are potential causes or effects of an anomaly group.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_group_related_metrics.html](https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_group_related_metrics.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#' @param AnomalyGroupId &#91;required&#93; The ID of the anomaly group.
#' @param RelationshipTypeFilter Filter for potential causes (`CAUSE_OF_INPUT_ANOMALY_GROUP`) or
#' downstream effects (`EFFECT_OF_INPUT_ANOMALY_GROUP`) of the anomaly
#' group.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_anomaly_group_related_metrics
lookoutmetrics_list_anomaly_group_related_metrics <- function(AnomalyDetectorArn, AnomalyGroupId, RelationshipTypeFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAnomalyGroupRelatedMetrics",
    http_method = "POST",
    http_path = "/ListAnomalyGroupRelatedMetrics",
    paginator = list()
  )
  input <- .lookoutmetrics$list_anomaly_group_related_metrics_input(AnomalyDetectorArn = AnomalyDetectorArn, AnomalyGroupId = AnomalyGroupId, RelationshipTypeFilter = RelationshipTypeFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$list_anomaly_group_related_metrics_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_anomaly_group_related_metrics <- lookoutmetrics_list_anomaly_group_related_metrics

#' Returns a list of anomaly groups
#'
#' @description
#' Returns a list of anomaly groups.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_group_summaries.html](https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_group_summaries.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#' @param SensitivityThreshold &#91;required&#93; The minimum severity score for inclusion in the output.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_anomaly_group_summaries
lookoutmetrics_list_anomaly_group_summaries <- function(AnomalyDetectorArn, SensitivityThreshold, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAnomalyGroupSummaries",
    http_method = "POST",
    http_path = "/ListAnomalyGroupSummaries",
    paginator = list()
  )
  input <- .lookoutmetrics$list_anomaly_group_summaries_input(AnomalyDetectorArn = AnomalyDetectorArn, SensitivityThreshold = SensitivityThreshold, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$list_anomaly_group_summaries_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_anomaly_group_summaries <- lookoutmetrics_list_anomaly_group_summaries

#' Gets a list of anomalous metrics for a measure in an anomaly group
#'
#' @description
#' Gets a list of anomalous metrics for a measure in an anomaly group.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_group_time_series.html](https://paws-r.github.io/docs/lookoutmetrics/list_anomaly_group_time_series.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#' @param AnomalyGroupId &#91;required&#93; The ID of the anomaly group.
#' @param MetricName &#91;required&#93; The name of the measure field.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken Specify the pagination token that's returned by a previous request to
#' retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_anomaly_group_time_series
lookoutmetrics_list_anomaly_group_time_series <- function(AnomalyDetectorArn, AnomalyGroupId, MetricName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAnomalyGroupTimeSeries",
    http_method = "POST",
    http_path = "/ListAnomalyGroupTimeSeries",
    paginator = list()
  )
  input <- .lookoutmetrics$list_anomaly_group_time_series_input(AnomalyDetectorArn = AnomalyDetectorArn, AnomalyGroupId = AnomalyGroupId, MetricName = MetricName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$list_anomaly_group_time_series_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_anomaly_group_time_series <- lookoutmetrics_list_anomaly_group_time_series

#' Lists the datasets in the current AWS Region
#'
#' @description
#' Lists the datasets in the current AWS Region.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_metric_sets.html](https://paws-r.github.io/docs/lookoutmetrics/list_metric_sets.html) for full documentation.
#'
#' @param AnomalyDetectorArn The ARN of the anomaly detector containing the metrics sets to list.
#' @param MaxResults The maximum number of results to return.
#' @param NextToken If the result of the previous request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of results, use the
#' token in the next request. Tokens expire after 24 hours.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_metric_sets
lookoutmetrics_list_metric_sets <- function(AnomalyDetectorArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMetricSets",
    http_method = "POST",
    http_path = "/ListMetricSets",
    paginator = list()
  )
  input <- .lookoutmetrics$list_metric_sets_input(AnomalyDetectorArn = AnomalyDetectorArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .lookoutmetrics$list_metric_sets_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_metric_sets <- lookoutmetrics_list_metric_sets

#' Gets a list of tags for a detector, dataset, or alert
#'
#' @description
#' Gets a list of [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) for a detector, dataset, or alert.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/list_tags_for_resource.html](https://paws-r.github.io/docs/lookoutmetrics/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource's Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_list_tags_for_resource
lookoutmetrics_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .lookoutmetrics$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .lookoutmetrics$list_tags_for_resource_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$list_tags_for_resource <- lookoutmetrics_list_tags_for_resource

#' Add feedback for an anomalous metric
#'
#' @description
#' Add feedback for an anomalous metric.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/put_feedback.html](https://paws-r.github.io/docs/lookoutmetrics/put_feedback.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the anomaly detector.
#' @param AnomalyGroupTimeSeriesFeedback &#91;required&#93; Feedback for an anomalous metric.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_put_feedback
lookoutmetrics_put_feedback <- function(AnomalyDetectorArn, AnomalyGroupTimeSeriesFeedback) {
  op <- new_operation(
    name = "PutFeedback",
    http_method = "POST",
    http_path = "/PutFeedback",
    paginator = list()
  )
  input <- .lookoutmetrics$put_feedback_input(AnomalyDetectorArn = AnomalyDetectorArn, AnomalyGroupTimeSeriesFeedback = AnomalyGroupTimeSeriesFeedback)
  output <- .lookoutmetrics$put_feedback_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$put_feedback <- lookoutmetrics_put_feedback

#' Adds tags to a detector, dataset, or alert
#'
#' @description
#' Adds [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) to a detector, dataset, or alert.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/tag_resource.html](https://paws-r.github.io/docs/lookoutmetrics/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource's Amazon Resource Name (ARN).
#' @param Tags &#91;required&#93; Tags to apply to the resource. Tag keys and values can contain letters,
#' numbers, spaces, and the following symbols: `_.:/=+@@-`
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_tag_resource
lookoutmetrics_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .lookoutmetrics$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .lookoutmetrics$tag_resource_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$tag_resource <- lookoutmetrics_tag_resource

#' Removes tags from a detector, dataset, or alert
#'
#' @description
#' Removes [tags](https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html) from a detector, dataset, or alert.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/untag_resource.html](https://paws-r.github.io/docs/lookoutmetrics/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The resource's Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; Keys to remove from the resource's tags.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_untag_resource
lookoutmetrics_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .lookoutmetrics$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .lookoutmetrics$untag_resource_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$untag_resource <- lookoutmetrics_untag_resource

#' Make changes to an existing alert
#'
#' @description
#' Make changes to an existing alert.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/update_alert.html](https://paws-r.github.io/docs/lookoutmetrics/update_alert.html) for full documentation.
#'
#' @param AlertArn &#91;required&#93; The ARN of the alert to update.
#' @param AlertDescription A description of the alert.
#' @param AlertSensitivityThreshold An integer from 0 to 100 specifying the alert sensitivity threshold.
#' @param Action Action that will be triggered when there is an alert.
#' @param AlertFilters The configuration of the alert filters, containing MetricList and
#' DimensionFilterList.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_update_alert
lookoutmetrics_update_alert <- function(AlertArn, AlertDescription = NULL, AlertSensitivityThreshold = NULL, Action = NULL, AlertFilters = NULL) {
  op <- new_operation(
    name = "UpdateAlert",
    http_method = "POST",
    http_path = "/UpdateAlert",
    paginator = list()
  )
  input <- .lookoutmetrics$update_alert_input(AlertArn = AlertArn, AlertDescription = AlertDescription, AlertSensitivityThreshold = AlertSensitivityThreshold, Action = Action, AlertFilters = AlertFilters)
  output <- .lookoutmetrics$update_alert_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$update_alert <- lookoutmetrics_update_alert

#' Updates a detector
#'
#' @description
#' Updates a detector. After activation, you can only change a detector's ingestion delay and description.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/update_anomaly_detector.html](https://paws-r.github.io/docs/lookoutmetrics/update_anomaly_detector.html) for full documentation.
#'
#' @param AnomalyDetectorArn &#91;required&#93; The ARN of the detector to update.
#' @param KmsKeyArn The Amazon Resource Name (ARN) of an AWS KMS encryption key.
#' @param AnomalyDetectorDescription The updated detector description.
#' @param AnomalyDetectorConfig Contains information about the configuration to which the detector will
#' be updated.
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_update_anomaly_detector
lookoutmetrics_update_anomaly_detector <- function(AnomalyDetectorArn, KmsKeyArn = NULL, AnomalyDetectorDescription = NULL, AnomalyDetectorConfig = NULL) {
  op <- new_operation(
    name = "UpdateAnomalyDetector",
    http_method = "POST",
    http_path = "/UpdateAnomalyDetector",
    paginator = list()
  )
  input <- .lookoutmetrics$update_anomaly_detector_input(AnomalyDetectorArn = AnomalyDetectorArn, KmsKeyArn = KmsKeyArn, AnomalyDetectorDescription = AnomalyDetectorDescription, AnomalyDetectorConfig = AnomalyDetectorConfig)
  output <- .lookoutmetrics$update_anomaly_detector_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$update_anomaly_detector <- lookoutmetrics_update_anomaly_detector

#' Updates a dataset
#'
#' @description
#' Updates a dataset.
#'
#' See [https://paws-r.github.io/docs/lookoutmetrics/update_metric_set.html](https://paws-r.github.io/docs/lookoutmetrics/update_metric_set.html) for full documentation.
#'
#' @param MetricSetArn &#91;required&#93; The ARN of the dataset to update.
#' @param MetricSetDescription The dataset's description.
#' @param MetricList The metric list.
#' @param Offset After an interval ends, the amount of seconds that the detector waits
#' before importing data. Offset is only supported for S3 and Redshift
#' datasources.
#' @param TimestampColumn The timestamp column.
#' @param DimensionList The dimension list.
#' @param MetricSetFrequency The dataset's interval.
#' @param MetricSource 
#'
#' @keywords internal
#'
#' @rdname lookoutmetrics_update_metric_set
lookoutmetrics_update_metric_set <- function(MetricSetArn, MetricSetDescription = NULL, MetricList = NULL, Offset = NULL, TimestampColumn = NULL, DimensionList = NULL, MetricSetFrequency = NULL, MetricSource = NULL) {
  op <- new_operation(
    name = "UpdateMetricSet",
    http_method = "POST",
    http_path = "/UpdateMetricSet",
    paginator = list()
  )
  input <- .lookoutmetrics$update_metric_set_input(MetricSetArn = MetricSetArn, MetricSetDescription = MetricSetDescription, MetricList = MetricList, Offset = Offset, TimestampColumn = TimestampColumn, DimensionList = DimensionList, MetricSetFrequency = MetricSetFrequency, MetricSource = MetricSource)
  output <- .lookoutmetrics$update_metric_set_output()
  config <- get_config()
  svc <- .lookoutmetrics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lookoutmetrics$operations$update_metric_set <- lookoutmetrics_update_metric_set
