# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include voiceid_service.R
NULL

#' Creates a domain that contains all Amazon Connect Voice ID data, such as
#' speakers, fraudsters, customer audio, and voiceprints
#'
#' @description
#' Creates a domain that contains all Amazon Connect Voice ID data, such as speakers, fraudsters, customer audio, and voiceprints.
#'
#' See [https://paws-r.github.io/docs/voiceid/create_domain.html](https://paws-r.github.io/docs/voiceid/create_domain.html) for full documentation.
#'
#' @param ClientToken The idempotency token for creating a new domain. If not provided, Amazon
#' Web Services SDK populates this field.
#' @param Description A brief description of this domain.
#' @param Name &#91;required&#93; The name of the domain.
#' @param ServerSideEncryptionConfiguration &#91;required&#93; The configuration, containing the KMS key identifier, to be used by
#' Voice ID for the server-side encryption of your data. Refer to [Amazon
#' Connect Voice ID encryption at
#' rest](https://docs.aws.amazon.com/connect/latest/adminguide/encryption-at-rest.html#encryption-at-rest-voiceid)
#' for more details on how the KMS key is used.
#' @param Tags A list of tags you want added to the domain.
#'
#' @keywords internal
#'
#' @rdname voiceid_create_domain
voiceid_create_domain <- function(ClientToken = NULL, Description = NULL, Name, ServerSideEncryptionConfiguration, Tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$create_domain_input(ClientToken = ClientToken, Description = Description, Name = Name, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration, Tags = Tags)
  output <- .voiceid$create_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$create_domain <- voiceid_create_domain

#' Deletes the specified domain from Voice ID
#'
#' @description
#' Deletes the specified domain from Voice ID.
#'
#' See [https://paws-r.github.io/docs/voiceid/delete_domain.html](https://paws-r.github.io/docs/voiceid/delete_domain.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain you want to delete.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_domain
voiceid_delete_domain <- function(DomainId) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_domain_input(DomainId = DomainId)
  output <- .voiceid$delete_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_domain <- voiceid_delete_domain

#' Deletes the specified fraudster from Voice ID
#'
#' @description
#' Deletes the specified fraudster from Voice ID.
#'
#' See [https://paws-r.github.io/docs/voiceid/delete_fraudster.html](https://paws-r.github.io/docs/voiceid/delete_fraudster.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the fraudster.
#' @param FraudsterId &#91;required&#93; The identifier of the fraudster you want to delete.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_fraudster
voiceid_delete_fraudster <- function(DomainId, FraudsterId) {
  op <- new_operation(
    name = "DeleteFraudster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_fraudster_input(DomainId = DomainId, FraudsterId = FraudsterId)
  output <- .voiceid$delete_fraudster_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_fraudster <- voiceid_delete_fraudster

#' Deletes the specified speaker from Voice ID
#'
#' @description
#' Deletes the specified speaker from Voice ID.
#'
#' See [https://paws-r.github.io/docs/voiceid/delete_speaker.html](https://paws-r.github.io/docs/voiceid/delete_speaker.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the speaker.
#' @param SpeakerId &#91;required&#93; The identifier of the speaker you want to delete.
#'
#' @keywords internal
#'
#' @rdname voiceid_delete_speaker
voiceid_delete_speaker <- function(DomainId, SpeakerId) {
  op <- new_operation(
    name = "DeleteSpeaker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$delete_speaker_input(DomainId = DomainId, SpeakerId = SpeakerId)
  output <- .voiceid$delete_speaker_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$delete_speaker <- voiceid_delete_speaker

#' Describes the specified domain
#'
#' @description
#' Describes the specified domain.
#'
#' See [https://paws-r.github.io/docs/voiceid/describe_domain.html](https://paws-r.github.io/docs/voiceid/describe_domain.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_domain
voiceid_describe_domain <- function(DomainId) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_domain_input(DomainId = DomainId)
  output <- .voiceid$describe_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_domain <- voiceid_describe_domain

#' Describes the specified fraudster
#'
#' @description
#' Describes the specified fraudster.
#'
#' See [https://paws-r.github.io/docs/voiceid/describe_fraudster.html](https://paws-r.github.io/docs/voiceid/describe_fraudster.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the fraudster.
#' @param FraudsterId &#91;required&#93; The identifier of the fraudster you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_fraudster
voiceid_describe_fraudster <- function(DomainId, FraudsterId) {
  op <- new_operation(
    name = "DescribeFraudster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_fraudster_input(DomainId = DomainId, FraudsterId = FraudsterId)
  output <- .voiceid$describe_fraudster_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_fraudster <- voiceid_describe_fraudster

#' Describes the specified fraudster registration job
#'
#' @description
#' Describes the specified fraudster registration job.
#'
#' See [https://paws-r.github.io/docs/voiceid/describe_fraudster_registration_job.html](https://paws-r.github.io/docs/voiceid/describe_fraudster_registration_job.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier for the domain containing the fraudster registration job.
#' @param JobId &#91;required&#93; The identifier for the fraudster registration job you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_fraudster_registration_job
voiceid_describe_fraudster_registration_job <- function(DomainId, JobId) {
  op <- new_operation(
    name = "DescribeFraudsterRegistrationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_fraudster_registration_job_input(DomainId = DomainId, JobId = JobId)
  output <- .voiceid$describe_fraudster_registration_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_fraudster_registration_job <- voiceid_describe_fraudster_registration_job

#' Describes the specified speaker
#'
#' @description
#' Describes the specified speaker.
#'
#' See [https://paws-r.github.io/docs/voiceid/describe_speaker.html](https://paws-r.github.io/docs/voiceid/describe_speaker.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker.
#' @param SpeakerId &#91;required&#93; The identifier of the speaker you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_speaker
voiceid_describe_speaker <- function(DomainId, SpeakerId) {
  op <- new_operation(
    name = "DescribeSpeaker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_speaker_input(DomainId = DomainId, SpeakerId = SpeakerId)
  output <- .voiceid$describe_speaker_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_speaker <- voiceid_describe_speaker

#' Describes the specified speaker enrollment job
#'
#' @description
#' Describes the specified speaker enrollment job.
#'
#' See [https://paws-r.github.io/docs/voiceid/describe_speaker_enrollment_job.html](https://paws-r.github.io/docs/voiceid/describe_speaker_enrollment_job.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the speaker enrollment job.
#' @param JobId &#91;required&#93; The identifier of the speaker enrollment job you are describing.
#'
#' @keywords internal
#'
#' @rdname voiceid_describe_speaker_enrollment_job
voiceid_describe_speaker_enrollment_job <- function(DomainId, JobId) {
  op <- new_operation(
    name = "DescribeSpeakerEnrollmentJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$describe_speaker_enrollment_job_input(DomainId = DomainId, JobId = JobId)
  output <- .voiceid$describe_speaker_enrollment_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$describe_speaker_enrollment_job <- voiceid_describe_speaker_enrollment_job

#' Evaluates a specified session based on audio data accumulated during a
#' streaming Amazon Connect Voice ID call
#'
#' @description
#' Evaluates a specified session based on audio data accumulated during a streaming Amazon Connect Voice ID call.
#'
#' See [https://paws-r.github.io/docs/voiceid/evaluate_session.html](https://paws-r.github.io/docs/voiceid/evaluate_session.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain where the session started.
#' @param SessionNameOrId &#91;required&#93; The session identifier, or name of the session, that you want to
#' evaluate. In Voice ID integration, this is the Contact-Id.
#'
#' @keywords internal
#'
#' @rdname voiceid_evaluate_session
voiceid_evaluate_session <- function(DomainId, SessionNameOrId) {
  op <- new_operation(
    name = "EvaluateSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$evaluate_session_input(DomainId = DomainId, SessionNameOrId = SessionNameOrId)
  output <- .voiceid$evaluate_session_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$evaluate_session <- voiceid_evaluate_session

#' Lists all the domains in the Amazon Web Services account
#'
#' @description
#' Lists all the domains in the Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/voiceid/list_domains.html](https://paws-r.github.io/docs/voiceid/list_domains.html) for full documentation.
#'
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain further pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_domains
voiceid_list_domains <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$list_domains_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_domains_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_domains <- voiceid_list_domains

#' Lists all the fraudster registration jobs in the domain with the given
#' JobStatus
#'
#' @description
#' Lists all the fraudster registration jobs in the domain with the given `JobStatus`. If `JobStatus` is not provided, this lists all fraudster registration jobs in the given domain.
#'
#' See [https://paws-r.github.io/docs/voiceid/list_fraudster_registration_jobs.html](https://paws-r.github.io/docs/voiceid/list_fraudster_registration_jobs.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the fraudster registration Jobs.
#' @param JobStatus Provides the status of your fraudster registration job.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain further pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_fraudster_registration_jobs
voiceid_list_fraudster_registration_jobs <- function(DomainId, JobStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFraudsterRegistrationJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$list_fraudster_registration_jobs_input(DomainId = DomainId, JobStatus = JobStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_fraudster_registration_jobs_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_fraudster_registration_jobs <- voiceid_list_fraudster_registration_jobs

#' Lists all the speaker enrollment jobs in the domain with the specified
#' JobStatus
#'
#' @description
#' Lists all the speaker enrollment jobs in the domain with the specified `JobStatus`. If `JobStatus` is not provided, this lists all jobs with all possible speaker enrollment job statuses.
#'
#' See [https://paws-r.github.io/docs/voiceid/list_speaker_enrollment_jobs.html](https://paws-r.github.io/docs/voiceid/list_speaker_enrollment_jobs.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the speaker enrollment jobs.
#' @param JobStatus Provides the status of your speaker enrollment Job.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain further pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_speaker_enrollment_jobs
voiceid_list_speaker_enrollment_jobs <- function(DomainId, JobStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSpeakerEnrollmentJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$list_speaker_enrollment_jobs_input(DomainId = DomainId, JobStatus = JobStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_speaker_enrollment_jobs_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_speaker_enrollment_jobs <- voiceid_list_speaker_enrollment_jobs

#' Lists all speakers in a specified domain
#'
#' @description
#' Lists all speakers in a specified domain.
#'
#' See [https://paws-r.github.io/docs/voiceid/list_speakers.html](https://paws-r.github.io/docs/voiceid/list_speakers.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain.
#' @param MaxResults The maximum number of results that are returned per call. You can use
#' `NextToken` to obtain further pages of results. The default is 100; the
#' maximum allowed page size is also 100.
#' @param NextToken If `NextToken` is returned, there are more results available. The value
#' of `NextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_speakers
voiceid_list_speakers <- function(DomainId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSpeakers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$list_speakers_input(DomainId = DomainId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .voiceid$list_speakers_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_speakers <- voiceid_list_speakers

#' Lists all tags associated with a specified Voice ID resource
#'
#' @description
#' Lists all tags associated with a specified Voice ID resource.
#'
#' See [https://paws-r.github.io/docs/voiceid/list_tags_for_resource.html](https://paws-r.github.io/docs/voiceid/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Voice ID resource for which you
#' want to list the tags.
#'
#' @keywords internal
#'
#' @rdname voiceid_list_tags_for_resource
voiceid_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .voiceid$list_tags_for_resource_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$list_tags_for_resource <- voiceid_list_tags_for_resource

#' Opts out a speaker from Voice ID
#'
#' @description
#' Opts out a speaker from Voice ID. A speaker can be opted out regardless of whether or not they already exist in Voice ID. If they don't yet exist, a new speaker is created in an opted out state. If they already exist, their existing status is overridden and they are opted out. Enrollment and evaluation authentication requests are rejected for opted out speakers, and opted out speakers have no voice embeddings stored in Voice ID.
#'
#' See [https://paws-r.github.io/docs/voiceid/opt_out_speaker.html](https://paws-r.github.io/docs/voiceid/opt_out_speaker.html) for full documentation.
#'
#' @param DomainId &#91;required&#93; The identifier of the domain containing the speaker.
#' @param SpeakerId &#91;required&#93; The identifier of the speaker you want opted-out.
#'
#' @keywords internal
#'
#' @rdname voiceid_opt_out_speaker
voiceid_opt_out_speaker <- function(DomainId, SpeakerId) {
  op <- new_operation(
    name = "OptOutSpeaker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$opt_out_speaker_input(DomainId = DomainId, SpeakerId = SpeakerId)
  output <- .voiceid$opt_out_speaker_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$opt_out_speaker <- voiceid_opt_out_speaker

#' Starts a new batch fraudster registration job using provided details
#'
#' @description
#' Starts a new batch fraudster registration job using provided details.
#'
#' See [https://paws-r.github.io/docs/voiceid/start_fraudster_registration_job.html](https://paws-r.github.io/docs/voiceid/start_fraudster_registration_job.html) for full documentation.
#'
#' @param ClientToken The idempotency token for starting a new fraudster registration job. If
#' not provided, Amazon Web Services SDK populates this field.
#' @param DataAccessRoleArn &#91;required&#93; The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
#' to access customer's buckets to read the input manifest file and write
#' the Job output file. Refer to the [Create and edit a fraudster
#' watchlist](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-fraudster-watchlist.html)
#' documentation for the permissions needed in this role.
#' @param DomainId &#91;required&#93; The identifier of the domain containing the fraudster registration job
#' and in which the fraudsters are registered.
#' @param InputDataConfig &#91;required&#93; The input data config containing an S3 URI for the input manifest file
#' that contains the list of fraudster registration requests.
#' @param JobName The name of the new fraudster registration job.
#' @param OutputDataConfig &#91;required&#93; The output data config containing the S3 location where Voice ID writes
#' the job output file; you must also include a KMS key ID to encrypt the
#' file.
#' @param RegistrationConfig The registration config containing details such as the action to take
#' when a duplicate fraudster is detected, and the similarity threshold to
#' use for detecting a duplicate fraudster.
#'
#' @keywords internal
#'
#' @rdname voiceid_start_fraudster_registration_job
voiceid_start_fraudster_registration_job <- function(ClientToken = NULL, DataAccessRoleArn, DomainId, InputDataConfig, JobName = NULL, OutputDataConfig, RegistrationConfig = NULL) {
  op <- new_operation(
    name = "StartFraudsterRegistrationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$start_fraudster_registration_job_input(ClientToken = ClientToken, DataAccessRoleArn = DataAccessRoleArn, DomainId = DomainId, InputDataConfig = InputDataConfig, JobName = JobName, OutputDataConfig = OutputDataConfig, RegistrationConfig = RegistrationConfig)
  output <- .voiceid$start_fraudster_registration_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$start_fraudster_registration_job <- voiceid_start_fraudster_registration_job

#' Starts a new batch speaker enrollment job using specified details
#'
#' @description
#' Starts a new batch speaker enrollment job using specified details.
#'
#' See [https://paws-r.github.io/docs/voiceid/start_speaker_enrollment_job.html](https://paws-r.github.io/docs/voiceid/start_speaker_enrollment_job.html) for full documentation.
#'
#' @param ClientToken The idempotency token for starting a new speaker enrollment Job. If not
#' provided, Amazon Web Services SDK populates this field.
#' @param DataAccessRoleArn &#91;required&#93; The IAM role Amazon Resource Name (ARN) that grants Voice ID permissions
#' to access customer's buckets to read the input manifest file and write
#' the job output file. Refer to [Batch enrollment using audio data from
#' prior
#' calls](https://docs.aws.amazon.com/connect/latest/adminguide/voiceid-batch-enrollment.html)
#' documentation for the permissions needed in this role.
#' @param DomainId &#91;required&#93; The identifier of the domain that contains the speaker enrollment job
#' and in which the speakers are enrolled.
#' @param EnrollmentConfig The enrollment config that contains details such as the action to take
#' when a speaker is already enrolled in Voice ID or when a speaker is
#' identified as a fraudster.
#' @param InputDataConfig &#91;required&#93; The input data config containing the S3 location for the input manifest
#' file that contains the list of speaker enrollment requests.
#' @param JobName A name for your speaker enrollment job.
#' @param OutputDataConfig &#91;required&#93; The output data config containing the S3 location where Voice ID writes
#' the job output file; you must also include a KMS key ID to encrypt the
#' file.
#'
#' @keywords internal
#'
#' @rdname voiceid_start_speaker_enrollment_job
voiceid_start_speaker_enrollment_job <- function(ClientToken = NULL, DataAccessRoleArn, DomainId, EnrollmentConfig = NULL, InputDataConfig, JobName = NULL, OutputDataConfig) {
  op <- new_operation(
    name = "StartSpeakerEnrollmentJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$start_speaker_enrollment_job_input(ClientToken = ClientToken, DataAccessRoleArn = DataAccessRoleArn, DomainId = DomainId, EnrollmentConfig = EnrollmentConfig, InputDataConfig = InputDataConfig, JobName = JobName, OutputDataConfig = OutputDataConfig)
  output <- .voiceid$start_speaker_enrollment_job_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$start_speaker_enrollment_job <- voiceid_start_speaker_enrollment_job

#' Tags a Voice ID resource with the provided list of tags
#'
#' @description
#' Tags a Voice ID resource with the provided list of tags.
#'
#' See [https://paws-r.github.io/docs/voiceid/tag_resource.html](https://paws-r.github.io/docs/voiceid/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Voice ID resource you want to tag.
#' @param Tags &#91;required&#93; The list of tags to assign to the specified resource.
#'
#' @keywords internal
#'
#' @rdname voiceid_tag_resource
voiceid_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .voiceid$tag_resource_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$tag_resource <- voiceid_tag_resource

#' Removes specified tags from a specified Amazon Connect Voice ID resource
#'
#' @description
#' Removes specified tags from a specified Amazon Connect Voice ID resource.
#'
#' See [https://paws-r.github.io/docs/voiceid/untag_resource.html](https://paws-r.github.io/docs/voiceid/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Voice ID resource you want to
#' remove tags from.
#' @param TagKeys &#91;required&#93; The list of tag keys you want to remove from the specified resource.
#'
#' @keywords internal
#'
#' @rdname voiceid_untag_resource
voiceid_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .voiceid$untag_resource_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$untag_resource <- voiceid_untag_resource

#' Updates the specified domain
#'
#' @description
#' Updates the specified domain. This API has clobber behavior, and clears and replaces all attributes. If an optional field, such as 'Description' is not provided, it is removed from the domain.
#'
#' See [https://paws-r.github.io/docs/voiceid/update_domain.html](https://paws-r.github.io/docs/voiceid/update_domain.html) for full documentation.
#'
#' @param Description A brief description about this domain.
#' @param DomainId &#91;required&#93; The identifier of the domain to be updated.
#' @param Name &#91;required&#93; The name of the domain.
#' @param ServerSideEncryptionConfiguration &#91;required&#93; The configuration, containing the KMS key identifier, to be used by
#' Voice ID for the server-side encryption of your data. Note that all the
#' existing data in the domain are still encrypted using the existing key,
#' only the data added to domain after updating the key is encrypted using
#' the new key.
#'
#' @keywords internal
#'
#' @rdname voiceid_update_domain
voiceid_update_domain <- function(Description = NULL, DomainId, Name, ServerSideEncryptionConfiguration) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .voiceid$update_domain_input(Description = Description, DomainId = DomainId, Name = Name, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration)
  output <- .voiceid$update_domain_output()
  config <- get_config()
  svc <- .voiceid$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.voiceid$operations$update_domain <- voiceid_update_domain
