% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_service.R
\name{frauddetector}
\alias{frauddetector}
\title{Amazon Fraud Detector}
\usage{
frauddetector(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This is the Amazon Fraud Detector API Reference. This guide is for
developers who need detailed information about Amazon Fraud Detector API
actions, data types, and errors. For more information about Amazon Fraud
Detector features, see the \href{https://docs.aws.amazon.com/frauddetector/latest/ug/}{Amazon Fraud Detector User Guide}.

We provide the Query API as well as AWS software development kits (SDK)
for Amazon Fraud Detector in Java and Python programming languages.

The Amazon Fraud Detector Query API provides HTTPS requests that use the
HTTP verb GET or POST and a Query parameter \code{Action}. AWS SDK provides
libraries, sample code, tutorials, and other resources for software
developers who prefer to build applications using language-specific APIs
instead of submitting a request over HTTP or HTTPS. These libraries
provide basic functions that automatically take care of tasks such as
cryptographically signing your requests, retrying requests, and handling
error responses, so that it is easier for you to get started. For more
information about the AWS SDKs, see Tools to build on AWS.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- frauddetector(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=frauddetector_batch_create_variable]{batch_create_variable} \tab Creates a batch of variables\cr
\link[=frauddetector_batch_get_variable]{batch_get_variable} \tab Gets a batch of variables\cr
\link[=frauddetector_cancel_batch_import_job]{cancel_batch_import_job} \tab Cancels an in-progress batch import job\cr
\link[=frauddetector_cancel_batch_prediction_job]{cancel_batch_prediction_job} \tab Cancels the specified batch prediction job\cr
\link[=frauddetector_create_batch_import_job]{create_batch_import_job} \tab Creates a batch import job\cr
\link[=frauddetector_create_batch_prediction_job]{create_batch_prediction_job} \tab Creates a batch prediction job\cr
\link[=frauddetector_create_detector_version]{create_detector_version} \tab Creates a detector version\cr
\link[=frauddetector_create_model]{create_model} \tab Creates a model using the specified model type\cr
\link[=frauddetector_create_model_version]{create_model_version} \tab Creates a version of the model using the specified model type and model id\cr
\link[=frauddetector_create_rule]{create_rule} \tab Creates a rule for use with the specified detector\cr
\link[=frauddetector_create_variable]{create_variable} \tab Creates a variable\cr
\link[=frauddetector_delete_batch_import_job]{delete_batch_import_job} \tab Deletes the specified batch import job ID record\cr
\link[=frauddetector_delete_batch_prediction_job]{delete_batch_prediction_job} \tab Deletes a batch prediction job\cr
\link[=frauddetector_delete_detector]{delete_detector} \tab Deletes the detector\cr
\link[=frauddetector_delete_detector_version]{delete_detector_version} \tab Deletes the detector version\cr
\link[=frauddetector_delete_entity_type]{delete_entity_type} \tab Deletes an entity type\cr
\link[=frauddetector_delete_event]{delete_event} \tab Deletes the specified event\cr
\link[=frauddetector_delete_events_by_event_type]{delete_events_by_event_type} \tab Deletes all events of a particular event type\cr
\link[=frauddetector_delete_event_type]{delete_event_type} \tab Deletes an event type\cr
\link[=frauddetector_delete_external_model]{delete_external_model} \tab Removes a SageMaker model from Amazon Fraud Detector\cr
\link[=frauddetector_delete_label]{delete_label} \tab Deletes a label\cr
\link[=frauddetector_delete_model]{delete_model} \tab Deletes a model\cr
\link[=frauddetector_delete_model_version]{delete_model_version} \tab Deletes a model version\cr
\link[=frauddetector_delete_outcome]{delete_outcome} \tab Deletes an outcome\cr
\link[=frauddetector_delete_rule]{delete_rule} \tab Deletes the rule\cr
\link[=frauddetector_delete_variable]{delete_variable} \tab Deletes a variable\cr
\link[=frauddetector_describe_detector]{describe_detector} \tab Gets all versions for a specified detector\cr
\link[=frauddetector_describe_model_versions]{describe_model_versions} \tab Gets all of the model versions for the specified model type or for the specified model type and model ID\cr
\link[=frauddetector_get_batch_import_jobs]{get_batch_import_jobs} \tab Gets all batch import jobs or a specific job of the specified ID\cr
\link[=frauddetector_get_batch_prediction_jobs]{get_batch_prediction_jobs} \tab Gets all batch prediction jobs or a specific job if you specify a job ID\cr
\link[=frauddetector_get_delete_events_by_event_type_status]{get_delete_events_by_event_type_status} \tab Retrieves the status of a DeleteEventsByEventType action\cr
\link[=frauddetector_get_detectors]{get_detectors} \tab Gets all detectors or a single detector if a detectorId is specified\cr
\link[=frauddetector_get_detector_version]{get_detector_version} \tab Gets a particular detector version\cr
\link[=frauddetector_get_entity_types]{get_entity_types} \tab Gets all entity types or a specific entity type if a name is specified\cr
\link[=frauddetector_get_event]{get_event} \tab Retrieves details of events stored with Amazon Fraud Detector\cr
\link[=frauddetector_get_event_prediction]{get_event_prediction} \tab Evaluates an event against a detector version\cr
\link[=frauddetector_get_event_prediction_metadata]{get_event_prediction_metadata} \tab Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector version ID that was generated in the specified time period\cr
\link[=frauddetector_get_event_types]{get_event_types} \tab Gets all event types or a specific event type if name is provided\cr
\link[=frauddetector_get_external_models]{get_external_models} \tab Gets the details for one or more Amazon SageMaker models that have been imported into the service\cr
\link[=frauddetector_get_kms_encryption_key]{get_kms_encryption_key} \tab Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector\cr
\link[=frauddetector_get_labels]{get_labels} \tab Gets all labels or a specific label if name is provided\cr
\link[=frauddetector_get_models]{get_models} \tab Gets one or more models\cr
\link[=frauddetector_get_model_version]{get_model_version} \tab Gets the details of the specified model version\cr
\link[=frauddetector_get_outcomes]{get_outcomes} \tab Gets one or more outcomes\cr
\link[=frauddetector_get_rules]{get_rules} \tab Get all rules for a detector (paginated) if ruleId and ruleVersion are not specified\cr
\link[=frauddetector_get_variables]{get_variables} \tab Gets all of the variables or the specific variable\cr
\link[=frauddetector_list_event_predictions]{list_event_predictions} \tab Gets a list of past predictions\cr
\link[=frauddetector_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags associated with the resource\cr
\link[=frauddetector_put_detector]{put_detector} \tab Creates or updates a detector\cr
\link[=frauddetector_put_entity_type]{put_entity_type} \tab Creates or updates an entity type\cr
\link[=frauddetector_put_event_type]{put_event_type} \tab Creates or updates an event type\cr
\link[=frauddetector_put_external_model]{put_external_model} \tab Creates or updates an Amazon SageMaker model endpoint\cr
\link[=frauddetector_put_kms_encryption_key]{put_kms_encryption_key} \tab Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector\cr
\link[=frauddetector_put_label]{put_label} \tab Creates or updates label\cr
\link[=frauddetector_put_outcome]{put_outcome} \tab Creates or updates an outcome\cr
\link[=frauddetector_send_event]{send_event} \tab Stores events in Amazon Fraud Detector without generating fraud predictions for those events\cr
\link[=frauddetector_tag_resource]{tag_resource} \tab Assigns tags to a resource\cr
\link[=frauddetector_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
\link[=frauddetector_update_detector_version]{update_detector_version} \tab Updates a detector version\cr
\link[=frauddetector_update_detector_version_metadata]{update_detector_version_metadata} \tab Updates the detector version's description\cr
\link[=frauddetector_update_detector_version_status]{update_detector_version_status} \tab Updates the detector version’s status\cr
\link[=frauddetector_update_event_label]{update_event_label} \tab Updates the specified event with a new label\cr
\link[=frauddetector_update_model]{update_model} \tab Updates model description\cr
\link[=frauddetector_update_model_version]{update_model_version} \tab Updates a model version\cr
\link[=frauddetector_update_model_version_status]{update_model_version_status} \tab Updates the status of a model version\cr
\link[=frauddetector_update_rule_metadata]{update_rule_metadata} \tab Updates a rule's metadata\cr
\link[=frauddetector_update_rule_version]{update_rule_version} \tab Updates a rule version resulting in a new rule version\cr
\link[=frauddetector_update_variable]{update_variable} \tab Updates a variable
}
}

\examples{
\dontrun{
svc <- frauddetector()
svc$batch_create_variable(
  Foo = 123
)
}

}
