% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_send_event}
\alias{frauddetector_send_event}
\title{Stores events in Amazon Fraud Detector without generating fraud
predictions for those events}
\usage{
frauddetector_send_event(
  eventId,
  eventTypeName,
  eventTimestamp,
  eventVariables,
  assignedLabel = NULL,
  labelTimestamp = NULL,
  entities
)
}
\arguments{
\item{eventId}{[required] The event ID to upload.}

\item{eventTypeName}{[required] The event type name of the event.}

\item{eventTimestamp}{[required] The timestamp that defines when the event under evaluation occurred. The
timestamp must be specified using ISO 8601 standard in UTC.}

\item{eventVariables}{[required] Names of the event type's variables you defined in Amazon Fraud Detector
to represent data elements and their corresponding values for the event
you are sending for evaluation.}

\item{assignedLabel}{The label to associate with the event. Required if specifying
\code{labelTimestamp}.}

\item{labelTimestamp}{The timestamp associated with the label. Required if specifying
\code{assignedLabel}.}

\item{entities}{[required] An array of entities.}
}
\description{
Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you can use \code{\link[=frauddetector_send_event]{send_event}} to upload a historical dataset, which you can then later use to train a model.

See \url{https://paws-r.github.io/docs/frauddetector/send_event.html} for full documentation.
}
\keyword{internal}
