% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_user_profile}
\alias{sagemaker_create_user_profile}
\title{Creates a user profile}
\usage{
sagemaker_create_user_profile(
  DomainId,
  UserProfileName,
  SingleSignOnUserIdentifier = NULL,
  SingleSignOnUserValue = NULL,
  Tags = NULL,
  UserSettings = NULL
)
}
\arguments{
\item{DomainId}{[required] The ID of the associated Domain.}

\item{UserProfileName}{[required] A name for the UserProfile. This value is not case sensitive.}

\item{SingleSignOnUserIdentifier}{A specifier for the type of value specified in SingleSignOnUserValue.
Currently, the only supported value is "UserName". If the Domain's
AuthMode is SSO, this field is required. If the Domain's AuthMode is not
SSO, this field cannot be specified.}

\item{SingleSignOnUserValue}{The username of the associated Amazon Web Services Single Sign-On User
for this UserProfile. If the Domain's AuthMode is SSO, this field is
required, and must match a valid username of a user in your directory.
If the Domain's AuthMode is not SSO, this field cannot be specified.}

\item{Tags}{Each tag consists of a key and an optional value. Tag keys must be
unique per resource.

Tags that you specify for the User Profile are also added to all Apps
that the User Profile launches.}

\item{UserSettings}{A collection of settings.}
}
\description{
Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user's private Amazon Elastic File System (EFS) home directory.

See \url{https://paws-r.github.io/docs/sagemaker/create_user_profile.html} for full documentation.
}
\keyword{internal}
