% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_query_lineage}
\alias{sagemaker_query_lineage}
\title{Use this action to inspect your lineage and discover relationships
between entities}
\usage{
sagemaker_query_lineage(
  StartArns = NULL,
  Direction = NULL,
  IncludeEdges = NULL,
  Filters = NULL,
  MaxDepth = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{StartArns}{A list of resource Amazon Resource Name (ARN) that represent the
starting point for your lineage query.}

\item{Direction}{Associations between lineage entities have a direction. This parameter
determines the direction from the StartArn(s) that the query traverses.}

\item{IncludeEdges}{Setting this value to \code{True} retrieves not only the entities of interest
but also the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html}{Associations}
and lineage entities on the path. Set to \code{False} to only return lineage
entities that match your query.}

\item{Filters}{A set of filtering parameters that allow you to specify which entities
should be returned.
\itemize{
\item Properties - Key-value pairs to match on the lineage entities'
properties.
\item LineageTypes - A set of lineage entity types to match on. For
example: \code{TrialComponent}, \code{Artifact}, or \code{Context}.
\item CreatedBefore - Filter entities created before this date.
\item ModifiedBefore - Filter entities modified before this date.
\item ModifiedAfter - Filter entities modified after this date.
}}

\item{MaxDepth}{The maximum depth in lineage relationships from the \code{StartArns} that are
traversed. Depth is a measure of the number of \code{Associations} from the
\code{StartArn} entity to the matched results.}

\item{MaxResults}{Limits the number of vertices in the results. Use the \code{NextToken} in a
response to to retrieve the next page of results.}

\item{NextToken}{Limits the number of vertices in the request. Use the \code{NextToken} in a
response to to retrieve the next page of results.}
}
\description{
Use this action to inspect your lineage and discover relationships between entities. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html}{Querying Lineage Entities} in the \emph{Amazon SageMaker Developer Guide}.

See \url{https://paws-r.github.io/docs/sagemaker/query_lineage.html} for full documentation.
}
\keyword{internal}
