% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_update_medical_vocabulary}
\alias{transcribeservice_update_medical_vocabulary}
\title{Updates an existing custom medical vocabulary with new values}
\usage{
transcribeservice_update_medical_vocabulary(
  VocabularyName,
  LanguageCode,
  VocabularyFileUri
)
}
\arguments{
\item{VocabularyName}{[required] The name of the custom medical vocabulary you want to update. Vocabulary
names are case sensitive.}

\item{LanguageCode}{[required] The language code that represents the language of the entries in the
custom vocabulary you want to update. US English (\code{en-US}) is the only
language supported with Amazon Transcribe Medical.}

\item{VocabularyFileUri}{[required] The Amazon S3 location of the text file that contains your custom
medical vocabulary. The URI must be located in the same Amazon Web
Services Region as the resource you're calling.

Here's an example URI path: \verb{s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt}}
}
\description{
Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing vocabulary.

See \url{https://paws-r.github.io/docs/transcribeservice/update_medical_vocabulary.html} for full documentation.
}
\keyword{internal}
