% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_start_speech_synthesis_task}
\alias{polly_start_speech_synthesis_task}
\title{Allows the creation of an asynchronous synthesis task, by starting a new
SpeechSynthesisTask}
\usage{
polly_start_speech_synthesis_task(
  Engine = NULL,
  LanguageCode = NULL,
  LexiconNames = NULL,
  OutputFormat,
  OutputS3BucketName,
  OutputS3KeyPrefix = NULL,
  SampleRate = NULL,
  SnsTopicArn = NULL,
  SpeechMarkTypes = NULL,
  Text,
  TextType = NULL,
  VoiceId
)
}
\arguments{
\item{Engine}{Specifies the engine (\code{standard} or \code{neural}) for Amazon Polly to use
when processing input text for speech synthesis. Using a voice that is
not supported for the engine selected will result in an error.}

\item{LanguageCode}{Optional language code for the Speech Synthesis request. This is only
necessary if using a bilingual voice, such as Aditi, which can be used
for either Indian English (en-IN) or Hindi (hi-IN).

If a bilingual voice is used and no language code is specified, Amazon
Polly uses the default language of the bilingual voice. The default
language for any voice is the one returned by the
\code{\link[=polly_describe_voices]{describe_voices}} operation for the
\code{LanguageCode} parameter. For example, if no language code is specified,
Aditi will use Indian English rather than Hindi.}

\item{LexiconNames}{List of one or more pronunciation lexicon names you want the service to
apply during synthesis. Lexicons are applied only if the language of the
lexicon is the same as the language of the voice.}

\item{OutputFormat}{[required] The format in which the returned output will be encoded. For audio
stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this
will be json.}

\item{OutputS3BucketName}{[required] Amazon S3 bucket name to which the output file will be saved.}

\item{OutputS3KeyPrefix}{The Amazon S3 key prefix for the output speech file.}

\item{SampleRate}{The audio frequency specified in Hz.

The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
and "24000". The default value for standard voices is "22050". The
default value for neural voices is "24000".

Valid values for pcm are "8000" and "16000" The default value is
"16000".}

\item{SnsTopicArn}{ARN for the SNS topic optionally used for providing status notification
for a speech synthesis task.}

\item{SpeechMarkTypes}{The type of speech marks returned for the input text.}

\item{Text}{[required] The input text to synthesize. If you specify ssml as the TextType,
follow the SSML format for the input text.}

\item{TextType}{Specifies whether the input text is plain text or SSML. The default
value is plain text.}

\item{VoiceId}{[required] Voice ID to use for the synthesis.}
}
\description{
Allows the creation of an asynchronous synthesis task, by starting a new \code{SpeechSynthesisTask}. This operation requires all the standard information needed for speech synthesis, plus the name of an Amazon S3 bucket for the service to store the output of the synthesis task and two optional parameters (\code{OutputS3KeyPrefix} and \code{SnsTopicArn}). Once the synthesis task is created, this operation will return a \code{SpeechSynthesisTask} object, which will include an identifier of this task as well as the current status. The \code{SpeechSynthesisTask} object is available for 72 hours after starting the asynchronous synthesis task.

See \url{https://www.paws-r-sdk.com/docs/polly_start_speech_synthesis_task/} for full documentation.
}
\keyword{internal}
