% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_terminate_instance_in_auto_scaling_group}
\alias{autoscaling_terminate_instance_in_auto_scaling_group}
\title{Terminates the specified instance and optionally adjusts the desired
group size}
\usage{
autoscaling_terminate_instance_in_auto_scaling_group(InstanceId,
  ShouldDecrementDesiredCapacity)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{ShouldDecrementDesiredCapacity}{[required] Indicates whether terminating the instance also decrements the size of
the Auto Scaling group.}
}
\description{
Terminates the specified instance and optionally adjusts the desired
group size.

This call simply makes a termination request. The instance is not
terminated immediately. When an instance is terminated, the instance
status changes to \code{terminated}. You can't connect to or start an
instance after you've terminated it.

If you do not specify the option to decrement the desired capacity,
Amazon EC2 Auto Scaling launches instances to replace the ones that are
terminated.

By default, Amazon EC2 Auto Scaling balances instances across all
Availability Zones. If you decrement the desired capacity, your Auto
Scaling group can become unbalanced between Availability Zones. Amazon
EC2 Auto Scaling tries to rebalance the group, and rebalancing might
terminate instances in other zones. For more information, see
\href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage}{Rebalancing activities}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$terminate_instance_in_auto_scaling_group(
  InstanceId = "string",
  ShouldDecrementDesiredCapacity = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example terminates the specified instance from the specified Auto
# Scaling group without updating the size of the group. Auto Scaling
# launches a replacement instance after the specified instance terminates.
svc$terminate_instance_in_auto_scaling_group(
  InstanceId = "i-93633f9b",
  ShouldDecrementDesiredCapacity = FALSE
)
}

}
\keyword{internal}
