% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_get_template_summary}
\alias{cloudformation_get_template_summary}
\title{Returns information about a new or existing template}
\usage{
cloudformation_get_template_summary(TemplateBody, TemplateURL,
  StackName, StackSetName)
}
\arguments{
\item{TemplateBody}{Structure containing the template body with a minimum length of 1 byte
and a maximum length of 51,200 bytes. For more information about
templates, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify only one of the following parameters:
\code{StackName}, \code{StackSetName}, \code{TemplateBody}, or \code{TemplateURL}.}

\item{TemplateURL}{Location of file containing the template body. The URL must point to a
template (max size: 460,800 bytes) that is located in an Amazon S3
bucket. For more information about templates, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the AWS CloudFormation User Guide.

Conditional: You must specify only one of the following parameters:
\code{StackName}, \code{StackSetName}, \code{TemplateBody}, or \code{TemplateURL}.}

\item{StackName}{The name or the stack ID that is associated with the stack, which are
not always interchangeable. For running stacks, you can specify either
the stack's name or its unique stack ID. For deleted stack, you must
specify the unique stack ID.

Conditional: You must specify only one of the following parameters:
\code{StackName}, \code{StackSetName}, \code{TemplateBody}, or \code{TemplateURL}.}

\item{StackSetName}{The name or unique ID of the stack set from which the stack was created.

Conditional: You must specify only one of the following parameters:
\code{StackName}, \code{StackSetName}, \code{TemplateBody}, or \code{TemplateURL}.}
}
\description{
Returns information about a new or existing template. The
\code{GetTemplateSummary} action is useful for viewing parameter information,
such as default parameter values and parameter types, before you create
or update a stack or stack set.

You can use the \code{GetTemplateSummary} action when you submit a template,
or you can get template information for a stack set, or a running or
deleted stack.

For deleted stacks, \code{GetTemplateSummary} returns the template
information for up to 90 days after the stack has been deleted. If the
template does not exist, a \code{ValidationError} is returned.
}
\section{Request syntax}{
\preformatted{svc$get_template_summary(
  TemplateBody = "string",
  TemplateURL = "string",
  StackName = "string",
  StackSetName = "string"
)
}
}

\keyword{internal}
