% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_list_rule_names_by_target}
\alias{cloudwatchevents_list_rule_names_by_target}
\title{Lists the rules for the specified target}
\usage{
cloudwatchevents_list_rule_names_by_target(TargetArn, EventBusName,
  NextToken, Limit)
}
\arguments{
\item{TargetArn}{[required] The Amazon Resource Name (ARN) of the target resource.}

\item{EventBusName}{The name or ARN of the event bus to list rules for. If you omit this,
the default event bus is used.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{The maximum number of results to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  RuleNames = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Lists the rules for the specified target. You can see which of the rules
in Amazon EventBridge can invoke a specific target in your account.
}
\section{Request syntax}{
\preformatted{svc$list_rule_names_by_target(
  TargetArn = "string",
  EventBusName = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
