% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_update_stack}
\alias{opsworks_update_stack}
\title{Updates a specified stack}
\usage{
opsworks_update_stack(StackId, Name, Attributes, ServiceRoleArn,
  DefaultInstanceProfileArn, DefaultOs, HostnameTheme,
  DefaultAvailabilityZone, DefaultSubnetId, CustomJson,
  ConfigurationManager, ChefConfiguration, UseCustomCookbooks,
  CustomCookbooksSource, DefaultSshKeyName, DefaultRootDeviceType,
  UseOpsworksSecurityGroups, AgentVersion)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{Name}{The stack's new name.}

\item{Attributes}{One or more user-defined key-value pairs to be added to the stack
attributes.}

\item{ServiceRoleArn}{Do not use this parameter. You cannot update a stack's service role.}

\item{DefaultInstanceProfileArn}{The ARN of an IAM profile that is the default profile for all of the
stack's EC2 instances. For more information about IAM ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{Using Identifiers}.}

\item{DefaultOs}{The stack's operating system, which must be set to one of the following:
\itemize{
\item A supported Linux operating system: An Amazon Linux version, such as
\verb{Amazon Linux 2018.03}, \verb{Amazon Linux 2017.09},
\verb{Amazon Linux 2017.03}, \verb{Amazon Linux 2016.09},
\verb{Amazon Linux 2016.03}, \verb{Amazon Linux 2015.09}, or
\verb{Amazon Linux 2015.03}.
\item A supported Ubuntu operating system, such as \verb{Ubuntu 16.04 LTS},
\verb{Ubuntu 14.04 LTS}, or \verb{Ubuntu 12.04 LTS}.
\item \verb{CentOS Linux 7}
\item \verb{Red Hat Enterprise Linux 7}
\item A supported Windows operating system, such as
\verb{Microsoft Windows Server 2012 R2 Base},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Express},
\verb{Microsoft Windows Server 2012 R2 with SQL Server Standard}, or
\verb{Microsoft Windows Server 2012 R2 with SQL Server Web}.
\item A custom AMI: \code{Custom}. You specify the custom AMI you want to use
when you create instances. For more information about how to use
custom AMIs with OpsWorks, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html}{Using Custom AMIs}.
}

The default option is the stack's current operating system. For more
information about supported operating systems, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html}{AWS OpsWorks Stacks Operating Systems}.}

\item{HostnameTheme}{The stack's new host name theme, with spaces replaced by underscores.
The theme is used to generate host names for the stack's instances. By
default, \code{HostnameTheme} is set to \code{Layer_Dependent}, which creates host
names by appending integers to the layer's short name. The other themes
are:
\itemize{
\item \code{Baked_Goods}
\item \code{Clouds}
\item \code{Europe_Cities}
\item \code{Fruits}
\item \code{Greek_Deities_and_Titans}
\item \code{Legendary_creatures_from_Japan}
\item \code{Planets_and_Moons}
\item \code{Roman_Deities}
\item \code{Scottish_Islands}
\item \code{US_Cities}
\item \code{Wild_Cats}
}

To obtain a generated host name, call \code{GetHostNameSuggestion}, which
returns a host name based on the current theme.}

\item{DefaultAvailabilityZone}{The stack's default Availability Zone, which must be in the stack's
region. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{Regions and Endpoints}. If
you also specify a value for \code{DefaultSubnetId}, the subnet must be in
the same zone. For more information, see
\code{\link[=opsworks_create_stack]{create_stack}}.}

\item{DefaultSubnetId}{The stack's default VPC subnet ID. This parameter is required if you
specify a value for the \code{VpcId} parameter. All instances are launched
into this subnet unless you specify otherwise when you create the
instance. If you also specify a value for \code{DefaultAvailabilityZone}, the
subnet must be in that zone. For information on default values and when
this parameter is required, see the \code{VpcId} parameter description.}

\item{CustomJson}{A string that contains user-defined, custom JSON. It can be used to
override the corresponding default stack configuration JSON values or to
pass data to recipes. The string should be in the following format:

\verb{"\{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...\}"}

For more information about custom JSON, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html}{Use Custom JSON to Modify the Stack Configuration Attributes}.}

\item{ConfigurationManager}{The configuration manager. When you update a stack, we recommend that
you use the configuration manager to specify the Chef version: 12,
11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default
value for Linux stacks is currently 12.}

\item{ChefConfiguration}{A \code{ChefConfiguration} object that specifies whether to enable Berkshelf
and the Berkshelf version on Chef 11.10 stacks. For more information,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html}{Create a New Stack}.}

\item{UseCustomCookbooks}{Whether the stack uses custom cookbooks.}

\item{CustomCookbooksSource}{Contains the information required to retrieve an app or cookbook from a
repository. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html}{Adding Apps}
or \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html}{Cookbooks and Recipes}.}

\item{DefaultSshKeyName}{A default Amazon EC2 key-pair name. The default value is \code{none}. If you
specify a key-pair name, AWS OpsWorks Stacks installs the public key on
the instance and you can use the private key with an SSH client to log
in to the instance. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html}{Using SSH to Communicate with an Instance}
and \href{https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html}{Managing SSH Access}.
You can override this setting by specifying a different key pair, or no
key pair, when you \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html}{create an instance}.}

\item{DefaultRootDeviceType}{The default root device type. This value is used by default for all
instances in the stack, but you can override it when you create an
instance. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device}{Storage for the Root Device}.}

\item{UseOpsworksSecurityGroups}{Whether to associate the AWS OpsWorks Stacks built-in security groups
with the stack's layers.

AWS OpsWorks Stacks provides a standard set of built-in security groups,
one for each layer, which are associated with layers by default.
\code{UseOpsworksSecurityGroups} allows you to provide your own custom
security groups instead of using the built-in groups.
\code{UseOpsworksSecurityGroups} has the following settings:
\itemize{
\item True - AWS OpsWorks Stacks automatically associates the appropriate
built-in security group with each layer (default setting). You can
associate additional security groups with a layer after you create
it, but you cannot delete the built-in security group.
\item False - AWS OpsWorks Stacks does not associate built-in security
groups with layers. You must create appropriate EC2 security groups
and associate a security group with each layer that you create.
However, you can still manually associate a built-in security group
with a layer on. Custom security groups are required only for those
layers that need custom settings.
}

For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html}{Create a New Stack}.}

\item{AgentVersion}{The default AWS OpsWorks Stacks agent version. You have the following
options:
\itemize{
\item Auto-update - Set this parameter to \code{LATEST}. AWS OpsWorks Stacks
automatically installs new agent versions on the stack's instances
as soon as they are available.
\item Fixed version - Set this parameter to your preferred agent version.
To update the agent version, you must edit the stack configuration
and specify a new version. AWS OpsWorks Stacks then automatically
installs that version on the stack's instances.
}

The default setting is \code{LATEST}. To specify an agent version, you must
use the complete version number, not the abbreviated number shown on the
console. For a list of available agent version numbers, call
\code{\link[=opsworks_describe_agent_versions]{describe_agent_versions}}.
AgentVersion cannot be set to Chef 12.2.

You can also specify an agent version when you create or update an
instance, which overrides the stack's default setting.}
}
\value{
An empty list.
}
\description{
Updates a specified stack.

\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$update_stack(
  StackId = "string",
  Name = "string",
  Attributes = list(
    "string"
  ),
  ServiceRoleArn = "string",
  DefaultInstanceProfileArn = "string",
  DefaultOs = "string",
  HostnameTheme = "string",
  DefaultAvailabilityZone = "string",
  DefaultSubnetId = "string",
  CustomJson = "string",
  ConfigurationManager = list(
    Name = "string",
    Version = "string"
  ),
  ChefConfiguration = list(
    ManageBerkshelf = TRUE|FALSE,
    BerkshelfVersion = "string"
  ),
  UseCustomCookbooks = TRUE|FALSE,
  CustomCookbooksSource = list(
    Type = "git"|"svn"|"archive"|"s3",
    Url = "string",
    Username = "string",
    Password = "string",
    SshKey = "string",
    Revision = "string"
  ),
  DefaultSshKeyName = "string",
  DefaultRootDeviceType = "ebs"|"instance-store",
  UseOpsworksSecurityGroups = TRUE|FALSE,
  AgentVersion = "string"
)
}
}

\keyword{internal}
