% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_constraints_for_portfolio}
\alias{servicecatalog_list_constraints_for_portfolio}
\title{Lists the constraints for the specified portfolio and product}
\usage{
servicecatalog_list_constraints_for_portfolio(AcceptLanguage,
  PortfolioId, ProductId, PageSize, PageToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier.}

\item{ProductId}{The product identifier.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}
}
\value{
A list with the following syntax:\preformatted{list(
  ConstraintDetails = list(
    list(
      ConstraintId = "string",
      Type = "string",
      Description = "string",
      Owner = "string",
      ProductId = "string",
      PortfolioId = "string"
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Lists the constraints for the specified portfolio and product.
}
\section{Request syntax}{
\preformatted{svc$list_constraints_for_portfolio(
  AcceptLanguage = "string",
  PortfolioId = "string",
  ProductId = "string",
  PageSize = 123,
  PageToken = "string"
)
}
}

\keyword{internal}
