% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_put_scheduled_update_group_action}
\alias{autoscaling_put_scheduled_update_group_action}
\title{Creates or updates a scheduled scaling action for an Auto Scaling group}
\usage{
autoscaling_put_scheduled_update_group_action(AutoScalingGroupName,
  ScheduledActionName, Time, StartTime, EndTime, Recurrence, MinSize,
  MaxSize, DesiredCapacity)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{ScheduledActionName}{[required] The name of this scaling action.}

\item{Time}{This parameter is deprecated.}

\item{StartTime}{The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ
format in UTC/GMT only and in quotes (for example,
\code{"2019-06-01T00:00:00Z"}).

If you specify \code{Recurrence} and \code{StartTime}, Amazon EC2 Auto Scaling
performs the action at this time, and then performs the action based on
the specified recurrence.

If you try to schedule your action in the past, Amazon EC2 Auto Scaling
returns an error message.}

\item{EndTime}{The date and time for the recurring schedule to end. Amazon EC2 Auto
Scaling does not perform the action after this time.}

\item{Recurrence}{The recurring schedule for this action, in Unix cron syntax format. This
format consists of five fields separated by white spaces: [Minute]
[Hour] [Day\_of\_Month] [Month\_of\_Year] [Day\_of\_Week]. The
value must be in quotes (for example, \code{"30 0 1 1,6,12 *"}). For more
information about this format, see \href{http://crontab.org}{Crontab}.

When \code{StartTime} and \code{EndTime} are specified with \code{Recurrence}, they
form the boundaries of when the recurring action starts and stops.}

\item{MinSize}{The minimum number of instances in the Auto Scaling group.}

\item{MaxSize}{The maximum number of instances in the Auto Scaling group.}

\item{DesiredCapacity}{The number of EC2 instances that should be running in the Auto Scaling
group.}
}
\description{
Creates or updates a scheduled scaling action for an Auto Scaling group.
If you leave a parameter unspecified when updating a scheduled scaling
action, the corresponding value remains unchanged.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html}{Scheduled Scaling}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_scheduled_update_group_action(
  AutoScalingGroupName = "string",
  ScheduledActionName = "string",
  Time = as.POSIXct(
    "2015-01-01"
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Recurrence = "string",
  MinSize = 123,
  MaxSize = 123,
  DesiredCapacity = 123
)
}
}

\examples{
# This example adds the specified scheduled action to the specified Auto
# Scaling group.
\donttest{svc$put_scheduled_update_group_action(
  AutoScalingGroupName = "my-auto-scaling-group",
  DesiredCapacity = 4L,
  EndTime = "2014-05-12T08:00:00Z",
  MaxSize = 6L,
  MinSize = 2L,
  ScheduledActionName = "my-scheduled-action",
  StartTime = "2014-05-12T08:00:00Z"
)}

}
\keyword{internal}
