% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_start_session}
\alias{ssm_start_session}
\title{Initiates a connection to a target (for example, an instance) for a
Session Manager session}
\usage{
ssm_start_session(Target, DocumentName, Parameters)
}
\arguments{
\item{Target}{[required] The instance to connect to for the session.}

\item{DocumentName}{The name of the SSM document to define the parameters and plugin
settings for the session. For example, \code{SSM-SessionManagerRunShell}. If
no document name is provided, a shell to the instance is launched by
default.}

\item{Parameters}{Reserved for future use.}
}
\description{
Initiates a connection to a target (for example, an instance) for a
Session Manager session. Returns a URL and token that can be used to
open a WebSocket connection for sending input and receiving outputs.
}
\details{
AWS CLI usage: \code{start-session} is an interactive command that requires
the Session Manager plugin to be installed on the client machine making
the call. For information, see \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html}{Install the Session Manager Plugin for the AWS CLI}
in the \emph{AWS Systems Manager User Guide}.
}
\section{Request syntax}{
\preformatted{svc$start_session(
  Target = "string",
  DocumentName = "string",
  Parameters = list(
    list(
      "string"
    )
  )
)
}
}

\keyword{internal}
