% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_events_for_organization}
\alias{health_describe_events_for_organization}
\title{Returns information about events across your organization in AWS
Organizations, meeting the specified filter criteria}
\usage{
health_describe_events_for_organization(filter, nextToken, maxResults,
  locale)
}
\arguments{
\item{filter}{Values to narrow the results returned.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns information about events across your organization in AWS
Organizations, meeting the specified filter criteria. Events are
returned in a summary form and do not include the accounts impacted,
detailed description, any additional metadata that depends on the event
type, or any affected resources. To retrieve that information, use the
DescribeAffectedAccountsForOrganization,
DescribeEventDetailsForOrganization, and
DescribeAffectedEntitiesForOrganization operations.
}
\details{
If no filter criteria are specified, all events across your organization
are returned. Results are sorted by \code{lastModifiedTime}, starting with
the most recent.

Before you can call this operation, you must first enable Health to work
with AWS Organizations. To do this, call the
EnableHealthServiceAccessForOrganization operation from your
organization\'s master account.
}
\section{Request syntax}{
\preformatted{svc$describe_events_for_organization(
  filter = list(
    eventTypeCodes = list(
      "string"
    ),
    awsAccountIds = list(
      "string"
    ),
    services = list(
      "string"
    ),
    regions = list(
      "string"
    ),
    startTime = list(
      from = as.POSIXct(
        "2015-01-01"
      ),
      to = as.POSIXct(
        "2015-01-01"
      )
    ),
    endTime = list(
      from = as.POSIXct(
        "2015-01-01"
      ),
      to = as.POSIXct(
        "2015-01-01"
      )
    ),
    lastUpdatedTime = list(
      from = as.POSIXct(
        "2015-01-01"
      ),
      to = as.POSIXct(
        "2015-01-01"
      )
    ),
    entityArns = list(
      "string"
    ),
    entityValues = list(
      "string"
    ),
    eventTypeCategories = list(
      "issue"|"accountNotification"|"scheduledChange"|"investigation"
    ),
    eventStatusCodes = list(
      "open"|"closed"|"upcoming"
    )
  ),
  nextToken = "string",
  maxResults = 123,
  locale = "string"
)
}
}

\keyword{internal}
