# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Health APIs and Notifications
#'
#' @description
#' AWS Health
#' 
#' The AWS Health API provides programmatic access to the AWS Health
#' information that is presented in the [AWS Personal Health
#' Dashboard](https://phd.aws.amazon.com/phd/home#/). You can get
#' information about events that affect your AWS resources:
#' 
#' -   DescribeEvents: Summary information about events.
#' 
#' -   DescribeEventDetails: Detailed information about one or more events.
#' 
#' -   DescribeAffectedEntities: Information about AWS resources that are
#'     affected by one or more events.
#' 
#' In addition, these operations provide information about event types and
#' summary counts of events or affected entities:
#' 
#' -   DescribeEventTypes: Information about the kinds of events that AWS
#'     Health tracks.
#' 
#' -   DescribeEventAggregates: A count of the number of events that meet
#'     specified criteria.
#' 
#' -   DescribeEntityAggregates: A count of the number of affected entities
#'     that meet specified criteria.
#' 
#' AWS Health integrates with AWS Organizations to provide a centralized
#' view of AWS Health events across all accounts in your organization.
#' 
#' -   DescribeEventsForOrganization: Summary information about events
#'     across the organization.
#' 
#' -   DescribeAffectedAccountsForOrganization: List of accounts in your
#'     organization impacted by an event.
#' 
#' -   DescribeEventDetailsForOrganization: Detailed information about
#'     events in your organization.
#' 
#' -   DescribeAffectedEntitiesForOrganization: Information about AWS
#'     resources in your organization that are affected by events.
#' 
#' You can use the following operations to enable or disable AWS Health
#' from working with AWS Organizations.
#' 
#' -   EnableHealthServiceAccessForOrganization: Enables AWS Health to work
#'     with AWS Organizations.
#' 
#' -   DisableHealthServiceAccessForOrganization: Disables AWS Health from
#'     working with AWS Organizations.
#' 
#' -   DescribeHealthServiceStatusForOrganization: Status information about
#'     enabling or disabling AWS Health from working with AWS
#'     Organizations.
#' 
#' The Health API requires a Business or Enterprise support plan from [AWS
#' Support](http://aws.amazon.com/premiumsupport/). Calling the Health API
#' from an account that does not have a Business or Enterprise support plan
#' causes a `SubscriptionRequiredException`.
#' 
#' For authentication of requests, AWS Health uses the [Signature Version 4
#' Signing
#' Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' See the [AWS Health User
#' Guide](https://docs.aws.amazon.com/health/latest/ug/what-is-aws-health.html)
#' for information about how to use the API.
#' 
#' **Service Endpoint**
#' 
#' The HTTP endpoint for the AWS Health API is:
#' 
#' -   https://health.us-east-1.amazonaws.com
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- health(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{svc <- health()
#' svc$describe_affected_accounts_for_organization(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=health_describe_affected_accounts_for_organization]{describe_affected_accounts_for_organization} \tab Returns a list of accounts in the organization from AWS Organizations that are affected by the provided event \cr
#'  \link[=health_describe_affected_entities]{describe_affected_entities} \tab Returns a list of entities that have been affected by the specified events, based on the specified filter criteria \cr
#'  \link[=health_describe_affected_entities_for_organization]{describe_affected_entities_for_organization} \tab Returns a list of entities that have been affected by one or more events for one or more accounts in your organization in AWS Organizations, based on the filter criteria\cr
#'  \link[=health_describe_entity_aggregates]{describe_entity_aggregates} \tab Returns the number of entities that are affected by each of the specified events \cr
#'  \link[=health_describe_event_aggregates]{describe_event_aggregates} \tab Returns the number of events of each event type (issue, scheduled change, and account notification) \cr
#'  \link[=health_describe_event_details]{describe_event_details} \tab Returns detailed information about one or more specified events \cr
#'  \link[=health_describe_event_details_for_organization]{describe_event_details_for_organization} \tab Returns detailed information about one or more specified events for one or more accounts in your organization \cr
#'  \link[=health_describe_events]{describe_events} \tab Returns information about events that meet the specified filter criteria \cr
#'  \link[=health_describe_events_for_organization]{describe_events_for_organization} \tab Returns information about events across your organization in AWS Organizations, meeting the specified filter criteria \cr
#'  \link[=health_describe_event_types]{describe_event_types} \tab Returns the event types that meet the specified filter criteria \cr
#'  \link[=health_describe_health_service_status_for_organization]{describe_health_service_status_for_organization} \tab This operation provides status information on enabling or disabling AWS Health to work with your organization \cr
#'  \link[=health_disable_health_service_access_for_organization]{disable_health_service_access_for_organization} \tab Calling this operation disables Health from working with AWS Organizations \cr
#'  \link[=health_enable_health_service_access_for_organization]{enable_health_service_access_for_organization} \tab Calling this operation enables AWS Health to work with AWS Organizations 
#' }
#'
#' @rdname health
#' @export
health <- function(config = list()) {
  svc <- .health$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.health <- list()

.health$operations <- list()

.health$metadata <- list(
  service_name = "health",
  endpoints = list("*" = list(endpoint = "health.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "health.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Health",
  api_version = "2016-08-04",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSHealth_20160804"
)

.health$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.health$metadata, handlers, config)
}
