% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_register_type}
\alias{cloudformation_register_type}
\title{Registers a type with the CloudFormation service}
\usage{
cloudformation_register_type(Type, TypeName, SchemaHandlerPackage,
  LoggingConfig, ExecutionRoleArn, ClientRequestToken)
}
\arguments{
\item{Type}{The kind of type.

Currently, the only valid value is \code{RESOURCE}.}

\item{TypeName}{[required] The name of the type being registered.

We recommend that type names adhere to the following pattern:
\emph{company\\_or\\_organization}::\emph{service}::\emph{type}.

The following organization namespaces are reserved and cannot be used in
your resource type names:
\itemize{
\item \code{Alexa}
\item \code{AMZN}
\item \code{Amazon}
\item \code{AWS}
\item \code{Custom}
\item \code{Dev}
}}

\item{SchemaHandlerPackage}{[required] A url to the S3 bucket containing the schema handler package that
contains the schema, event handlers, and associated files for the type
you want to register.

For information on generating a schema handler package for the type you
want to register, see
\href{https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-cli-submit.html}{submit}
in the \emph{CloudFormation CLI User Guide}.

As part of registering a resource provider type, CloudFormation must be
able to access the S3 bucket which contains the schema handler package
for that resource provider. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry.html#registry-register-permissions}{IAM Permissions for Registering a Resource Provider}
in the \emph{AWS CloudFormation User Guide}.}

\item{LoggingConfig}{Specifies logging configuration information for a type.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the IAM role for CloudFormation to
assume when invoking the resource provider. If your resource type calls
AWS APIs in any of its handlers, you must create an \emph{\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html}{IAM execution role}}
that includes the necessary permissions to call those AWS APIs, and
provision that execution role in your account. When CloudFormation needs
to invoke the resource provider handler, CloudFormation assumes this
execution role to create a temporary session token, which it then passes
to the resource provider handler, thereby supplying your resource
provider with the appropriate credentials.}

\item{ClientRequestToken}{A unique identifier that acts as an idempotency key for this
registration request. Specifying a client request token prevents
CloudFormation from generating more than one version of a type from the
same registeration request, even if the request is submitted multiple
times.}
}
\description{
Registers a type with the CloudFormation service. Registering a type
makes it available for use in CloudFormation templates in your AWS
account, and includes:
}
\details{
\itemize{
\item Validating the resource schema
\item Determining which handlers have been specified for the resource
\item Making the resource type available for use in your account
}

For more information on how to develop types and ready them for
registeration, see \href{https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html}{Creating Resource Providers}
in the \emph{CloudFormation CLI User Guide}.

You can have a maximum of 50 resource type versions registered at a
time. This maximum is per account and per region. Use
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DeregisterType.html}{DeregisterType}
to deregister specific resource type versions if necessary.

Once you have initiated a registration request using
\verb{<a>RegisterType</a>}, you can use \verb{<a>DescribeTypeRegistration</a>}
to monitor the progress of the registration request.
}
\section{Request syntax}{
\preformatted{svc$register_type(
  Type = "RESOURCE",
  TypeName = "string",
  SchemaHandlerPackage = "string",
  LoggingConfig = list(
    LogRoleArn = "string",
    LogGroupName = "string"
  ),
  ExecutionRoleArn = "string",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
