% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_document}
\alias{ssm_update_document}
\title{Updates one or more values for an SSM document}
\usage{
ssm_update_document(
  Content,
  Attachments = NULL,
  Name,
  DisplayName = NULL,
  VersionName = NULL,
  DocumentVersion = NULL,
  DocumentFormat = NULL,
  TargetType = NULL
)
}
\arguments{
\item{Content}{[required] A valid JSON or YAML string.}

\item{Attachments}{A list of key-value pairs that describe attachments to a version of a
document.}

\item{Name}{[required] The name of the SSM document that you want to update.}

\item{DisplayName}{The friendly name of the SSM document that you want to update. This
value can differ for each version of the document. If you don't specify
a value for this parameter in your request, the existing value is
applied to the new document version.}

\item{VersionName}{An optional field specifying the version of the artifact you are
updating with the document. For example, "Release 12, Update 6". This
value is unique across all versions of a document, and can't be changed.}

\item{DocumentVersion}{The version of the document that you want to update. Currently, Systems
Manager supports updating only the latest version of the document. You
can specify the version number of the latest version or use the
\verb{$LATEST} variable.

If you change a document version for a State Manager association,
Systems Manager immediately runs the association unless you previously
specifed the \code{apply-only-at-cron-interval} parameter.}

\item{DocumentFormat}{Specify the document format for the new document version. Systems
Manager supports JSON and YAML documents. JSON is the default format.}

\item{TargetType}{Specify a new target type for the document.}
}
\description{
Updates one or more values for an SSM document.

See \url{https://www.paws-r-sdk.com/docs/ssm_update_document/} for full documentation.
}
\keyword{internal}
