% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_update_launch}
\alias{cloudwatchevidently_update_launch}
\title{Updates a launch of a given feature}
\usage{
cloudwatchevidently_update_launch(
  description = NULL,
  groups = NULL,
  launch,
  metricMonitors = NULL,
  project,
  randomizationSalt = NULL,
  scheduledSplitsConfig = NULL
)
}
\arguments{
\item{description}{An optional description for the launch.}

\item{groups}{An array of structures that contains the feature and variations that are
to be used for the launch.}

\item{launch}{[required] The name of the launch that is to be updated.}

\item{metricMonitors}{An array of structures that define the metrics that will be used to
monitor the launch performance.}

\item{project}{[required] The name or ARN of the project that contains the launch that you want to
update.}

\item{randomizationSalt}{When Evidently assigns a particular user session to a launch, it must
use a randomization ID to determine which variation the user session is
served. This randomization ID is a combination of the entity ID and
\code{randomizationSalt}. If you omit \code{randomizationSalt}, Evidently uses the
launch name as the \code{randomizationSalt}.}

\item{scheduledSplitsConfig}{An array of structures that define the traffic allocation percentages
among the feature variations during each step of the launch.}
}
\description{
Updates a launch of a given feature.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevidently_update_launch/} for full documentation.
}
\keyword{internal}
