% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_update_managed_instance_role}
\alias{ssm_update_managed_instance_role}
\title{Changes the Identity and Access Management (IAM) role that is assigned
to the on-premises server, edge device, or virtual machines (VM)}
\usage{
ssm_update_managed_instance_role(InstanceId, IamRole)
}
\arguments{
\item{InstanceId}{[required] The ID of the managed node where you want to update the role.}

\item{IamRole}{[required] The name of the Identity and Access Management (IAM) role that you want
to assign to the managed node. This IAM role must provide AssumeRole
permissions for the Amazon Web Services Systems Manager service
principal \code{ssm.amazonaws.com}. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/hybrid-multicloud-service-role.html}{Create an IAM service role for a hybrid and multicloud environment}
in the \emph{Amazon Web Services Systems Manager User Guide}.

You can't specify an IAM service-linked role for this parameter. You
must create a unique role.}
}
\description{
Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more information, see \code{\link[=ssm_create_activation]{create_activation}}.

See \url{https://www.paws-r-sdk.com/docs/ssm_update_managed_instance_role/} for full documentation.
}
\keyword{internal}
