% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managedgrafana_operations.R
\name{managedgrafana_create_workspace_service_account}
\alias{managedgrafana_create_workspace_service_account}
\title{Creates a service account for the workspace}
\usage{
managedgrafana_create_workspace_service_account(grafanaRole, name, workspaceId)
}
\arguments{
\item{grafanaRole}{[required] The permission level to use for this service account.

For more information about the roles and the permissions each has, see
\href{https://docs.aws.amazon.com/grafana/latest/userguide/Grafana-user-roles.html}{User roles}
in the \emph{Amazon Managed Grafana User Guide}.}

\item{name}{[required] A name for the service account. The name must be unique within the
workspace, as it determines the ID associated with the service account.}

\item{workspaceId}{[required] The ID of the workspace within which to create the service account.}
}
\description{
Creates a service account for the workspace. A service account can be used to call Grafana HTTP APIs, and run automated workloads. After creating the service account with the correct \code{GrafanaRole} for your use case, use \code{\link[=managedgrafana_create_workspace_service_account_token]{create_workspace_service_account_token}} to create a token that can be used to authenticate and authorize Grafana HTTP API calls.

See \url{https://www.paws-r-sdk.com/docs/managedgrafana_create_workspace_service_account/} for full documentation.
}
\keyword{internal}
