% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_update_route}
\alias{apigatewayv2_update_route}
\title{Updates a Route}
\usage{
apigatewayv2_update_route(ApiId, ApiKeyRequired, AuthorizationScopes,
  AuthorizationType, AuthorizerId, ModelSelectionExpression,
  OperationName, RequestModels, RequestParameters, RouteId, RouteKey,
  RouteResponseSelectionExpression, Target)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{ApiKeyRequired}{Specifies whether an API key is required for the route.}

\item{AuthorizationScopes}{The authorization scopes supported by this route.}

\item{AuthorizationType}{The authorization type for the route. Valid values are NONE for open
access, AWS\_IAM for using AWS IAM permissions, and CUSTOM for using a
Lambda authorizer.}

\item{AuthorizerId}{The identifier of the Authorizer resource to be associated with this
route, if the authorizationType is CUSTOM . The authorizer identifier is
generated by API Gateway when you created the authorizer.}

\item{ModelSelectionExpression}{The model selection expression for the route.}

\item{OperationName}{The operation name for the route.}

\item{RequestModels}{The request models for the route.}

\item{RequestParameters}{The request parameters for the route.}

\item{RouteId}{[required] The route ID.}

\item{RouteKey}{The route key for the route.}

\item{RouteResponseSelectionExpression}{The route response selection expression for the route.}

\item{Target}{The target for the route.}
}
\description{
Updates a Route.
}
\section{Request syntax}{
\preformatted{svc$update_route(
  ApiId = "string",
  ApiKeyRequired = TRUE|FALSE,
  AuthorizationScopes = list(
    "string"
  ),
  AuthorizationType = "NONE"|"AWS_IAM"|"CUSTOM",
  AuthorizerId = "string",
  ModelSelectionExpression = "string",
  OperationName = "string",
  RequestModels = list(
    "string"
  ),
  RequestParameters = list(
    list(
      Required = TRUE|FALSE
    )
  ),
  RouteId = "string",
  RouteKey = "string",
  RouteResponseSelectionExpression = "string",
  Target = "string"
)
}
}

\keyword{internal}
