% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_deregister_instances_from_load_balancer}
\alias{elb_deregister_instances_from_load_balancer}
\title{Deregisters the specified instances from the specified load balancer}
\usage{
elb_deregister_instances_from_load_balancer(LoadBalancerName, Instances)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{Instances}{[required] The IDs of the instances.}
}
\description{
Deregisters the specified instances from the specified load balancer.
After the instance is deregistered, it no longer receives traffic from
the load balancer.
}
\details{
You can use DescribeLoadBalancers to verify that the instance is
deregistered from the load balancer.

For more information, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html}{Register or De-Register EC2 Instances}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$deregister_instances_from_load_balancer(
  LoadBalancerName = "string",
  Instances = list(
    list(
      InstanceId = "string"
    )
  )
)
}
}

\examples{
# This example deregisters the specified instance from the specified load
# balancer.
\donttest{svc$deregister_instances_from_load_balancer(
  Instances = list(
    list(
      InstanceId = "i-d6f6fae3"
    )
  ),
  LoadBalancerName = "my-load-balancer"
)}

}
\keyword{internal}
