# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS App Mesh
#'
#' @description
#' App Mesh is a service mesh based on the Envoy proxy that makes it easy
#' to monitor and control microservices. App Mesh standardizes how your
#' microservices communicate, giving you end-to-end visibility and helping
#' to ensure high availability for your applications.
#' 
#' App Mesh gives you consistent visibility and network traffic controls
#' for every microservice in an application. You can use App Mesh with
#' Amazon Web Services Fargate, Amazon ECS, Amazon EKS, Kubernetes on
#' Amazon Web Services, and Amazon EC2.
#' 
#' App Mesh supports microservice applications that use service discovery
#' naming for their components. For more information about service
#' discovery on Amazon ECS, see [Service
#' Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html)
#' in the *Amazon Elastic Container Service Developer Guide*. Kubernetes
#' `kube-dns` and `coredns` are supported. For more information, see [DNS
#' for Services and
#' Pods](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/)
#' in the Kubernetes documentation.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- appmesh(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- appmesh()
#' svc$create_gateway_route(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=appmesh_create_gateway_route]{create_gateway_route} \tab Creates a gateway route\cr
#'  \link[=appmesh_create_mesh]{create_mesh} \tab Creates a service mesh\cr
#'  \link[=appmesh_create_route]{create_route} \tab Creates a route that is associated with a virtual router\cr
#'  \link[=appmesh_create_virtual_gateway]{create_virtual_gateway} \tab Creates a virtual gateway\cr
#'  \link[=appmesh_create_virtual_node]{create_virtual_node} \tab Creates a virtual node within a service mesh\cr
#'  \link[=appmesh_create_virtual_router]{create_virtual_router} \tab Creates a virtual router within a service mesh\cr
#'  \link[=appmesh_create_virtual_service]{create_virtual_service} \tab Creates a virtual service within a service mesh\cr
#'  \link[=appmesh_delete_gateway_route]{delete_gateway_route} \tab Deletes an existing gateway route\cr
#'  \link[=appmesh_delete_mesh]{delete_mesh} \tab Deletes an existing service mesh\cr
#'  \link[=appmesh_delete_route]{delete_route} \tab Deletes an existing route\cr
#'  \link[=appmesh_delete_virtual_gateway]{delete_virtual_gateway} \tab Deletes an existing virtual gateway\cr
#'  \link[=appmesh_delete_virtual_node]{delete_virtual_node} \tab Deletes an existing virtual node\cr
#'  \link[=appmesh_delete_virtual_router]{delete_virtual_router} \tab Deletes an existing virtual router\cr
#'  \link[=appmesh_delete_virtual_service]{delete_virtual_service} \tab Deletes an existing virtual service\cr
#'  \link[=appmesh_describe_gateway_route]{describe_gateway_route} \tab Describes an existing gateway route\cr
#'  \link[=appmesh_describe_mesh]{describe_mesh} \tab Describes an existing service mesh\cr
#'  \link[=appmesh_describe_route]{describe_route} \tab Describes an existing route\cr
#'  \link[=appmesh_describe_virtual_gateway]{describe_virtual_gateway} \tab Describes an existing virtual gateway\cr
#'  \link[=appmesh_describe_virtual_node]{describe_virtual_node} \tab Describes an existing virtual node\cr
#'  \link[=appmesh_describe_virtual_router]{describe_virtual_router} \tab Describes an existing virtual router\cr
#'  \link[=appmesh_describe_virtual_service]{describe_virtual_service} \tab Describes an existing virtual service\cr
#'  \link[=appmesh_list_gateway_routes]{list_gateway_routes} \tab Returns a list of existing gateway routes that are associated to a virtual gateway\cr
#'  \link[=appmesh_list_meshes]{list_meshes} \tab Returns a list of existing service meshes\cr
#'  \link[=appmesh_list_routes]{list_routes} \tab Returns a list of existing routes in a service mesh\cr
#'  \link[=appmesh_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an App Mesh resource\cr
#'  \link[=appmesh_list_virtual_gateways]{list_virtual_gateways} \tab Returns a list of existing virtual gateways in a service mesh\cr
#'  \link[=appmesh_list_virtual_nodes]{list_virtual_nodes} \tab Returns a list of existing virtual nodes\cr
#'  \link[=appmesh_list_virtual_routers]{list_virtual_routers} \tab Returns a list of existing virtual routers in a service mesh\cr
#'  \link[=appmesh_list_virtual_services]{list_virtual_services} \tab Returns a list of existing virtual services in a service mesh\cr
#'  \link[=appmesh_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
#'  \link[=appmesh_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
#'  \link[=appmesh_update_gateway_route]{update_gateway_route} \tab Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh\cr
#'  \link[=appmesh_update_mesh]{update_mesh} \tab Updates an existing service mesh\cr
#'  \link[=appmesh_update_route]{update_route} \tab Updates an existing route for a specified service mesh and virtual router\cr
#'  \link[=appmesh_update_virtual_gateway]{update_virtual_gateway} \tab Updates an existing virtual gateway in a specified service mesh\cr
#'  \link[=appmesh_update_virtual_node]{update_virtual_node} \tab Updates an existing virtual node in a specified service mesh\cr
#'  \link[=appmesh_update_virtual_router]{update_virtual_router} \tab Updates an existing virtual router in a specified service mesh\cr
#'  \link[=appmesh_update_virtual_service]{update_virtual_service} \tab Updates an existing virtual service in a specified service mesh
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname appmesh
#' @export
appmesh <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .appmesh$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.appmesh <- list()

.appmesh$operations <- list()

.appmesh$metadata <- list(
  service_name = "appmesh",
  endpoints = list("*" = list(endpoint = "appmesh.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "appmesh.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "appmesh.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "appmesh.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "App Mesh",
  api_version = "2019-01-25",
  signing_name = "appmesh",
  json_version = "1.1",
  target_prefix = ""
)

.appmesh$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.appmesh$metadata, handlers, config)
}
