# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudfront_service.R
NULL

#' Associates an alias (also known as a CNAME or an alternate domain name)
#' with a CloudFront distribution
#'
#' @description
#' Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_associate_alias/](https://www.paws-r-sdk.com/docs/cloudfront_associate_alias/) for full documentation.
#'
#' @param TargetDistributionId &#91;required&#93; The ID of the distribution that you're associating the alias with.
#' @param Alias &#91;required&#93; The alias (also known as a CNAME) to add to the target distribution.
#'
#' @keywords internal
#'
#' @rdname cloudfront_associate_alias
cloudfront_associate_alias <- function(TargetDistributionId, Alias) {
  op <- new_operation(
    name = "AssociateAlias",
    http_method = "PUT",
    http_path = "/2020-05-31/distribution/{TargetDistributionId}/associate-alias",
    paginator = list()
  )
  input <- .cloudfront$associate_alias_input(TargetDistributionId = TargetDistributionId, Alias = Alias)
  output <- .cloudfront$associate_alias_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$associate_alias <- cloudfront_associate_alias

#' Creates a staging distribution using the configuration of the provided
#' primary distribution
#'
#' @description
#' Creates a staging distribution using the configuration of the provided primary distribution. A staging distribution is a copy of an existing distribution (called the primary distribution) that you can use in a continuous deployment workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_copy_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_copy_distribution/) for full documentation.
#'
#' @param PrimaryDistributionId &#91;required&#93; The identifier of the primary distribution whose configuration you are
#' copying. To get a distribution ID, use
#' [`list_distributions`][cloudfront_list_distributions].
#' @param Staging The type of distribution that your primary distribution will be copied
#' to. The only valid value is `True`, indicating that you are copying to a
#' staging distribution.
#' @param IfMatch The version identifier of the primary distribution whose configuration
#' you are copying. This is the `ETag` value returned in the response to
#' [`get_distribution`][cloudfront_get_distribution] and
#' [`get_distribution_config`][cloudfront_get_distribution_config].
#' @param CallerReference &#91;required&#93; A value that uniquely identifies a request to create a resource. This
#' helps to prevent CloudFront from creating a duplicate resource if you
#' accidentally resubmit an identical request.
#' @param Enabled A Boolean flag to specify the state of the staging distribution when
#' it's created. When you set this value to `True`, the staging
#' distribution is enabled. When you set this value to `False`, the staging
#' distribution is disabled.
#' 
#' If you omit this field, the default value is `True`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_copy_distribution
cloudfront_copy_distribution <- function(PrimaryDistributionId, Staging = NULL, IfMatch = NULL, CallerReference, Enabled = NULL) {
  op <- new_operation(
    name = "CopyDistribution",
    http_method = "POST",
    http_path = "/2020-05-31/distribution/{PrimaryDistributionId}/copy",
    paginator = list()
  )
  input <- .cloudfront$copy_distribution_input(PrimaryDistributionId = PrimaryDistributionId, Staging = Staging, IfMatch = IfMatch, CallerReference = CallerReference, Enabled = Enabled)
  output <- .cloudfront$copy_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$copy_distribution <- cloudfront_copy_distribution

#' Creates a cache policy
#'
#' @description
#' Creates a cache policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_cache_policy/](https://www.paws-r-sdk.com/docs/cloudfront_create_cache_policy/) for full documentation.
#'
#' @param CachePolicyConfig &#91;required&#93; A cache policy configuration.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_cache_policy
cloudfront_create_cache_policy <- function(CachePolicyConfig) {
  op <- new_operation(
    name = "CreateCachePolicy",
    http_method = "POST",
    http_path = "/2020-05-31/cache-policy",
    paginator = list()
  )
  input <- .cloudfront$create_cache_policy_input(CachePolicyConfig = CachePolicyConfig)
  output <- .cloudfront$create_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_cache_policy <- cloudfront_create_cache_policy

#' Creates a new origin access identity
#'
#' @description
#' Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more information about how to use origin access identities, see [Serving Private Content through CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html) in the *Amazon CloudFront Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_cloud_front_origin_access_identity/](https://www.paws-r-sdk.com/docs/cloudfront_create_cloud_front_origin_access_identity/) for full documentation.
#'
#' @param CloudFrontOriginAccessIdentityConfig &#91;required&#93; The current configuration information for the identity.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_cloud_front_origin_access_identity
cloudfront_create_cloud_front_origin_access_identity <- function(CloudFrontOriginAccessIdentityConfig) {
  op <- new_operation(
    name = "CreateCloudFrontOriginAccessIdentity",
    http_method = "POST",
    http_path = "/2020-05-31/origin-access-identity/cloudfront",
    paginator = list()
  )
  input <- .cloudfront$create_cloud_front_origin_access_identity_input(CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig)
  output <- .cloudfront$create_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_cloud_front_origin_access_identity <- cloudfront_create_cloud_front_origin_access_identity

#' Creates a continuous deployment policy that distributes traffic for a
#' custom domain name to two different CloudFront distributions
#'
#' @description
#' Creates a continuous deployment policy that distributes traffic for a custom domain name to two different CloudFront distributions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_continuous_deployment_policy/](https://www.paws-r-sdk.com/docs/cloudfront_create_continuous_deployment_policy/) for full documentation.
#'
#' @param ContinuousDeploymentPolicyConfig &#91;required&#93; Contains the configuration for a continuous deployment policy.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_continuous_deployment_policy
cloudfront_create_continuous_deployment_policy <- function(ContinuousDeploymentPolicyConfig) {
  op <- new_operation(
    name = "CreateContinuousDeploymentPolicy",
    http_method = "POST",
    http_path = "/2020-05-31/continuous-deployment-policy",
    paginator = list()
  )
  input <- .cloudfront$create_continuous_deployment_policy_input(ContinuousDeploymentPolicyConfig = ContinuousDeploymentPolicyConfig)
  output <- .cloudfront$create_continuous_deployment_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_continuous_deployment_policy <- cloudfront_create_continuous_deployment_policy

#' Creates a CloudFront distribution
#'
#' @description
#' Creates a CloudFront distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_create_distribution/) for full documentation.
#'
#' @param DistributionConfig &#91;required&#93; The distribution's configuration information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_distribution
cloudfront_create_distribution <- function(DistributionConfig) {
  op <- new_operation(
    name = "CreateDistribution",
    http_method = "POST",
    http_path = "/2020-05-31/distribution",
    paginator = list()
  )
  input <- .cloudfront$create_distribution_input(DistributionConfig = DistributionConfig)
  output <- .cloudfront$create_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_distribution <- cloudfront_create_distribution

#' Create a new distribution with tags
#'
#' @description
#' Create a new distribution with tags. This API operation requires the following IAM permissions:
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_distribution_with_tags/](https://www.paws-r-sdk.com/docs/cloudfront_create_distribution_with_tags/) for full documentation.
#'
#' @param DistributionConfigWithTags &#91;required&#93; The distribution's configuration information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_distribution_with_tags
cloudfront_create_distribution_with_tags <- function(DistributionConfigWithTags) {
  op <- new_operation(
    name = "CreateDistributionWithTags",
    http_method = "POST",
    http_path = "/2020-05-31/distribution?WithTags",
    paginator = list()
  )
  input <- .cloudfront$create_distribution_with_tags_input(DistributionConfigWithTags = DistributionConfigWithTags)
  output <- .cloudfront$create_distribution_with_tags_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_distribution_with_tags <- cloudfront_create_distribution_with_tags

#' Create a new field-level encryption configuration
#'
#' @description
#' Create a new field-level encryption configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_field_level_encryption_config/](https://www.paws-r-sdk.com/docs/cloudfront_create_field_level_encryption_config/) for full documentation.
#'
#' @param FieldLevelEncryptionConfig &#91;required&#93; The request to create a new field-level encryption configuration.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_field_level_encryption_config
cloudfront_create_field_level_encryption_config <- function(FieldLevelEncryptionConfig) {
  op <- new_operation(
    name = "CreateFieldLevelEncryptionConfig",
    http_method = "POST",
    http_path = "/2020-05-31/field-level-encryption",
    paginator = list()
  )
  input <- .cloudfront$create_field_level_encryption_config_input(FieldLevelEncryptionConfig = FieldLevelEncryptionConfig)
  output <- .cloudfront$create_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_field_level_encryption_config <- cloudfront_create_field_level_encryption_config

#' Create a field-level encryption profile
#'
#' @description
#' Create a field-level encryption profile.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_field_level_encryption_profile/](https://www.paws-r-sdk.com/docs/cloudfront_create_field_level_encryption_profile/) for full documentation.
#'
#' @param FieldLevelEncryptionProfileConfig &#91;required&#93; The request to create a field-level encryption profile.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_field_level_encryption_profile
cloudfront_create_field_level_encryption_profile <- function(FieldLevelEncryptionProfileConfig) {
  op <- new_operation(
    name = "CreateFieldLevelEncryptionProfile",
    http_method = "POST",
    http_path = "/2020-05-31/field-level-encryption-profile",
    paginator = list()
  )
  input <- .cloudfront$create_field_level_encryption_profile_input(FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig)
  output <- .cloudfront$create_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_field_level_encryption_profile <- cloudfront_create_field_level_encryption_profile

#' Creates a CloudFront function
#'
#' @description
#' Creates a CloudFront function.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_function/](https://www.paws-r-sdk.com/docs/cloudfront_create_function/) for full documentation.
#'
#' @param Name &#91;required&#93; A name to identify the function.
#' @param FunctionConfig &#91;required&#93; Configuration information about the function, including an optional
#' comment and the function's runtime.
#' @param FunctionCode &#91;required&#93; The function code. For more information about writing a CloudFront
#' function, see [Writing function code for CloudFront
#' Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_function
cloudfront_create_function <- function(Name, FunctionConfig, FunctionCode) {
  op <- new_operation(
    name = "CreateFunction",
    http_method = "POST",
    http_path = "/2020-05-31/function",
    paginator = list()
  )
  input <- .cloudfront$create_function_input(Name = Name, FunctionConfig = FunctionConfig, FunctionCode = FunctionCode)
  output <- .cloudfront$create_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_function <- cloudfront_create_function

#' Create a new invalidation
#'
#' @description
#' Create a new invalidation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_invalidation/](https://www.paws-r-sdk.com/docs/cloudfront_create_invalidation/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The distribution's id.
#' @param InvalidationBatch &#91;required&#93; The batch information for the invalidation.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_invalidation
cloudfront_create_invalidation <- function(DistributionId, InvalidationBatch) {
  op <- new_operation(
    name = "CreateInvalidation",
    http_method = "POST",
    http_path = "/2020-05-31/distribution/{DistributionId}/invalidation",
    paginator = list()
  )
  input <- .cloudfront$create_invalidation_input(DistributionId = DistributionId, InvalidationBatch = InvalidationBatch)
  output <- .cloudfront$create_invalidation_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_invalidation <- cloudfront_create_invalidation

#' Creates a key group that you can use with CloudFront signed URLs and
#' signed cookies
#'
#' @description
#' Creates a key group that you can use with [CloudFront signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_key_group/](https://www.paws-r-sdk.com/docs/cloudfront_create_key_group/) for full documentation.
#'
#' @param KeyGroupConfig &#91;required&#93; A key group configuration.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_key_group
cloudfront_create_key_group <- function(KeyGroupConfig) {
  op <- new_operation(
    name = "CreateKeyGroup",
    http_method = "POST",
    http_path = "/2020-05-31/key-group",
    paginator = list()
  )
  input <- .cloudfront$create_key_group_input(KeyGroupConfig = KeyGroupConfig)
  output <- .cloudfront$create_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_key_group <- cloudfront_create_key_group

#' Specifies the Key Value Store resource to add to your account
#'
#' @description
#' Specifies the Key Value Store resource to add to your account. In your account, the Key Value Store names must be unique. You can also import Key Value Store data in JSON format from an S3 bucket by providing a valid `ImportSource` that you own.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_key_value_store/](https://www.paws-r-sdk.com/docs/cloudfront_create_key_value_store/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Key Value Store. The maximum length of the name is 32
#' characters.
#' @param Comment The comment of the Key Value Store.
#' @param ImportSource The S3 bucket that provides the source for the import. The source must
#' be in a valid JSON format.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_key_value_store
cloudfront_create_key_value_store <- function(Name, Comment = NULL, ImportSource = NULL) {
  op <- new_operation(
    name = "CreateKeyValueStore",
    http_method = "POST",
    http_path = "/2020-05-31/key-value-store/",
    paginator = list()
  )
  input <- .cloudfront$create_key_value_store_input(Name = Name, Comment = Comment, ImportSource = ImportSource)
  output <- .cloudfront$create_key_value_store_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_key_value_store <- cloudfront_create_key_value_store

#' Enables additional CloudWatch metrics for the specified CloudFront
#' distribution
#'
#' @description
#' Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an additional cost.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_monitoring_subscription/](https://www.paws-r-sdk.com/docs/cloudfront_create_monitoring_subscription/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The ID of the distribution that you are enabling metrics for.
#' @param MonitoringSubscription &#91;required&#93; A monitoring subscription. This structure contains information about
#' whether additional CloudWatch metrics are enabled for a given CloudFront
#' distribution.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_monitoring_subscription
cloudfront_create_monitoring_subscription <- function(DistributionId, MonitoringSubscription) {
  op <- new_operation(
    name = "CreateMonitoringSubscription",
    http_method = "POST",
    http_path = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription/",
    paginator = list()
  )
  input <- .cloudfront$create_monitoring_subscription_input(DistributionId = DistributionId, MonitoringSubscription = MonitoringSubscription)
  output <- .cloudfront$create_monitoring_subscription_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_monitoring_subscription <- cloudfront_create_monitoring_subscription

#' Creates a new origin access control in CloudFront
#'
#' @description
#' Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_origin_access_control/](https://www.paws-r-sdk.com/docs/cloudfront_create_origin_access_control/) for full documentation.
#'
#' @param OriginAccessControlConfig &#91;required&#93; Contains the origin access control.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_origin_access_control
cloudfront_create_origin_access_control <- function(OriginAccessControlConfig) {
  op <- new_operation(
    name = "CreateOriginAccessControl",
    http_method = "POST",
    http_path = "/2020-05-31/origin-access-control",
    paginator = list()
  )
  input <- .cloudfront$create_origin_access_control_input(OriginAccessControlConfig = OriginAccessControlConfig)
  output <- .cloudfront$create_origin_access_control_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_origin_access_control <- cloudfront_create_origin_access_control

#' Creates an origin request policy
#'
#' @description
#' Creates an origin request policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_origin_request_policy/](https://www.paws-r-sdk.com/docs/cloudfront_create_origin_request_policy/) for full documentation.
#'
#' @param OriginRequestPolicyConfig &#91;required&#93; An origin request policy configuration.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_origin_request_policy
cloudfront_create_origin_request_policy <- function(OriginRequestPolicyConfig) {
  op <- new_operation(
    name = "CreateOriginRequestPolicy",
    http_method = "POST",
    http_path = "/2020-05-31/origin-request-policy",
    paginator = list()
  )
  input <- .cloudfront$create_origin_request_policy_input(OriginRequestPolicyConfig = OriginRequestPolicyConfig)
  output <- .cloudfront$create_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_origin_request_policy <- cloudfront_create_origin_request_policy

#' Uploads a public key to CloudFront that you can use with signed URLs and
#' signed cookies, or with field-level encryption
#'
#' @description
#' Uploads a public key to CloudFront that you can use with [signed URLs and signed cookies](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html), or with [field-level encryption](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_public_key/](https://www.paws-r-sdk.com/docs/cloudfront_create_public_key/) for full documentation.
#'
#' @param PublicKeyConfig &#91;required&#93; A CloudFront public key configuration.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_public_key
cloudfront_create_public_key <- function(PublicKeyConfig) {
  op <- new_operation(
    name = "CreatePublicKey",
    http_method = "POST",
    http_path = "/2020-05-31/public-key",
    paginator = list()
  )
  input <- .cloudfront$create_public_key_input(PublicKeyConfig = PublicKeyConfig)
  output <- .cloudfront$create_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_public_key <- cloudfront_create_public_key

#' Creates a real-time log configuration
#'
#' @description
#' Creates a real-time log configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_realtime_log_config/](https://www.paws-r-sdk.com/docs/cloudfront_create_realtime_log_config/) for full documentation.
#'
#' @param EndPoints &#91;required&#93; Contains information about the Amazon Kinesis data stream where you are
#' sending real-time log data.
#' @param Fields &#91;required&#93; A list of fields to include in each real-time log record.
#' 
#' For more information about fields, see [Real-time log configuration
#' fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
#' in the *Amazon CloudFront Developer Guide*.
#' @param Name &#91;required&#93; A unique name to identify this real-time log configuration.
#' @param SamplingRate &#91;required&#93; The sampling rate for this real-time log configuration. The sampling
#' rate determines the percentage of viewer requests that are represented
#' in the real-time log data. You must provide an integer between 1 and
#' 100, inclusive.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_realtime_log_config
cloudfront_create_realtime_log_config <- function(EndPoints, Fields, Name, SamplingRate) {
  op <- new_operation(
    name = "CreateRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/realtime-log-config",
    paginator = list()
  )
  input <- .cloudfront$create_realtime_log_config_input(EndPoints = EndPoints, Fields = Fields, Name = Name, SamplingRate = SamplingRate)
  output <- .cloudfront$create_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_realtime_log_config <- cloudfront_create_realtime_log_config

#' Creates a response headers policy
#'
#' @description
#' Creates a response headers policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_response_headers_policy/](https://www.paws-r-sdk.com/docs/cloudfront_create_response_headers_policy/) for full documentation.
#'
#' @param ResponseHeadersPolicyConfig &#91;required&#93; Contains metadata about the response headers policy, and a set of
#' configurations that specify the HTTP headers.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_response_headers_policy
cloudfront_create_response_headers_policy <- function(ResponseHeadersPolicyConfig) {
  op <- new_operation(
    name = "CreateResponseHeadersPolicy",
    http_method = "POST",
    http_path = "/2020-05-31/response-headers-policy",
    paginator = list()
  )
  input <- .cloudfront$create_response_headers_policy_input(ResponseHeadersPolicyConfig = ResponseHeadersPolicyConfig)
  output <- .cloudfront$create_response_headers_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_response_headers_policy <- cloudfront_create_response_headers_policy

#' This API is deprecated
#'
#' @description
#' This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, read the announcement on the Amazon CloudFront discussion forum.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_streaming_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_create_streaming_distribution/) for full documentation.
#'
#' @param StreamingDistributionConfig &#91;required&#93; The streaming distribution's configuration information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_streaming_distribution
cloudfront_create_streaming_distribution <- function(StreamingDistributionConfig) {
  op <- new_operation(
    name = "CreateStreamingDistribution",
    http_method = "POST",
    http_path = "/2020-05-31/streaming-distribution",
    paginator = list()
  )
  input <- .cloudfront$create_streaming_distribution_input(StreamingDistributionConfig = StreamingDistributionConfig)
  output <- .cloudfront$create_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_streaming_distribution <- cloudfront_create_streaming_distribution

#' This API is deprecated
#'
#' @description
#' This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, read the announcement on the Amazon CloudFront discussion forum.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_create_streaming_distribution_with_tags/](https://www.paws-r-sdk.com/docs/cloudfront_create_streaming_distribution_with_tags/) for full documentation.
#'
#' @param StreamingDistributionConfigWithTags &#91;required&#93; The streaming distribution's configuration information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_streaming_distribution_with_tags
cloudfront_create_streaming_distribution_with_tags <- function(StreamingDistributionConfigWithTags) {
  op <- new_operation(
    name = "CreateStreamingDistributionWithTags",
    http_method = "POST",
    http_path = "/2020-05-31/streaming-distribution?WithTags",
    paginator = list()
  )
  input <- .cloudfront$create_streaming_distribution_with_tags_input(StreamingDistributionConfigWithTags = StreamingDistributionConfigWithTags)
  output <- .cloudfront$create_streaming_distribution_with_tags_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_streaming_distribution_with_tags <- cloudfront_create_streaming_distribution_with_tags

#' Deletes a cache policy
#'
#' @description
#' Deletes a cache policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_cache_policy/](https://www.paws-r-sdk.com/docs/cloudfront_delete_cache_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier for the cache policy that you are deleting. To get
#' the identifier, you can use
#' [`list_cache_policies`][cloudfront_list_cache_policies].
#' @param IfMatch The version of the cache policy that you are deleting. The version is
#' the cache policy's `ETag` value, which you can get using
#' [`list_cache_policies`][cloudfront_list_cache_policies],
#' [`get_cache_policy`][cloudfront_get_cache_policy], or
#' [`get_cache_policy_config`][cloudfront_get_cache_policy_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_cache_policy
cloudfront_delete_cache_policy <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteCachePolicy",
    http_method = "DELETE",
    http_path = "/2020-05-31/cache-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_cache_policy_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_cache_policy <- cloudfront_delete_cache_policy

#' Delete an origin access identity
#'
#' @description
#' Delete an origin access identity.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_cloud_front_origin_access_identity/](https://www.paws-r-sdk.com/docs/cloudfront_delete_cloud_front_origin_access_identity/) for full documentation.
#'
#' @param Id &#91;required&#93; The origin access identity's ID.
#' @param IfMatch The value of the `ETag` header you received from a previous `GET` or
#' `PUT` request. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_cloud_front_origin_access_identity
cloudfront_delete_cloud_front_origin_access_identity <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteCloudFrontOriginAccessIdentity",
    http_method = "DELETE",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_cloud_front_origin_access_identity_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_cloud_front_origin_access_identity <- cloudfront_delete_cloud_front_origin_access_identity

#' Deletes a continuous deployment policy
#'
#' @description
#' Deletes a continuous deployment policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_continuous_deployment_policy/](https://www.paws-r-sdk.com/docs/cloudfront_delete_continuous_deployment_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the continuous deployment policy that you are
#' deleting.
#' @param IfMatch The current version (`ETag` value) of the continuous deployment policy
#' that you are deleting.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_continuous_deployment_policy
cloudfront_delete_continuous_deployment_policy <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteContinuousDeploymentPolicy",
    http_method = "DELETE",
    http_path = "/2020-05-31/continuous-deployment-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_continuous_deployment_policy_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_continuous_deployment_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_continuous_deployment_policy <- cloudfront_delete_continuous_deployment_policy

#' Delete a distribution
#'
#' @description
#' Delete a distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_delete_distribution/) for full documentation.
#'
#' @param Id &#91;required&#93; The distribution ID.
#' @param IfMatch The value of the `ETag` header that you received when you disabled the
#' distribution. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_distribution
cloudfront_delete_distribution <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteDistribution",
    http_method = "DELETE",
    http_path = "/2020-05-31/distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_distribution_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_distribution <- cloudfront_delete_distribution

#' Remove a field-level encryption configuration
#'
#' @description
#' Remove a field-level encryption configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_field_level_encryption_config/](https://www.paws-r-sdk.com/docs/cloudfront_delete_field_level_encryption_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the configuration you want to delete from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' configuration identity to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_field_level_encryption_config
cloudfront_delete_field_level_encryption_config <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteFieldLevelEncryptionConfig",
    http_method = "DELETE",
    http_path = "/2020-05-31/field-level-encryption/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_field_level_encryption_config_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_field_level_encryption_config <- cloudfront_delete_field_level_encryption_config

#' Remove a field-level encryption profile
#'
#' @description
#' Remove a field-level encryption profile.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_field_level_encryption_profile/](https://www.paws-r-sdk.com/docs/cloudfront_delete_field_level_encryption_profile/) for full documentation.
#'
#' @param Id &#91;required&#93; Request the ID of the profile you want to delete from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' profile to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_field_level_encryption_profile
cloudfront_delete_field_level_encryption_profile <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteFieldLevelEncryptionProfile",
    http_method = "DELETE",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_field_level_encryption_profile_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_field_level_encryption_profile <- cloudfront_delete_field_level_encryption_profile

#' Deletes a CloudFront function
#'
#' @description
#' Deletes a CloudFront function.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_function/](https://www.paws-r-sdk.com/docs/cloudfront_delete_function/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the function that you are deleting.
#' @param IfMatch &#91;required&#93; The current version (`ETag` value) of the function that you are
#' deleting, which you can get using
#' [`describe_function`][cloudfront_describe_function].
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_function
cloudfront_delete_function <- function(Name, IfMatch) {
  op <- new_operation(
    name = "DeleteFunction",
    http_method = "DELETE",
    http_path = "/2020-05-31/function/{Name}",
    paginator = list()
  )
  input <- .cloudfront$delete_function_input(Name = Name, IfMatch = IfMatch)
  output <- .cloudfront$delete_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_function <- cloudfront_delete_function

#' Deletes a key group
#'
#' @description
#' Deletes a key group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_key_group/](https://www.paws-r-sdk.com/docs/cloudfront_delete_key_group/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the key group that you are deleting. To get the
#' identifier, use [`list_key_groups`][cloudfront_list_key_groups].
#' @param IfMatch The version of the key group that you are deleting. The version is the
#' key group's `ETag` value. To get the `ETag`, use
#' [`get_key_group`][cloudfront_get_key_group] or
#' [`get_key_group_config`][cloudfront_get_key_group_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_key_group
cloudfront_delete_key_group <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteKeyGroup",
    http_method = "DELETE",
    http_path = "/2020-05-31/key-group/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_key_group_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_key_group <- cloudfront_delete_key_group

#' Specifies the Key Value Store to delete
#'
#' @description
#' Specifies the Key Value Store to delete.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_key_value_store/](https://www.paws-r-sdk.com/docs/cloudfront_delete_key_value_store/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Key Value Store.
#' @param IfMatch &#91;required&#93; The Key Value Store to delete, if a match occurs.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_key_value_store
cloudfront_delete_key_value_store <- function(Name, IfMatch) {
  op <- new_operation(
    name = "DeleteKeyValueStore",
    http_method = "DELETE",
    http_path = "/2020-05-31/key-value-store/{Name}",
    paginator = list()
  )
  input <- .cloudfront$delete_key_value_store_input(Name = Name, IfMatch = IfMatch)
  output <- .cloudfront$delete_key_value_store_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_key_value_store <- cloudfront_delete_key_value_store

#' Disables additional CloudWatch metrics for the specified CloudFront
#' distribution
#'
#' @description
#' Disables additional CloudWatch metrics for the specified CloudFront distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_monitoring_subscription/](https://www.paws-r-sdk.com/docs/cloudfront_delete_monitoring_subscription/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The ID of the distribution that you are disabling metrics for.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_monitoring_subscription
cloudfront_delete_monitoring_subscription <- function(DistributionId) {
  op <- new_operation(
    name = "DeleteMonitoringSubscription",
    http_method = "DELETE",
    http_path = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription/",
    paginator = list()
  )
  input <- .cloudfront$delete_monitoring_subscription_input(DistributionId = DistributionId)
  output <- .cloudfront$delete_monitoring_subscription_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_monitoring_subscription <- cloudfront_delete_monitoring_subscription

#' Deletes a CloudFront origin access control
#'
#' @description
#' Deletes a CloudFront origin access control.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_origin_access_control/](https://www.paws-r-sdk.com/docs/cloudfront_delete_origin_access_control/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier of the origin access control that you are
#' deleting.
#' @param IfMatch The current version (`ETag` value) of the origin access control that you
#' are deleting.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_origin_access_control
cloudfront_delete_origin_access_control <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteOriginAccessControl",
    http_method = "DELETE",
    http_path = "/2020-05-31/origin-access-control/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_origin_access_control_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_origin_access_control_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_origin_access_control <- cloudfront_delete_origin_access_control

#' Deletes an origin request policy
#'
#' @description
#' Deletes an origin request policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_origin_request_policy/](https://www.paws-r-sdk.com/docs/cloudfront_delete_origin_request_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier for the origin request policy that you are
#' deleting. To get the identifier, you can use
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#' @param IfMatch The version of the origin request policy that you are deleting. The
#' version is the origin request policy's `ETag` value, which you can get
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies],
#' [`get_origin_request_policy`][cloudfront_get_origin_request_policy], or
#' [`get_origin_request_policy_config`][cloudfront_get_origin_request_policy_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_origin_request_policy
cloudfront_delete_origin_request_policy <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteOriginRequestPolicy",
    http_method = "DELETE",
    http_path = "/2020-05-31/origin-request-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_origin_request_policy_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_origin_request_policy <- cloudfront_delete_origin_request_policy

#' Remove a public key you previously added to CloudFront
#'
#' @description
#' Remove a public key you previously added to CloudFront.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_public_key/](https://www.paws-r-sdk.com/docs/cloudfront_delete_public_key/) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the public key you want to remove from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' public key identity to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_public_key
cloudfront_delete_public_key <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeletePublicKey",
    http_method = "DELETE",
    http_path = "/2020-05-31/public-key/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_public_key_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_public_key <- cloudfront_delete_public_key

#' Deletes a real-time log configuration
#'
#' @description
#' Deletes a real-time log configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_realtime_log_config/](https://www.paws-r-sdk.com/docs/cloudfront_delete_realtime_log_config/) for full documentation.
#'
#' @param Name The name of the real-time log configuration to delete.
#' @param ARN The Amazon Resource Name (ARN) of the real-time log configuration to
#' delete.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_realtime_log_config
cloudfront_delete_realtime_log_config <- function(Name = NULL, ARN = NULL) {
  op <- new_operation(
    name = "DeleteRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/delete-realtime-log-config/",
    paginator = list()
  )
  input <- .cloudfront$delete_realtime_log_config_input(Name = Name, ARN = ARN)
  output <- .cloudfront$delete_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_realtime_log_config <- cloudfront_delete_realtime_log_config

#' Deletes a response headers policy
#'
#' @description
#' Deletes a response headers policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_response_headers_policy/](https://www.paws-r-sdk.com/docs/cloudfront_delete_response_headers_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier for the response headers policy that you are deleting.
#' 
#' To get the identifier, you can use
#' [`list_response_headers_policies`][cloudfront_list_response_headers_policies].
#' @param IfMatch The version of the response headers policy that you are deleting.
#' 
#' The version is the response headers policy's `ETag` value, which you can
#' get using
#' [`list_response_headers_policies`][cloudfront_list_response_headers_policies],
#' [`get_response_headers_policy`][cloudfront_get_response_headers_policy],
#' or
#' [`get_response_headers_policy_config`][cloudfront_get_response_headers_policy_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_response_headers_policy
cloudfront_delete_response_headers_policy <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteResponseHeadersPolicy",
    http_method = "DELETE",
    http_path = "/2020-05-31/response-headers-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_response_headers_policy_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_response_headers_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_response_headers_policy <- cloudfront_delete_response_headers_policy

#' Delete a streaming distribution
#'
#' @description
#' Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following steps.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_delete_streaming_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_delete_streaming_distribution/) for full documentation.
#'
#' @param Id &#91;required&#93; The distribution ID.
#' @param IfMatch The value of the `ETag` header that you received when you disabled the
#' streaming distribution. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_streaming_distribution
cloudfront_delete_streaming_distribution <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteStreamingDistribution",
    http_method = "DELETE",
    http_path = "/2020-05-31/streaming-distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_streaming_distribution_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_streaming_distribution <- cloudfront_delete_streaming_distribution

#' Gets configuration information and metadata about a CloudFront function,
#' but not the function's code
#'
#' @description
#' Gets configuration information and metadata about a CloudFront function, but not the function's code. To get a function's code, use [`get_function`][cloudfront_get_function].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_describe_function/](https://www.paws-r-sdk.com/docs/cloudfront_describe_function/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the function that you are getting information about.
#' @param Stage The function's stage, either `DEVELOPMENT` or `LIVE`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_describe_function
cloudfront_describe_function <- function(Name, Stage = NULL) {
  op <- new_operation(
    name = "DescribeFunction",
    http_method = "GET",
    http_path = "/2020-05-31/function/{Name}/describe",
    paginator = list()
  )
  input <- .cloudfront$describe_function_input(Name = Name, Stage = Stage)
  output <- .cloudfront$describe_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$describe_function <- cloudfront_describe_function

#' Specifies the Key Value Store and its configuration
#'
#' @description
#' Specifies the Key Value Store and its configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_describe_key_value_store/](https://www.paws-r-sdk.com/docs/cloudfront_describe_key_value_store/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Key Value Store.
#'
#' @keywords internal
#'
#' @rdname cloudfront_describe_key_value_store
cloudfront_describe_key_value_store <- function(Name) {
  op <- new_operation(
    name = "DescribeKeyValueStore",
    http_method = "GET",
    http_path = "/2020-05-31/key-value-store/{Name}",
    paginator = list()
  )
  input <- .cloudfront$describe_key_value_store_input(Name = Name)
  output <- .cloudfront$describe_key_value_store_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$describe_key_value_store <- cloudfront_describe_key_value_store

#' Gets a cache policy, including the following metadata:
#'
#' @description
#' Gets a cache policy, including the following metadata:
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_cache_policy/](https://www.paws-r-sdk.com/docs/cloudfront_get_cache_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier for the cache policy. If the cache policy is
#' attached to a distribution's cache behavior, you can get the policy's
#' identifier using [`list_distributions`][cloudfront_list_distributions]
#' or [`get_distribution`][cloudfront_get_distribution]. If the cache
#' policy is not attached to a cache behavior, you can get the identifier
#' using [`list_cache_policies`][cloudfront_list_cache_policies].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cache_policy
cloudfront_get_cache_policy <- function(Id) {
  op <- new_operation(
    name = "GetCachePolicy",
    http_method = "GET",
    http_path = "/2020-05-31/cache-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_cache_policy_input(Id = Id)
  output <- .cloudfront$get_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cache_policy <- cloudfront_get_cache_policy

#' Gets a cache policy configuration
#'
#' @description
#' Gets a cache policy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_cache_policy_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_cache_policy_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier for the cache policy. If the cache policy is
#' attached to a distribution's cache behavior, you can get the policy's
#' identifier using [`list_distributions`][cloudfront_list_distributions]
#' or [`get_distribution`][cloudfront_get_distribution]. If the cache
#' policy is not attached to a cache behavior, you can get the identifier
#' using [`list_cache_policies`][cloudfront_list_cache_policies].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cache_policy_config
cloudfront_get_cache_policy_config <- function(Id) {
  op <- new_operation(
    name = "GetCachePolicyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/cache-policy/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_cache_policy_config_input(Id = Id)
  output <- .cloudfront$get_cache_policy_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cache_policy_config <- cloudfront_get_cache_policy_config

#' Get the information about an origin access identity
#'
#' @description
#' Get the information about an origin access identity.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_cloud_front_origin_access_identity/](https://www.paws-r-sdk.com/docs/cloudfront_get_cloud_front_origin_access_identity/) for full documentation.
#'
#' @param Id &#91;required&#93; The identity's ID.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cloud_front_origin_access_identity
cloudfront_get_cloud_front_origin_access_identity <- function(Id) {
  op <- new_operation(
    name = "GetCloudFrontOriginAccessIdentity",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_cloud_front_origin_access_identity_input(Id = Id)
  output <- .cloudfront$get_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cloud_front_origin_access_identity <- cloudfront_get_cloud_front_origin_access_identity

#' Get the configuration information about an origin access identity
#'
#' @description
#' Get the configuration information about an origin access identity.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_cloud_front_origin_access_identity_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_cloud_front_origin_access_identity_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The identity's ID.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cloud_front_origin_access_identity_config
cloudfront_get_cloud_front_origin_access_identity_config <- function(Id) {
  op <- new_operation(
    name = "GetCloudFrontOriginAccessIdentityConfig",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_cloud_front_origin_access_identity_config_input(Id = Id)
  output <- .cloudfront$get_cloud_front_origin_access_identity_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cloud_front_origin_access_identity_config <- cloudfront_get_cloud_front_origin_access_identity_config

#' Gets a continuous deployment policy, including metadata (the policy's
#' identifier and the date and time when the policy was last modified)
#'
#' @description
#' Gets a continuous deployment policy, including metadata (the policy's identifier and the date and time when the policy was last modified).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_continuous_deployment_policy/](https://www.paws-r-sdk.com/docs/cloudfront_get_continuous_deployment_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the continuous deployment policy that you are getting.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_continuous_deployment_policy
cloudfront_get_continuous_deployment_policy <- function(Id) {
  op <- new_operation(
    name = "GetContinuousDeploymentPolicy",
    http_method = "GET",
    http_path = "/2020-05-31/continuous-deployment-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_continuous_deployment_policy_input(Id = Id)
  output <- .cloudfront$get_continuous_deployment_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_continuous_deployment_policy <- cloudfront_get_continuous_deployment_policy

#' Gets configuration information about a continuous deployment policy
#'
#' @description
#' Gets configuration information about a continuous deployment policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_continuous_deployment_policy_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_continuous_deployment_policy_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the continuous deployment policy whose configuration
#' you are getting.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_continuous_deployment_policy_config
cloudfront_get_continuous_deployment_policy_config <- function(Id) {
  op <- new_operation(
    name = "GetContinuousDeploymentPolicyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/continuous-deployment-policy/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_continuous_deployment_policy_config_input(Id = Id)
  output <- .cloudfront$get_continuous_deployment_policy_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_continuous_deployment_policy_config <- cloudfront_get_continuous_deployment_policy_config

#' Get the information about a distribution
#'
#' @description
#' Get the information about a distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_get_distribution/) for full documentation.
#'
#' @param Id &#91;required&#93; The distribution's ID. If the ID is empty, an empty distribution
#' configuration is returned.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_distribution
cloudfront_get_distribution <- function(Id) {
  op <- new_operation(
    name = "GetDistribution",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_distribution_input(Id = Id)
  output <- .cloudfront$get_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_distribution <- cloudfront_get_distribution

#' Get the configuration information about a distribution
#'
#' @description
#' Get the configuration information about a distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_distribution_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_distribution_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The distribution's ID. If the ID is empty, an empty distribution
#' configuration is returned.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_distribution_config
cloudfront_get_distribution_config <- function(Id) {
  op <- new_operation(
    name = "GetDistributionConfig",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_distribution_config_input(Id = Id)
  output <- .cloudfront$get_distribution_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_distribution_config <- cloudfront_get_distribution_config

#' Get the field-level encryption configuration information
#'
#' @description
#' Get the field-level encryption configuration information.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption/](https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption/) for full documentation.
#'
#' @param Id &#91;required&#93; Request the ID for the field-level encryption configuration information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption
cloudfront_get_field_level_encryption <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryption",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption <- cloudfront_get_field_level_encryption

#' Get the field-level encryption configuration information
#'
#' @description
#' Get the field-level encryption configuration information.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption_config/) for full documentation.
#'
#' @param Id &#91;required&#93; Request the ID for the field-level encryption configuration information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_config
cloudfront_get_field_level_encryption_config <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionConfig",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_config_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_config <- cloudfront_get_field_level_encryption_config

#' Get the field-level encryption profile information
#'
#' @description
#' Get the field-level encryption profile information.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption_profile/](https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption_profile/) for full documentation.
#'
#' @param Id &#91;required&#93; Get the ID for the field-level encryption profile information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_profile
cloudfront_get_field_level_encryption_profile <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionProfile",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_profile_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_profile <- cloudfront_get_field_level_encryption_profile

#' Get the field-level encryption profile configuration information
#'
#' @description
#' Get the field-level encryption profile configuration information.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption_profile_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_field_level_encryption_profile_config/) for full documentation.
#'
#' @param Id &#91;required&#93; Get the ID for the field-level encryption profile configuration
#' information.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_profile_config
cloudfront_get_field_level_encryption_profile_config <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionProfileConfig",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_profile_config_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_profile_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_profile_config <- cloudfront_get_field_level_encryption_profile_config

#' Gets the code of a CloudFront function
#'
#' @description
#' Gets the code of a CloudFront function. To get configuration information and metadata about a function, use [`describe_function`][cloudfront_describe_function].
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_function/](https://www.paws-r-sdk.com/docs/cloudfront_get_function/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the function whose code you are getting.
#' @param Stage The function's stage, either `DEVELOPMENT` or `LIVE`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_function
cloudfront_get_function <- function(Name, Stage = NULL) {
  op <- new_operation(
    name = "GetFunction",
    http_method = "GET",
    http_path = "/2020-05-31/function/{Name}",
    paginator = list()
  )
  input <- .cloudfront$get_function_input(Name = Name, Stage = Stage)
  output <- .cloudfront$get_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_function <- cloudfront_get_function

#' Get the information about an invalidation
#'
#' @description
#' Get the information about an invalidation.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_invalidation/](https://www.paws-r-sdk.com/docs/cloudfront_get_invalidation/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The distribution's ID.
#' @param Id &#91;required&#93; The identifier for the invalidation request, for example,
#' `IDFDVBD632BHDS5`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_invalidation
cloudfront_get_invalidation <- function(DistributionId, Id) {
  op <- new_operation(
    name = "GetInvalidation",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{DistributionId}/invalidation/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_invalidation_input(DistributionId = DistributionId, Id = Id)
  output <- .cloudfront$get_invalidation_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_invalidation <- cloudfront_get_invalidation

#' Gets a key group, including the date and time when the key group was
#' last modified
#'
#' @description
#' Gets a key group, including the date and time when the key group was last modified.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_key_group/](https://www.paws-r-sdk.com/docs/cloudfront_get_key_group/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the key group that you are getting. To get the
#' identifier, use [`list_key_groups`][cloudfront_list_key_groups].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_key_group
cloudfront_get_key_group <- function(Id) {
  op <- new_operation(
    name = "GetKeyGroup",
    http_method = "GET",
    http_path = "/2020-05-31/key-group/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_key_group_input(Id = Id)
  output <- .cloudfront$get_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_key_group <- cloudfront_get_key_group

#' Gets a key group configuration
#'
#' @description
#' Gets a key group configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_key_group_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_key_group_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the key group whose configuration you are getting. To
#' get the identifier, use [`list_key_groups`][cloudfront_list_key_groups].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_key_group_config
cloudfront_get_key_group_config <- function(Id) {
  op <- new_operation(
    name = "GetKeyGroupConfig",
    http_method = "GET",
    http_path = "/2020-05-31/key-group/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_key_group_config_input(Id = Id)
  output <- .cloudfront$get_key_group_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_key_group_config <- cloudfront_get_key_group_config

#' Gets information about whether additional CloudWatch metrics are enabled
#' for the specified CloudFront distribution
#'
#' @description
#' Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_monitoring_subscription/](https://www.paws-r-sdk.com/docs/cloudfront_get_monitoring_subscription/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The ID of the distribution that you are getting metrics information for.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_monitoring_subscription
cloudfront_get_monitoring_subscription <- function(DistributionId) {
  op <- new_operation(
    name = "GetMonitoringSubscription",
    http_method = "GET",
    http_path = "/2020-05-31/distributions/{DistributionId}/monitoring-subscription/",
    paginator = list()
  )
  input <- .cloudfront$get_monitoring_subscription_input(DistributionId = DistributionId)
  output <- .cloudfront$get_monitoring_subscription_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_monitoring_subscription <- cloudfront_get_monitoring_subscription

#' Gets a CloudFront origin access control, including its unique identifier
#'
#' @description
#' Gets a CloudFront origin access control, including its unique identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_origin_access_control/](https://www.paws-r-sdk.com/docs/cloudfront_get_origin_access_control/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier of the origin access control.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_origin_access_control
cloudfront_get_origin_access_control <- function(Id) {
  op <- new_operation(
    name = "GetOriginAccessControl",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-control/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_origin_access_control_input(Id = Id)
  output <- .cloudfront$get_origin_access_control_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_origin_access_control <- cloudfront_get_origin_access_control

#' Gets a CloudFront origin access control configuration
#'
#' @description
#' Gets a CloudFront origin access control configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_origin_access_control_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_origin_access_control_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier of the origin access control.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_origin_access_control_config
cloudfront_get_origin_access_control_config <- function(Id) {
  op <- new_operation(
    name = "GetOriginAccessControlConfig",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-control/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_origin_access_control_config_input(Id = Id)
  output <- .cloudfront$get_origin_access_control_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_origin_access_control_config <- cloudfront_get_origin_access_control_config

#' Gets an origin request policy, including the following metadata:
#'
#' @description
#' Gets an origin request policy, including the following metadata:
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_origin_request_policy/](https://www.paws-r-sdk.com/docs/cloudfront_get_origin_request_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier for the origin request policy. If the origin
#' request policy is attached to a distribution's cache behavior, you can
#' get the policy's identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the origin request
#' policy is not attached to a cache behavior, you can get the identifier
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_origin_request_policy
cloudfront_get_origin_request_policy <- function(Id) {
  op <- new_operation(
    name = "GetOriginRequestPolicy",
    http_method = "GET",
    http_path = "/2020-05-31/origin-request-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_origin_request_policy_input(Id = Id)
  output <- .cloudfront$get_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_origin_request_policy <- cloudfront_get_origin_request_policy

#' Gets an origin request policy configuration
#'
#' @description
#' Gets an origin request policy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_origin_request_policy_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_origin_request_policy_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The unique identifier for the origin request policy. If the origin
#' request policy is attached to a distribution's cache behavior, you can
#' get the policy's identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the origin request
#' policy is not attached to a cache behavior, you can get the identifier
#' using
#' [`list_origin_request_policies`][cloudfront_list_origin_request_policies].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_origin_request_policy_config
cloudfront_get_origin_request_policy_config <- function(Id) {
  op <- new_operation(
    name = "GetOriginRequestPolicyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/origin-request-policy/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_origin_request_policy_config_input(Id = Id)
  output <- .cloudfront$get_origin_request_policy_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_origin_request_policy_config <- cloudfront_get_origin_request_policy_config

#' Gets a public key
#'
#' @description
#' Gets a public key.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_public_key/](https://www.paws-r-sdk.com/docs/cloudfront_get_public_key/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the public key you are getting.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_public_key
cloudfront_get_public_key <- function(Id) {
  op <- new_operation(
    name = "GetPublicKey",
    http_method = "GET",
    http_path = "/2020-05-31/public-key/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_public_key_input(Id = Id)
  output <- .cloudfront$get_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_public_key <- cloudfront_get_public_key

#' Gets a public key configuration
#'
#' @description
#' Gets a public key configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_public_key_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_public_key_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the public key whose configuration you are getting.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_public_key_config
cloudfront_get_public_key_config <- function(Id) {
  op <- new_operation(
    name = "GetPublicKeyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/public-key/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_public_key_config_input(Id = Id)
  output <- .cloudfront$get_public_key_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_public_key_config <- cloudfront_get_public_key_config

#' Gets a real-time log configuration
#'
#' @description
#' Gets a real-time log configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_realtime_log_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_realtime_log_config/) for full documentation.
#'
#' @param Name The name of the real-time log configuration to get.
#' @param ARN The Amazon Resource Name (ARN) of the real-time log configuration to
#' get.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_realtime_log_config
cloudfront_get_realtime_log_config <- function(Name = NULL, ARN = NULL) {
  op <- new_operation(
    name = "GetRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/get-realtime-log-config/",
    paginator = list()
  )
  input <- .cloudfront$get_realtime_log_config_input(Name = Name, ARN = ARN)
  output <- .cloudfront$get_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_realtime_log_config <- cloudfront_get_realtime_log_config

#' Gets a response headers policy, including metadata (the policy's
#' identifier and the date and time when the policy was last modified)
#'
#' @description
#' Gets a response headers policy, including metadata (the policy's identifier and the date and time when the policy was last modified).
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_response_headers_policy/](https://www.paws-r-sdk.com/docs/cloudfront_get_response_headers_policy/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier for the response headers policy.
#' 
#' If the response headers policy is attached to a distribution's cache
#' behavior, you can get the policy's identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the response
#' headers policy is not attached to a cache behavior, you can get the
#' identifier using
#' [`list_response_headers_policies`][cloudfront_list_response_headers_policies].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_response_headers_policy
cloudfront_get_response_headers_policy <- function(Id) {
  op <- new_operation(
    name = "GetResponseHeadersPolicy",
    http_method = "GET",
    http_path = "/2020-05-31/response-headers-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_response_headers_policy_input(Id = Id)
  output <- .cloudfront$get_response_headers_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_response_headers_policy <- cloudfront_get_response_headers_policy

#' Gets a response headers policy configuration
#'
#' @description
#' Gets a response headers policy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_response_headers_policy_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_response_headers_policy_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier for the response headers policy.
#' 
#' If the response headers policy is attached to a distribution's cache
#' behavior, you can get the policy's identifier using
#' [`list_distributions`][cloudfront_list_distributions] or
#' [`get_distribution`][cloudfront_get_distribution]. If the response
#' headers policy is not attached to a cache behavior, you can get the
#' identifier using
#' [`list_response_headers_policies`][cloudfront_list_response_headers_policies].
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_response_headers_policy_config
cloudfront_get_response_headers_policy_config <- function(Id) {
  op <- new_operation(
    name = "GetResponseHeadersPolicyConfig",
    http_method = "GET",
    http_path = "/2020-05-31/response-headers-policy/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_response_headers_policy_config_input(Id = Id)
  output <- .cloudfront$get_response_headers_policy_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_response_headers_policy_config <- cloudfront_get_response_headers_policy_config

#' Gets information about a specified RTMP distribution, including the
#' distribution configuration
#'
#' @description
#' Gets information about a specified RTMP distribution, including the distribution configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_streaming_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_get_streaming_distribution/) for full documentation.
#'
#' @param Id &#91;required&#93; The streaming distribution's ID.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_streaming_distribution
cloudfront_get_streaming_distribution <- function(Id) {
  op <- new_operation(
    name = "GetStreamingDistribution",
    http_method = "GET",
    http_path = "/2020-05-31/streaming-distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_streaming_distribution_input(Id = Id)
  output <- .cloudfront$get_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_streaming_distribution <- cloudfront_get_streaming_distribution

#' Get the configuration information about a streaming distribution
#'
#' @description
#' Get the configuration information about a streaming distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_get_streaming_distribution_config/](https://www.paws-r-sdk.com/docs/cloudfront_get_streaming_distribution_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The streaming distribution's ID.
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_streaming_distribution_config
cloudfront_get_streaming_distribution_config <- function(Id) {
  op <- new_operation(
    name = "GetStreamingDistributionConfig",
    http_method = "GET",
    http_path = "/2020-05-31/streaming-distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_streaming_distribution_config_input(Id = Id)
  output <- .cloudfront$get_streaming_distribution_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_streaming_distribution_config <- cloudfront_get_streaming_distribution_config

#' Gets a list of cache policies
#'
#' @description
#' Gets a list of cache policies.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_cache_policies/](https://www.paws-r-sdk.com/docs/cloudfront_list_cache_policies/) for full documentation.
#'
#' @param Type A filter to return only the specified kinds of cache policies. Valid
#' values are:
#' 
#' -   `managed` – Returns only the managed policies created by Amazon Web
#'     Services.
#' 
#' -   `custom` – Returns only the custom policies created in your Amazon
#'     Web Services account.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of cache policies. The response includes cache policies in the
#' list that occur after the marker. To get the next page of the list, set
#' this field's value to the value of `NextMarker` from the current page's
#' response.
#' @param MaxItems The maximum number of cache policies that you want in the response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_cache_policies
cloudfront_list_cache_policies <- function(Type = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCachePolicies",
    http_method = "GET",
    http_path = "/2020-05-31/cache-policy",
    paginator = list()
  )
  input <- .cloudfront$list_cache_policies_input(Type = Type, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_cache_policies_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_cache_policies <- cloudfront_list_cache_policies

#' Lists origin access identities
#'
#' @description
#' Lists origin access identities.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_cloud_front_origin_access_identities/](https://www.paws-r-sdk.com/docs/cloudfront_list_cloud_front_origin_access_identities/) for full documentation.
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of origin access identities. The results include identities in the list
#' that occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page's
#' response (which is also the ID of the last identity on that page).
#' @param MaxItems The maximum number of origin access identities you want in the response
#' body.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_cloud_front_origin_access_identities
cloudfront_list_cloud_front_origin_access_identities <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCloudFrontOriginAccessIdentities",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-identity/cloudfront",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "CloudFrontOriginAccessIdentityList.IsTruncated", output_token = "CloudFrontOriginAccessIdentityList.NextMarker", result_key = "CloudFrontOriginAccessIdentityList.Items")
  )
  input <- .cloudfront$list_cloud_front_origin_access_identities_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_cloud_front_origin_access_identities_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_cloud_front_origin_access_identities <- cloudfront_list_cloud_front_origin_access_identities

#' Gets a list of aliases (also called CNAMEs or alternate domain names)
#' that conflict or overlap with the provided alias, and the associated
#' CloudFront distributions and Amazon Web Services accounts for each
#' conflicting alias
#'
#' @description
#' Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias. In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the distributions and accounts that you own, but helps to protect the information of ones that you don't own.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_conflicting_aliases/](https://www.paws-r-sdk.com/docs/cloudfront_list_conflicting_aliases/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The ID of a distribution in your account that has an attached SSL/TLS
#' certificate that includes the provided alias.
#' @param Alias &#91;required&#93; The alias (also called a CNAME) to search for conflicting aliases.
#' @param Marker Use this field when paginating results to indicate where to begin in the
#' list of conflicting aliases. The response includes conflicting aliases
#' in the list that occur after the marker. To get the next page of the
#' list, set this field's value to the value of `NextMarker` from the
#' current page's response.
#' @param MaxItems The maximum number of conflicting aliases that you want in the response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_conflicting_aliases
cloudfront_list_conflicting_aliases <- function(DistributionId, Alias, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListConflictingAliases",
    http_method = "GET",
    http_path = "/2020-05-31/conflicting-alias",
    paginator = list()
  )
  input <- .cloudfront$list_conflicting_aliases_input(DistributionId = DistributionId, Alias = Alias, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_conflicting_aliases_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_conflicting_aliases <- cloudfront_list_conflicting_aliases

#' Gets a list of the continuous deployment policies in your Amazon Web
#' Services account
#'
#' @description
#' Gets a list of the continuous deployment policies in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_continuous_deployment_policies/](https://www.paws-r-sdk.com/docs/cloudfront_list_continuous_deployment_policies/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of continuous deployment policies. The response includes
#' policies in the list that occur after the marker. To get the next page
#' of the list, set this field's value to the value of `NextMarker` from
#' the current page's response.
#' @param MaxItems The maximum number of continuous deployment policies that you want
#' returned in the response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_continuous_deployment_policies
cloudfront_list_continuous_deployment_policies <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListContinuousDeploymentPolicies",
    http_method = "GET",
    http_path = "/2020-05-31/continuous-deployment-policy",
    paginator = list()
  )
  input <- .cloudfront$list_continuous_deployment_policies_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_continuous_deployment_policies_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_continuous_deployment_policies <- cloudfront_list_continuous_deployment_policies

#' List CloudFront distributions
#'
#' @description
#' List CloudFront distributions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions/) for full documentation.
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of distributions. The results include distributions in the list that
#' occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page's
#' response (which is also the ID of the last distribution on that page).
#' @param MaxItems The maximum number of distributions you want in the response body.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions
cloudfront_list_distributions <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListDistributions",
    http_method = "GET",
    http_path = "/2020-05-31/distribution",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "DistributionList.IsTruncated", output_token = "DistributionList.NextMarker", result_key = "DistributionList.Items")
  )
  input <- .cloudfront$list_distributions_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_distributions_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions <- cloudfront_list_distributions

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that's associated with the specified cache policy
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified cache policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_cache_policy_id/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_cache_policy_id/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field's value to the value of `NextMarker` from the current
#' page's response.
#' @param MaxItems The maximum number of distribution IDs that you want in the response.
#' @param CachePolicyId &#91;required&#93; The ID of the cache policy whose associated distribution IDs you want to
#' list.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_cache_policy_id
cloudfront_list_distributions_by_cache_policy_id <- function(Marker = NULL, MaxItems = NULL, CachePolicyId) {
  op <- new_operation(
    name = "ListDistributionsByCachePolicyId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_cache_policy_id_input(Marker = Marker, MaxItems = MaxItems, CachePolicyId = CachePolicyId)
  output <- .cloudfront$list_distributions_by_cache_policy_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_cache_policy_id <- cloudfront_list_distributions_by_cache_policy_id

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that references the specified key group
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_key_group/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_key_group/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field's value to the value of `NextMarker` from the current
#' page's response.
#' @param MaxItems The maximum number of distribution IDs that you want in the response.
#' @param KeyGroupId &#91;required&#93; The ID of the key group whose associated distribution IDs you are
#' listing.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_key_group
cloudfront_list_distributions_by_key_group <- function(Marker = NULL, MaxItems = NULL, KeyGroupId) {
  op <- new_operation(
    name = "ListDistributionsByKeyGroup",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_key_group_input(Marker = Marker, MaxItems = MaxItems, KeyGroupId = KeyGroupId)
  output <- .cloudfront$list_distributions_by_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_key_group <- cloudfront_list_distributions_by_key_group

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that's associated with the specified origin request policy
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified origin request policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_origin_request_policy_id/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_origin_request_policy_id/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field's value to the value of `NextMarker` from the current
#' page's response.
#' @param MaxItems The maximum number of distribution IDs that you want in the response.
#' @param OriginRequestPolicyId &#91;required&#93; The ID of the origin request policy whose associated distribution IDs
#' you want to list.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_origin_request_policy_id
cloudfront_list_distributions_by_origin_request_policy_id <- function(Marker = NULL, MaxItems = NULL, OriginRequestPolicyId) {
  op <- new_operation(
    name = "ListDistributionsByOriginRequestPolicyId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_origin_request_policy_id_input(Marker = Marker, MaxItems = MaxItems, OriginRequestPolicyId = OriginRequestPolicyId)
  output <- .cloudfront$list_distributions_by_origin_request_policy_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_origin_request_policy_id <- cloudfront_list_distributions_by_origin_request_policy_id

#' Gets a list of distributions that have a cache behavior that's
#' associated with the specified real-time log configuration
#'
#' @description
#' Gets a list of distributions that have a cache behavior that's associated with the specified real-time log configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_realtime_log_config/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_realtime_log_config/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distributions. The response includes distributions in the
#' list that occur after the marker. To get the next page of the list, set
#' this field's value to the value of `NextMarker` from the current page's
#' response.
#' @param MaxItems The maximum number of distributions that you want in the response.
#' @param RealtimeLogConfigName The name of the real-time log configuration whose associated
#' distributions you want to list.
#' @param RealtimeLogConfigArn The Amazon Resource Name (ARN) of the real-time log configuration whose
#' associated distributions you want to list.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_realtime_log_config
cloudfront_list_distributions_by_realtime_log_config <- function(Marker = NULL, MaxItems = NULL, RealtimeLogConfigName = NULL, RealtimeLogConfigArn = NULL) {
  op <- new_operation(
    name = "ListDistributionsByRealtimeLogConfig",
    http_method = "POST",
    http_path = "/2020-05-31/distributionsByRealtimeLogConfig/",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_realtime_log_config_input(Marker = Marker, MaxItems = MaxItems, RealtimeLogConfigName = RealtimeLogConfigName, RealtimeLogConfigArn = RealtimeLogConfigArn)
  output <- .cloudfront$list_distributions_by_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_realtime_log_config <- cloudfront_list_distributions_by_realtime_log_config

#' Gets a list of distribution IDs for distributions that have a cache
#' behavior that's associated with the specified response headers policy
#'
#' @description
#' Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified response headers policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_response_headers_policy_id/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_response_headers_policy_id/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of distribution IDs. The response includes distribution IDs in
#' the list that occur after the marker. To get the next page of the list,
#' set this field's value to the value of `NextMarker` from the current
#' page's response.
#' @param MaxItems The maximum number of distribution IDs that you want to get in the
#' response.
#' @param ResponseHeadersPolicyId &#91;required&#93; The ID of the response headers policy whose associated distribution IDs
#' you want to list.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_response_headers_policy_id
cloudfront_list_distributions_by_response_headers_policy_id <- function(Marker = NULL, MaxItems = NULL, ResponseHeadersPolicyId) {
  op <- new_operation(
    name = "ListDistributionsByResponseHeadersPolicyId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByResponseHeadersPolicyId/{ResponseHeadersPolicyId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_response_headers_policy_id_input(Marker = Marker, MaxItems = MaxItems, ResponseHeadersPolicyId = ResponseHeadersPolicyId)
  output <- .cloudfront$list_distributions_by_response_headers_policy_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_response_headers_policy_id <- cloudfront_list_distributions_by_response_headers_policy_id

#' List the distributions that are associated with a specified WAF web ACL
#'
#' @description
#' List the distributions that are associated with a specified WAF web ACL.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_web_acl_id/](https://www.paws-r-sdk.com/docs/cloudfront_list_distributions_by_web_acl_id/) for full documentation.
#'
#' @param Marker Use `Marker` and `MaxItems` to control pagination of results. If you
#' have more than `MaxItems` distributions that satisfy the request, the
#' response includes a `NextMarker` element. To get the next page of
#' results, submit another request. For the value of `Marker`, specify the
#' value of `NextMarker` from the last response. (For the first request,
#' omit `Marker`.)
#' @param MaxItems The maximum number of distributions that you want CloudFront to return
#' in the response body. The maximum and default values are both 100.
#' @param WebACLId &#91;required&#93; The ID of the WAF web ACL that you want to list the associated
#' distributions. If you specify "null" for the ID, the request returns a
#' list of the distributions that aren't associated with a web ACL.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_web_acl_id
cloudfront_list_distributions_by_web_acl_id <- function(Marker = NULL, MaxItems = NULL, WebACLId) {
  op <- new_operation(
    name = "ListDistributionsByWebACLId",
    http_method = "GET",
    http_path = "/2020-05-31/distributionsByWebACLId/{WebACLId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_web_acl_id_input(Marker = Marker, MaxItems = MaxItems, WebACLId = WebACLId)
  output <- .cloudfront$list_distributions_by_web_acl_id_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_web_acl_id <- cloudfront_list_distributions_by_web_acl_id

#' List all field-level encryption configurations that have been created in
#' CloudFront for this account
#'
#' @description
#' List all field-level encryption configurations that have been created in CloudFront for this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_field_level_encryption_configs/](https://www.paws-r-sdk.com/docs/cloudfront_list_field_level_encryption_configs/) for full documentation.
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of configurations. The results include configurations in the list that
#' occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page's
#' response (which is also the ID of the last configuration on that page).
#' @param MaxItems The maximum number of field-level encryption configurations you want in
#' the response body.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_field_level_encryption_configs
cloudfront_list_field_level_encryption_configs <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFieldLevelEncryptionConfigs",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption",
    paginator = list()
  )
  input <- .cloudfront$list_field_level_encryption_configs_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_field_level_encryption_configs_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_field_level_encryption_configs <- cloudfront_list_field_level_encryption_configs

#' Request a list of field-level encryption profiles that have been created
#' in CloudFront for this account
#'
#' @description
#' Request a list of field-level encryption profiles that have been created in CloudFront for this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_field_level_encryption_profiles/](https://www.paws-r-sdk.com/docs/cloudfront_list_field_level_encryption_profiles/) for full documentation.
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of profiles. The results include profiles in the list that occur after
#' the marker. To get the next page of results, set the `Marker` to the
#' value of the `NextMarker` from the current page's response (which is
#' also the ID of the last profile on that page).
#' @param MaxItems The maximum number of field-level encryption profiles you want in the
#' response body.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_field_level_encryption_profiles
cloudfront_list_field_level_encryption_profiles <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFieldLevelEncryptionProfiles",
    http_method = "GET",
    http_path = "/2020-05-31/field-level-encryption-profile",
    paginator = list()
  )
  input <- .cloudfront$list_field_level_encryption_profiles_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_field_level_encryption_profiles_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_field_level_encryption_profiles <- cloudfront_list_field_level_encryption_profiles

#' Gets a list of all CloudFront functions in your Amazon Web Services
#' account
#'
#' @description
#' Gets a list of all CloudFront functions in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_functions/](https://www.paws-r-sdk.com/docs/cloudfront_list_functions/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of functions. The response includes functions in the list that
#' occur after the marker. To get the next page of the list, set this
#' field's value to the value of `NextMarker` from the current page's
#' response.
#' @param MaxItems The maximum number of functions that you want in the response.
#' @param Stage An optional filter to return only the functions that are in the
#' specified stage, either `DEVELOPMENT` or `LIVE`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_functions
cloudfront_list_functions <- function(Marker = NULL, MaxItems = NULL, Stage = NULL) {
  op <- new_operation(
    name = "ListFunctions",
    http_method = "GET",
    http_path = "/2020-05-31/function",
    paginator = list()
  )
  input <- .cloudfront$list_functions_input(Marker = Marker, MaxItems = MaxItems, Stage = Stage)
  output <- .cloudfront$list_functions_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_functions <- cloudfront_list_functions

#' Lists invalidation batches
#'
#' @description
#' Lists invalidation batches.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_invalidations/](https://www.paws-r-sdk.com/docs/cloudfront_list_invalidations/) for full documentation.
#'
#' @param DistributionId &#91;required&#93; The distribution's ID.
#' @param Marker Use this parameter when paginating results to indicate where to begin in
#' your list of invalidation batches. Because the results are returned in
#' decreasing order from most recent to oldest, the most recent results are
#' on the first page, the second page will contain earlier results, and so
#' on. To get the next page of results, set `Marker` to the value of the
#' `NextMarker` from the current page's response. This value is the same as
#' the ID of the last invalidation batch on that page.
#' @param MaxItems The maximum number of invalidation batches that you want in the response
#' body.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_invalidations
cloudfront_list_invalidations <- function(DistributionId, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInvalidations",
    http_method = "GET",
    http_path = "/2020-05-31/distribution/{DistributionId}/invalidation",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "InvalidationList.IsTruncated", output_token = "InvalidationList.NextMarker", result_key = "InvalidationList.Items")
  )
  input <- .cloudfront$list_invalidations_input(DistributionId = DistributionId, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_invalidations_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_invalidations <- cloudfront_list_invalidations

#' Gets a list of key groups
#'
#' @description
#' Gets a list of key groups.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_key_groups/](https://www.paws-r-sdk.com/docs/cloudfront_list_key_groups/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of key groups. The response includes key groups in the list
#' that occur after the marker. To get the next page of the list, set this
#' field's value to the value of `NextMarker` from the current page's
#' response.
#' @param MaxItems The maximum number of key groups that you want in the response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_key_groups
cloudfront_list_key_groups <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListKeyGroups",
    http_method = "GET",
    http_path = "/2020-05-31/key-group",
    paginator = list()
  )
  input <- .cloudfront$list_key_groups_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_key_groups_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_key_groups <- cloudfront_list_key_groups

#' Specifies the Key Value Stores to list
#'
#' @description
#' Specifies the Key Value Stores to list.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_key_value_stores/](https://www.paws-r-sdk.com/docs/cloudfront_list_key_value_stores/) for full documentation.
#'
#' @param Marker The marker associated with the Key Value Stores list.
#' @param MaxItems The maximum number of items in the Key Value Stores list.
#' @param Status The status of the request for the Key Value Stores list.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_key_value_stores
cloudfront_list_key_value_stores <- function(Marker = NULL, MaxItems = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListKeyValueStores",
    http_method = "GET",
    http_path = "/2020-05-31/key-value-store",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", output_token = "KeyValueStoreList.NextMarker", result_key = "KeyValueStoreList.Items")
  )
  input <- .cloudfront$list_key_value_stores_input(Marker = Marker, MaxItems = MaxItems, Status = Status)
  output <- .cloudfront$list_key_value_stores_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_key_value_stores <- cloudfront_list_key_value_stores

#' Gets the list of CloudFront origin access controls in this Amazon Web
#' Services account
#'
#' @description
#' Gets the list of CloudFront origin access controls in this Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_origin_access_controls/](https://www.paws-r-sdk.com/docs/cloudfront_list_origin_access_controls/) for full documentation.
#'
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of origin access controls. The response includes the items in
#' the list that occur after the marker. To get the next page of the list,
#' set this field's value to the value of `NextMarker` from the current
#' page's response.
#' @param MaxItems The maximum number of origin access controls that you want in the
#' response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_origin_access_controls
cloudfront_list_origin_access_controls <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListOriginAccessControls",
    http_method = "GET",
    http_path = "/2020-05-31/origin-access-control",
    paginator = list()
  )
  input <- .cloudfront$list_origin_access_controls_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_origin_access_controls_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_origin_access_controls <- cloudfront_list_origin_access_controls

#' Gets a list of origin request policies
#'
#' @description
#' Gets a list of origin request policies.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_origin_request_policies/](https://www.paws-r-sdk.com/docs/cloudfront_list_origin_request_policies/) for full documentation.
#'
#' @param Type A filter to return only the specified kinds of origin request policies.
#' Valid values are:
#' 
#' -   `managed` – Returns only the managed policies created by Amazon Web
#'     Services.
#' 
#' -   `custom` – Returns only the custom policies created in your Amazon
#'     Web Services account.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of origin request policies. The response includes origin
#' request policies in the list that occur after the marker. To get the
#' next page of the list, set this field's value to the value of
#' `NextMarker` from the current page's response.
#' @param MaxItems The maximum number of origin request policies that you want in the
#' response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_origin_request_policies
cloudfront_list_origin_request_policies <- function(Type = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListOriginRequestPolicies",
    http_method = "GET",
    http_path = "/2020-05-31/origin-request-policy",
    paginator = list()
  )
  input <- .cloudfront$list_origin_request_policies_input(Type = Type, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_origin_request_policies_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_origin_request_policies <- cloudfront_list_origin_request_policies

#' List all public keys that have been added to CloudFront for this account
#'
#' @description
#' List all public keys that have been added to CloudFront for this account.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_public_keys/](https://www.paws-r-sdk.com/docs/cloudfront_list_public_keys/) for full documentation.
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of public keys. The results include public keys in the list that occur
#' after the marker. To get the next page of results, set the `Marker` to
#' the value of the `NextMarker` from the current page's response (which is
#' also the ID of the last public key on that page).
#' @param MaxItems The maximum number of public keys you want in the response body.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_public_keys
cloudfront_list_public_keys <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "GET",
    http_path = "/2020-05-31/public-key",
    paginator = list()
  )
  input <- .cloudfront$list_public_keys_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_public_keys_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_public_keys <- cloudfront_list_public_keys

#' Gets a list of real-time log configurations
#'
#' @description
#' Gets a list of real-time log configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_realtime_log_configs/](https://www.paws-r-sdk.com/docs/cloudfront_list_realtime_log_configs/) for full documentation.
#'
#' @param MaxItems The maximum number of real-time log configurations that you want in the
#' response.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of real-time log configurations. The response includes
#' real-time log configurations in the list that occur after the marker. To
#' get the next page of the list, set this field's value to the value of
#' `NextMarker` from the current page's response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_realtime_log_configs
cloudfront_list_realtime_log_configs <- function(MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListRealtimeLogConfigs",
    http_method = "GET",
    http_path = "/2020-05-31/realtime-log-config",
    paginator = list()
  )
  input <- .cloudfront$list_realtime_log_configs_input(MaxItems = MaxItems, Marker = Marker)
  output <- .cloudfront$list_realtime_log_configs_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_realtime_log_configs <- cloudfront_list_realtime_log_configs

#' Gets a list of response headers policies
#'
#' @description
#' Gets a list of response headers policies.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_response_headers_policies/](https://www.paws-r-sdk.com/docs/cloudfront_list_response_headers_policies/) for full documentation.
#'
#' @param Type A filter to get only the specified kind of response headers policies.
#' Valid values are:
#' 
#' -   `managed` – Gets only the managed policies created by Amazon Web
#'     Services.
#' 
#' -   `custom` – Gets only the custom policies created in your Amazon Web
#'     Services account.
#' @param Marker Use this field when paginating results to indicate where to begin in
#' your list of response headers policies. The response includes response
#' headers policies in the list that occur after the marker. To get the
#' next page of the list, set this field's value to the value of
#' `NextMarker` from the current page's response.
#' @param MaxItems The maximum number of response headers policies that you want to get in
#' the response.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_response_headers_policies
cloudfront_list_response_headers_policies <- function(Type = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListResponseHeadersPolicies",
    http_method = "GET",
    http_path = "/2020-05-31/response-headers-policy",
    paginator = list()
  )
  input <- .cloudfront$list_response_headers_policies_input(Type = Type, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_response_headers_policies_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_response_headers_policies <- cloudfront_list_response_headers_policies

#' List streaming distributions
#'
#' @description
#' List streaming distributions.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_streaming_distributions/](https://www.paws-r-sdk.com/docs/cloudfront_list_streaming_distributions/) for full documentation.
#'
#' @param Marker The value that you provided for the `Marker` request parameter.
#' @param MaxItems The value that you provided for the `MaxItems` request parameter.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_streaming_distributions
cloudfront_list_streaming_distributions <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListStreamingDistributions",
    http_method = "GET",
    http_path = "/2020-05-31/streaming-distribution",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "StreamingDistributionList.IsTruncated", output_token = "StreamingDistributionList.NextMarker", result_key = "StreamingDistributionList.Items")
  )
  input <- .cloudfront$list_streaming_distributions_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_streaming_distributions_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_streaming_distributions <- cloudfront_list_streaming_distributions

#' List tags for a CloudFront resource
#'
#' @description
#' List tags for a CloudFront resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudfront_list_tags_for_resource/) for full documentation.
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_tags_for_resource
cloudfront_list_tags_for_resource <- function(Resource) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2020-05-31/tagging",
    paginator = list()
  )
  input <- .cloudfront$list_tags_for_resource_input(Resource = Resource)
  output <- .cloudfront$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_tags_for_resource <- cloudfront_list_tags_for_resource

#' Publishes a CloudFront function by copying the function code from the
#' DEVELOPMENT stage to LIVE
#'
#' @description
#' Publishes a CloudFront function by copying the function code from the `DEVELOPMENT` stage to `LIVE`. This automatically updates all cache behaviors that are using this function to use the newly published copy in the `LIVE` stage.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_publish_function/](https://www.paws-r-sdk.com/docs/cloudfront_publish_function/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the function that you are publishing.
#' @param IfMatch &#91;required&#93; The current version (`ETag` value) of the function that you are
#' publishing, which you can get using
#' [`describe_function`][cloudfront_describe_function].
#'
#' @keywords internal
#'
#' @rdname cloudfront_publish_function
cloudfront_publish_function <- function(Name, IfMatch) {
  op <- new_operation(
    name = "PublishFunction",
    http_method = "POST",
    http_path = "/2020-05-31/function/{Name}/publish",
    paginator = list()
  )
  input <- .cloudfront$publish_function_input(Name = Name, IfMatch = IfMatch)
  output <- .cloudfront$publish_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$publish_function <- cloudfront_publish_function

#' Add tags to a CloudFront resource
#'
#' @description
#' Add tags to a CloudFront resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_tag_resource/](https://www.paws-r-sdk.com/docs/cloudfront_tag_resource/) for full documentation.
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#' @param Tags &#91;required&#93; A complex type that contains zero or more `Tag` elements.
#'
#' @keywords internal
#'
#' @rdname cloudfront_tag_resource
cloudfront_tag_resource <- function(Resource, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2020-05-31/tagging?Operation=Tag",
    paginator = list()
  )
  input <- .cloudfront$tag_resource_input(Resource = Resource, Tags = Tags)
  output <- .cloudfront$tag_resource_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$tag_resource <- cloudfront_tag_resource

#' Tests a CloudFront function
#'
#' @description
#' Tests a CloudFront function.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_test_function/](https://www.paws-r-sdk.com/docs/cloudfront_test_function/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the function that you are testing.
#' @param IfMatch &#91;required&#93; The current version (`ETag` value) of the function that you are testing,
#' which you can get using
#' [`describe_function`][cloudfront_describe_function].
#' @param Stage The stage of the function that you are testing, either `DEVELOPMENT` or
#' `LIVE`.
#' @param EventObject &#91;required&#93; The event object to test the function with. For more information about
#' the structure of the event object, see [Testing
#' functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudfront_test_function
cloudfront_test_function <- function(Name, IfMatch, Stage = NULL, EventObject) {
  op <- new_operation(
    name = "TestFunction",
    http_method = "POST",
    http_path = "/2020-05-31/function/{Name}/test",
    paginator = list()
  )
  input <- .cloudfront$test_function_input(Name = Name, IfMatch = IfMatch, Stage = Stage, EventObject = EventObject)
  output <- .cloudfront$test_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$test_function <- cloudfront_test_function

#' Remove tags from a CloudFront resource
#'
#' @description
#' Remove tags from a CloudFront resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_untag_resource/](https://www.paws-r-sdk.com/docs/cloudfront_untag_resource/) for full documentation.
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#' @param TagKeys &#91;required&#93; A complex type that contains zero or more `Tag` key elements.
#'
#' @keywords internal
#'
#' @rdname cloudfront_untag_resource
cloudfront_untag_resource <- function(Resource, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/2020-05-31/tagging?Operation=Untag",
    paginator = list()
  )
  input <- .cloudfront$untag_resource_input(Resource = Resource, TagKeys = TagKeys)
  output <- .cloudfront$untag_resource_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$untag_resource <- cloudfront_untag_resource

#' Updates a cache policy configuration
#'
#' @description
#' Updates a cache policy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_cache_policy/](https://www.paws-r-sdk.com/docs/cloudfront_update_cache_policy/) for full documentation.
#'
#' @param CachePolicyConfig &#91;required&#93; A cache policy configuration.
#' @param Id &#91;required&#93; The unique identifier for the cache policy that you are updating. The
#' identifier is returned in a cache behavior's `CachePolicyId` field in
#' the response to
#' [`get_distribution_config`][cloudfront_get_distribution_config].
#' @param IfMatch The version of the cache policy that you are updating. The version is
#' returned in the cache policy's `ETag` field in the response to
#' [`get_cache_policy_config`][cloudfront_get_cache_policy_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_cache_policy
cloudfront_update_cache_policy <- function(CachePolicyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateCachePolicy",
    http_method = "PUT",
    http_path = "/2020-05-31/cache-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_cache_policy_input(CachePolicyConfig = CachePolicyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_cache_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_cache_policy <- cloudfront_update_cache_policy

#' Update an origin access identity
#'
#' @description
#' Update an origin access identity.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_cloud_front_origin_access_identity/](https://www.paws-r-sdk.com/docs/cloudfront_update_cloud_front_origin_access_identity/) for full documentation.
#'
#' @param CloudFrontOriginAccessIdentityConfig &#91;required&#93; The identity's configuration information.
#' @param Id &#91;required&#93; The identity's id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' identity's configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_cloud_front_origin_access_identity
cloudfront_update_cloud_front_origin_access_identity <- function(CloudFrontOriginAccessIdentityConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateCloudFrontOriginAccessIdentity",
    http_method = "PUT",
    http_path = "/2020-05-31/origin-access-identity/cloudfront/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_cloud_front_origin_access_identity_input(CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_cloud_front_origin_access_identity_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_cloud_front_origin_access_identity <- cloudfront_update_cloud_front_origin_access_identity

#' Updates a continuous deployment policy
#'
#' @description
#' Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution that it sends traffic to.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_continuous_deployment_policy/](https://www.paws-r-sdk.com/docs/cloudfront_update_continuous_deployment_policy/) for full documentation.
#'
#' @param ContinuousDeploymentPolicyConfig &#91;required&#93; The continuous deployment policy configuration.
#' @param Id &#91;required&#93; The identifier of the continuous deployment policy that you are
#' updating.
#' @param IfMatch The current version (`ETag` value) of the continuous deployment policy
#' that you are updating.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_continuous_deployment_policy
cloudfront_update_continuous_deployment_policy <- function(ContinuousDeploymentPolicyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateContinuousDeploymentPolicy",
    http_method = "PUT",
    http_path = "/2020-05-31/continuous-deployment-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_continuous_deployment_policy_input(ContinuousDeploymentPolicyConfig = ContinuousDeploymentPolicyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_continuous_deployment_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_continuous_deployment_policy <- cloudfront_update_continuous_deployment_policy

#' Updates the configuration for a CloudFront distribution
#'
#' @description
#' Updates the configuration for a CloudFront distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_update_distribution/) for full documentation.
#'
#' @param DistributionConfig &#91;required&#93; The distribution's configuration information.
#' @param Id &#91;required&#93; The distribution's id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' distribution's configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_distribution
cloudfront_update_distribution <- function(DistributionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateDistribution",
    http_method = "PUT",
    http_path = "/2020-05-31/distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_distribution_input(DistributionConfig = DistributionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_distribution <- cloudfront_update_distribution

#' Copies the staging distribution's configuration to its corresponding
#' primary distribution
#'
#' @description
#' Copies the staging distribution's configuration to its corresponding primary distribution. The primary distribution retains its `Aliases` (also known as alternate domain names or CNAMEs) and `ContinuousDeploymentPolicyId` value, but otherwise its configuration is overwritten to match the staging distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_distribution_with_staging_config/](https://www.paws-r-sdk.com/docs/cloudfront_update_distribution_with_staging_config/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the primary distribution to which you are copying a
#' staging distribution's configuration.
#' @param StagingDistributionId The identifier of the staging distribution whose configuration you are
#' copying to the primary distribution.
#' @param IfMatch The current versions (`ETag` values) of both primary and staging
#' distributions. Provide these in the following format:
#' 
#' `<primary ETag>, <staging ETag>`
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_distribution_with_staging_config
cloudfront_update_distribution_with_staging_config <- function(Id, StagingDistributionId = NULL, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateDistributionWithStagingConfig",
    http_method = "PUT",
    http_path = "/2020-05-31/distribution/{Id}/promote-staging-config",
    paginator = list()
  )
  input <- .cloudfront$update_distribution_with_staging_config_input(Id = Id, StagingDistributionId = StagingDistributionId, IfMatch = IfMatch)
  output <- .cloudfront$update_distribution_with_staging_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_distribution_with_staging_config <- cloudfront_update_distribution_with_staging_config

#' Update a field-level encryption configuration
#'
#' @description
#' Update a field-level encryption configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_field_level_encryption_config/](https://www.paws-r-sdk.com/docs/cloudfront_update_field_level_encryption_config/) for full documentation.
#'
#' @param FieldLevelEncryptionConfig &#91;required&#93; Request to update a field-level encryption configuration.
#' @param Id &#91;required&#93; The ID of the configuration you want to update.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' configuration identity to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_field_level_encryption_config
cloudfront_update_field_level_encryption_config <- function(FieldLevelEncryptionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateFieldLevelEncryptionConfig",
    http_method = "PUT",
    http_path = "/2020-05-31/field-level-encryption/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_field_level_encryption_config_input(FieldLevelEncryptionConfig = FieldLevelEncryptionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_field_level_encryption_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_field_level_encryption_config <- cloudfront_update_field_level_encryption_config

#' Update a field-level encryption profile
#'
#' @description
#' Update a field-level encryption profile.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_field_level_encryption_profile/](https://www.paws-r-sdk.com/docs/cloudfront_update_field_level_encryption_profile/) for full documentation.
#'
#' @param FieldLevelEncryptionProfileConfig &#91;required&#93; Request to update a field-level encryption profile.
#' @param Id &#91;required&#93; The ID of the field-level encryption profile request.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' profile identity to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_field_level_encryption_profile
cloudfront_update_field_level_encryption_profile <- function(FieldLevelEncryptionProfileConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateFieldLevelEncryptionProfile",
    http_method = "PUT",
    http_path = "/2020-05-31/field-level-encryption-profile/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_field_level_encryption_profile_input(FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_field_level_encryption_profile_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_field_level_encryption_profile <- cloudfront_update_field_level_encryption_profile

#' Updates a CloudFront function
#'
#' @description
#' Updates a CloudFront function.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_function/](https://www.paws-r-sdk.com/docs/cloudfront_update_function/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the function that you are updating.
#' @param IfMatch &#91;required&#93; The current version (`ETag` value) of the function that you are
#' updating, which you can get using
#' [`describe_function`][cloudfront_describe_function].
#' @param FunctionConfig &#91;required&#93; Configuration information about the function.
#' @param FunctionCode &#91;required&#93; The function code. For more information about writing a CloudFront
#' function, see [Writing function code for CloudFront
#' Functions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/writing-function-code.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_function
cloudfront_update_function <- function(Name, IfMatch, FunctionConfig, FunctionCode) {
  op <- new_operation(
    name = "UpdateFunction",
    http_method = "PUT",
    http_path = "/2020-05-31/function/{Name}",
    paginator = list()
  )
  input <- .cloudfront$update_function_input(Name = Name, IfMatch = IfMatch, FunctionConfig = FunctionConfig, FunctionCode = FunctionCode)
  output <- .cloudfront$update_function_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_function <- cloudfront_update_function

#' Updates a key group
#'
#' @description
#' Updates a key group.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_key_group/](https://www.paws-r-sdk.com/docs/cloudfront_update_key_group/) for full documentation.
#'
#' @param KeyGroupConfig &#91;required&#93; The key group configuration.
#' @param Id &#91;required&#93; The identifier of the key group that you are updating.
#' @param IfMatch The version of the key group that you are updating. The version is the
#' key group's `ETag` value.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_key_group
cloudfront_update_key_group <- function(KeyGroupConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateKeyGroup",
    http_method = "PUT",
    http_path = "/2020-05-31/key-group/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_key_group_input(KeyGroupConfig = KeyGroupConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_key_group_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_key_group <- cloudfront_update_key_group

#' Specifies the Key Value Store to update
#'
#' @description
#' Specifies the Key Value Store to update.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_key_value_store/](https://www.paws-r-sdk.com/docs/cloudfront_update_key_value_store/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Key Value Store to update.
#' @param Comment &#91;required&#93; The comment of the Key Value Store to update.
#' @param IfMatch &#91;required&#93; The Key Value Store to update, if a match occurs.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_key_value_store
cloudfront_update_key_value_store <- function(Name, Comment, IfMatch) {
  op <- new_operation(
    name = "UpdateKeyValueStore",
    http_method = "PUT",
    http_path = "/2020-05-31/key-value-store/{Name}",
    paginator = list()
  )
  input <- .cloudfront$update_key_value_store_input(Name = Name, Comment = Comment, IfMatch = IfMatch)
  output <- .cloudfront$update_key_value_store_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_key_value_store <- cloudfront_update_key_value_store

#' Updates a CloudFront origin access control
#'
#' @description
#' Updates a CloudFront origin access control.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_origin_access_control/](https://www.paws-r-sdk.com/docs/cloudfront_update_origin_access_control/) for full documentation.
#'
#' @param OriginAccessControlConfig &#91;required&#93; An origin access control.
#' @param Id &#91;required&#93; The unique identifier of the origin access control that you are
#' updating.
#' @param IfMatch The current version (`ETag` value) of the origin access control that you
#' are updating.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_origin_access_control
cloudfront_update_origin_access_control <- function(OriginAccessControlConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateOriginAccessControl",
    http_method = "PUT",
    http_path = "/2020-05-31/origin-access-control/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_origin_access_control_input(OriginAccessControlConfig = OriginAccessControlConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_origin_access_control_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_origin_access_control <- cloudfront_update_origin_access_control

#' Updates an origin request policy configuration
#'
#' @description
#' Updates an origin request policy configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_origin_request_policy/](https://www.paws-r-sdk.com/docs/cloudfront_update_origin_request_policy/) for full documentation.
#'
#' @param OriginRequestPolicyConfig &#91;required&#93; An origin request policy configuration.
#' @param Id &#91;required&#93; The unique identifier for the origin request policy that you are
#' updating. The identifier is returned in a cache behavior's
#' `OriginRequestPolicyId` field in the response to
#' [`get_distribution_config`][cloudfront_get_distribution_config].
#' @param IfMatch The version of the origin request policy that you are updating. The
#' version is returned in the origin request policy's `ETag` field in the
#' response to
#' [`get_origin_request_policy_config`][cloudfront_get_origin_request_policy_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_origin_request_policy
cloudfront_update_origin_request_policy <- function(OriginRequestPolicyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateOriginRequestPolicy",
    http_method = "PUT",
    http_path = "/2020-05-31/origin-request-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_origin_request_policy_input(OriginRequestPolicyConfig = OriginRequestPolicyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_origin_request_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_origin_request_policy <- cloudfront_update_origin_request_policy

#' Update public key information
#'
#' @description
#' Update public key information. Note that the only value you can change is the comment.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_public_key/](https://www.paws-r-sdk.com/docs/cloudfront_update_public_key/) for full documentation.
#'
#' @param PublicKeyConfig &#91;required&#93; A public key configuration.
#' @param Id &#91;required&#93; The identifier of the public key that you are updating.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' public key to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_public_key
cloudfront_update_public_key <- function(PublicKeyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdatePublicKey",
    http_method = "PUT",
    http_path = "/2020-05-31/public-key/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_public_key_input(PublicKeyConfig = PublicKeyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_public_key_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_public_key <- cloudfront_update_public_key

#' Updates a real-time log configuration
#'
#' @description
#' Updates a real-time log configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_realtime_log_config/](https://www.paws-r-sdk.com/docs/cloudfront_update_realtime_log_config/) for full documentation.
#'
#' @param EndPoints Contains information about the Amazon Kinesis data stream where you are
#' sending real-time log data.
#' @param Fields A list of fields to include in each real-time log record.
#' 
#' For more information about fields, see [Real-time log configuration
#' fields](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields)
#' in the *Amazon CloudFront Developer Guide*.
#' @param Name The name for this real-time log configuration.
#' @param ARN The Amazon Resource Name (ARN) for this real-time log configuration.
#' @param SamplingRate The sampling rate for this real-time log configuration. The sampling
#' rate determines the percentage of viewer requests that are represented
#' in the real-time log data. You must provide an integer between 1 and
#' 100, inclusive.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_realtime_log_config
cloudfront_update_realtime_log_config <- function(EndPoints = NULL, Fields = NULL, Name = NULL, ARN = NULL, SamplingRate = NULL) {
  op <- new_operation(
    name = "UpdateRealtimeLogConfig",
    http_method = "PUT",
    http_path = "/2020-05-31/realtime-log-config/",
    paginator = list()
  )
  input <- .cloudfront$update_realtime_log_config_input(EndPoints = EndPoints, Fields = Fields, Name = Name, ARN = ARN, SamplingRate = SamplingRate)
  output <- .cloudfront$update_realtime_log_config_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_realtime_log_config <- cloudfront_update_realtime_log_config

#' Updates a response headers policy
#'
#' @description
#' Updates a response headers policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_response_headers_policy/](https://www.paws-r-sdk.com/docs/cloudfront_update_response_headers_policy/) for full documentation.
#'
#' @param ResponseHeadersPolicyConfig &#91;required&#93; A response headers policy configuration.
#' @param Id &#91;required&#93; The identifier for the response headers policy that you are updating.
#' @param IfMatch The version of the response headers policy that you are updating.
#' 
#' The version is returned in the cache policy's `ETag` field in the
#' response to
#' [`get_response_headers_policy_config`][cloudfront_get_response_headers_policy_config].
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_response_headers_policy
cloudfront_update_response_headers_policy <- function(ResponseHeadersPolicyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateResponseHeadersPolicy",
    http_method = "PUT",
    http_path = "/2020-05-31/response-headers-policy/{Id}",
    paginator = list()
  )
  input <- .cloudfront$update_response_headers_policy_input(ResponseHeadersPolicyConfig = ResponseHeadersPolicyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_response_headers_policy_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_response_headers_policy <- cloudfront_update_response_headers_policy

#' Update a streaming distribution
#'
#' @description
#' Update a streaming distribution.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudfront_update_streaming_distribution/](https://www.paws-r-sdk.com/docs/cloudfront_update_streaming_distribution/) for full documentation.
#'
#' @param StreamingDistributionConfig &#91;required&#93; The streaming distribution's configuration information.
#' @param Id &#91;required&#93; The streaming distribution's id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' streaming distribution's configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_streaming_distribution
cloudfront_update_streaming_distribution <- function(StreamingDistributionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateStreamingDistribution",
    http_method = "PUT",
    http_path = "/2020-05-31/streaming-distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_streaming_distribution_input(StreamingDistributionConfig = StreamingDistributionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_streaming_distribution_output()
  config <- get_config()
  svc <- .cloudfront$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_streaming_distribution <- cloudfront_update_streaming_distribution
