% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_stage}
\alias{apigatewayv2_create_stage}
\title{Creates a Stage for an API}
\usage{
apigatewayv2_create_stage(
  AccessLogSettings = NULL,
  ApiId,
  AutoDeploy = NULL,
  ClientCertificateId = NULL,
  DefaultRouteSettings = NULL,
  DeploymentId = NULL,
  Description = NULL,
  RouteSettings = NULL,
  StageName,
  StageVariables = NULL,
  Tags = NULL
)
}
\arguments{
\item{AccessLogSettings}{Settings for logging access in this stage.}

\item{ApiId}{[required] The API identifier.}

\item{AutoDeploy}{Specifies whether updates to an API automatically trigger a new
deployment. The default value is false.}

\item{ClientCertificateId}{The identifier of a client certificate for a Stage. Supported only for
WebSocket APIs.}

\item{DefaultRouteSettings}{The default route settings for the stage.}

\item{DeploymentId}{The deployment identifier of the API stage.}

\item{Description}{The description for the API stage.}

\item{RouteSettings}{Route settings for the stage, by routeKey.}

\item{StageName}{[required] The name of the stage.}

\item{StageVariables}{A map that defines the stage variables for a Stage. Variable names can
have alphanumeric and underscore characters, and the values must match
[A-Za-z0-9-._~:/?#&=,]+.}

\item{Tags}{The collection of tags. Each tag element is associated with a given
resource.}
}
\description{
Creates a Stage for an API.

See \url{https://www.paws-r-sdk.com/docs/apigatewayv2_create_stage/} for full documentation.
}
\keyword{internal}
