% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_resend_confirmation_code}
\alias{cognitoidentityprovider_resend_confirmation_code}
\title{Resends the confirmation (for confirmation of registration) to a
specific user in the user pool}
\usage{
cognitoidentityprovider_resend_confirmation_code(ClientId, SecretHash,
  UserContextData, Username, AnalyticsMetadata)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}

\item{Username}{[required] The user name of the user to whom you wish to resend a confirmation
code.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{ResendConfirmationCode} calls.}
}
\description{
Resends the confirmation (for confirmation of registration) to a
specific user in the user pool.
}
\section{Request syntax}{
\preformatted{svc$resend_confirmation_code(
  ClientId = "string",
  SecretHash = "string",
  UserContextData = list(
    EncodedData = "string"
  ),
  Username = "string",
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  )
)
}
}

\keyword{internal}
