% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_threat_intel_set}
\alias{guardduty_create_threat_intel_set}
\title{Create a new ThreatIntelSet}
\usage{
guardduty_create_threat_intel_set(Activate, ClientToken, DetectorId,
  Format, Location, Name)
}
\arguments{
\item{Activate}{[required] A boolean value that indicates whether GuardDuty is to start using the uploaded ThreatIntelSet.}

\item{ClientToken}{The idempotency token for the create request.}

\item{DetectorId}{[required] The unique ID of the detector that you want to update.}

\item{Format}{[required] The format of the file that contains the ThreatIntelSet.}

\item{Location}{[required] The URI of the file that contains the ThreatIntelSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).}

\item{Name}{[required] A user-friendly ThreatIntelSet name that is displayed in all finding generated by activity that involves IP addresses included in this ThreatIntelSet.}
}
\description{
Create a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates findings based on ThreatIntelSets.
}
\section{Request syntax}{
\preformatted{svc$create_threat_intel_set(
  Activate = TRUE|FALSE,
  ClientToken = "string",
  DetectorId = "string",
  Format = "TXT"|"STIX"|"OTX_CSV"|"ALIEN_VAULT"|"PROOF_POINT"|"FIRE_EYE",
  Location = "string",
  Name = "string"
)
}
}

\keyword{internal}
